/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiNode;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiQuery;
import org.molgenis.vcf.decisiontree.filter.model.BoolNode;
import org.molgenis.vcf.decisiontree.filter.model.BoolQuery;
import org.molgenis.vcf.decisiontree.filter.model.CategoricalNode;
import org.molgenis.vcf.decisiontree.filter.model.DecisionTree;
import org.molgenis.vcf.decisiontree.filter.model.ExistsNode;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.Label;
import org.molgenis.vcf.decisiontree.filter.model.LeafNode;
import org.molgenis.vcf.decisiontree.filter.model.Node;
import org.molgenis.vcf.decisiontree.filter.model.NodeOutcome;
import org.molgenis.vcf.decisiontree.filter.model.NodeType;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigCategoricalNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigClauseOperator;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.molgenis.vcf.decisiontree.loader.model.ConfigExistsNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigLabel;
import org.molgenis.vcf.decisiontree.loader.model.ConfigLeafNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNodeOutcome;
import org.molgenis.vcf.decisiontree.loader.model.ConfigOperator;
import org.molgenis.vcf.decisiontree.runner.DecisionTreeFactory;
import org.molgenis.vcf.decisiontree.runner.DecisionTreeFactoryImpl;
import org.molgenis.vcf.decisiontree.runner.QueryValidator;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
class DecisionTreeFactoryImpl
implements DecisionTreeFactory {
    public static final String FILE_COMMENT_CHARACTER = "#";
    private final QueryValidator queryValidator;

    DecisionTreeFactoryImpl(QueryValidator queryValidator) {
        this.queryValidator = Objects.requireNonNull(queryValidator);
    }

    public DecisionTree map(VcfMetadata vcfMetadata, Settings settings) {
        ConfigDecisionTree configDecisionTree = settings.getConfigDecisionTree();
        Map labelMap = this.mapLabels(configDecisionTree.getLabels());
        Map filesMap = this.mapFiles(configDecisionTree.getFiles());
        Map nodeMap = this.mapNodes(vcfMetadata, configDecisionTree.getNodes(), labelMap, filesMap);
        Node rootNode = (Node)nodeMap.get(configDecisionTree.getRootNode());
        return DecisionTree.builder().rootNode(rootNode).build();
    }

    private Map<String, Set<String>> mapFiles(Map<String, Path> files) {
        Map<String, Set<String>> filesMap;
        if (files == null) {
            filesMap = Collections.emptyMap();
        } else {
            filesMap = new HashMap();
            files.entrySet().forEach(entry -> filesMap.put((String)entry.getKey(), this.mapFile((Path)entry.getValue())));
        }
        return filesMap;
    }

    private Set<String> mapFile(Path path) {
        try {
            return Files.readAllLines(path).stream().filter(value -> !value.startsWith(FILE_COMMENT_CHARACTER) && !value.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, Label> mapLabels(@Nullable Map<String, ConfigLabel> configLabels) {
        Map<String, Object> labelMap = configLabels == null ? Collections.emptyMap() : configLabels.entrySet().stream().map(entry -> this.mapLabel((String)entry.getKey(), (ConfigLabel)entry.getValue())).collect(Collectors.toMap(Label::getId, Function.identity()));
        return labelMap;
    }

    private Label mapLabel(String id, ConfigLabel configLabel) {
        return Label.builder().id(id).description(configLabel.getDescription()).build();
    }

    private Map<String, Node> mapNodes(VcfMetadata vcfMetadata, Map<String, ConfigNode> configNodeMap, Map<String, Label> labelMap, Map<String, Set<String>> files) {
        Map<String, Node> nodeMap = configNodeMap.entrySet().stream().map(entry -> this.toNode(vcfMetadata, (String)entry.getKey(), (ConfigNode)entry.getValue(), files)).collect(Collectors.toMap(Node::getId, Function.identity()));
        nodeMap.values().forEach(node -> {
            ConfigNode configNode = (ConfigNode)configNodeMap.get(node.getId());
            this.updateNode(node, configNode, nodeMap, labelMap);
        });
        return nodeMap;
    }

    private Node toNode(VcfMetadata vcfMetadata, String id, ConfigNode configNode, Map<String, Set<String>> files) {
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$loader$model$ConfigNode$Type[configNode.getType().ordinal()]) {
            case 1 -> this.toExistsNode(vcfMetadata, id, (ConfigExistsNode)configNode);
            case 2 -> this.toBoolNode(vcfMetadata, id, (ConfigBoolNode)configNode, files);
            case 3 -> this.toBoolMultiNode(vcfMetadata, id, (ConfigBoolMultiNode)configNode, files);
            case 4 -> this.toCategoricalNode(vcfMetadata, id, (ConfigCategoricalNode)configNode);
            case 5 -> this.toLeafNode(id, (ConfigLeafNode)configNode);
            default -> throw new IllegalArgumentException(String.format("unexpected enum '%s'", configNode.getType().toString()));
        };
    }

    private Node toExistsNode(VcfMetadata vcfMetadata, String id, ConfigExistsNode configNode) {
        Field field = vcfMetadata.getField(configNode.getField());
        return ExistsNode.builder().id(id).label(configNode.getLabel()).field(field).description(configNode.getDescription()).build();
    }

    private BoolNode toBoolNode(VcfMetadata vcfMetadata, String id, ConfigBoolNode nodeConfig, Map<String, Set<String>> files) {
        BoolQuery boolQuery = this.toBoolQuery(vcfMetadata, nodeConfig.getQuery(), files);
        return BoolNode.builder().id(id).label(nodeConfig.getLabel()).description(nodeConfig.getDescription()).query(boolQuery).build();
    }

    private BoolQuery toBoolQuery(VcfMetadata vcfMetadata, ConfigBoolQuery configBoolQuery, Map<String, Set<String>> files) {
        BoolQuery.Operator operator = this.toOperator(configBoolQuery.getOperator());
        Field field = vcfMetadata.getField(configBoolQuery.getField());
        this.queryValidator.validateBooleanNode(configBoolQuery, field);
        Set<String> value = configBoolQuery.getValue();
        if (value.toString().startsWith("file:")) {
            value = files.get(((String)((Object)value)).substring("file:".length()));
        }
        return BoolQuery.builder().field(field).operator(operator).value((Object)value).build();
    }

    private BoolMultiNode toBoolMultiNode(VcfMetadata vcfMetadata, String id, ConfigBoolMultiNode nodeConfig, Map<String, Set<String>> files) {
        List<BoolMultiQuery> boolMultiQueries = nodeConfig.getOutcomes().stream().map(clause -> this.toBoolClause(vcfMetadata, clause, files)).toList();
        List<Field> fields = nodeConfig.getFields().stream().map(arg_0 -> ((VcfMetadata)vcfMetadata).getField(arg_0)).toList();
        return BoolMultiNode.builder().id(id).label(nodeConfig.getLabel()).fields(fields).description(nodeConfig.getDescription()).clauses(boolMultiQueries).build();
    }

    private BoolMultiQuery toBoolClause(VcfMetadata vcfMetadata, ConfigBoolMultiQuery configBoolMultiQuery, Map<String, Set<String>> files) {
        List<BoolQuery> queries = configBoolMultiQuery.getQueries().stream().map(query -> this.toBoolQuery(vcfMetadata, query, files)).toList();
        return BoolMultiQuery.builder().id(configBoolMultiQuery.getId()).queryList(queries).operator(this.toMultiQueryOperator(configBoolMultiQuery.getOperator())).build();
    }

    private BoolMultiQuery.Operator toMultiQueryOperator(ConfigClauseOperator configOperator) {
        if (configOperator == null) {
            return null;
        }
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$loader$model$ConfigClauseOperator[configOperator.ordinal()]) {
            case 1 -> BoolMultiQuery.Operator.AND;
            case 2 -> BoolMultiQuery.Operator.OR;
            default -> throw new UnexpectedEnumException((Enum)configOperator);
        };
    }

    private BoolQuery.Operator toOperator(ConfigOperator configOperator) {
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$loader$model$ConfigOperator[configOperator.ordinal()]) {
            case 1 -> BoolQuery.Operator.EQUALS;
            case 2 -> BoolQuery.Operator.NOT_EQUALS;
            case 3 -> BoolQuery.Operator.LESS;
            case 4 -> BoolQuery.Operator.LESS_OR_EQUAL;
            case 5 -> BoolQuery.Operator.GREATER;
            case 6 -> BoolQuery.Operator.GREATER_OR_EQUAL;
            case 7 -> BoolQuery.Operator.IN;
            case 8 -> BoolQuery.Operator.NOT_IN;
            case 9 -> BoolQuery.Operator.CONTAINS;
            case 10 -> BoolQuery.Operator.NOT_CONTAINS;
            case 11 -> BoolQuery.Operator.CONTAINS_ALL;
            case 12 -> BoolQuery.Operator.CONTAINS_ANY;
            case 13 -> BoolQuery.Operator.CONTAINS_NONE;
            case 14 -> BoolQuery.Operator.ANY_GREATER;
            default -> throw new UnexpectedEnumException((Enum)configOperator);
        };
    }

    private CategoricalNode toCategoricalNode(VcfMetadata vcfMetadata, String id, ConfigCategoricalNode nodeConfig) {
        Field field = vcfMetadata.getField(nodeConfig.getField());
        this.queryValidator.validateCategoricalNode(field);
        return CategoricalNode.builder().id(id).label(nodeConfig.getLabel()).description(nodeConfig.getDescription()).field(field).build();
    }

    private LeafNode toLeafNode(String id, ConfigLeafNode nodeConfig) {
        return LeafNode.builder().id(id).label(nodeConfig.getLabel()).description(nodeConfig.getDescription()).clazz(nodeConfig.getClazz()).build();
    }

    private void updateNode(Node node, ConfigNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        if (node.getNodeType() == NodeType.LEAF) {
            return;
        }
        switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$loader$model$ConfigNode$Type[configNode.getType().ordinal()]) {
            case 1: {
                this.updateExistsNode((ExistsNode)node, (ConfigExistsNode)configNode, nodeMap, labelMap);
                break;
            }
            case 2: {
                this.updateBoolNode((BoolNode)node, (ConfigBoolNode)configNode, nodeMap, labelMap);
                break;
            }
            case 3: {
                this.updateBoolMultiNode((BoolMultiNode)node, (ConfigBoolMultiNode)configNode, nodeMap, labelMap);
                break;
            }
            case 4: {
                this.updateEnumNode((CategoricalNode)node, (ConfigCategoricalNode)configNode, nodeMap, labelMap);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unexpected enum '%s'", configNode.getType().toString()));
            }
        }
    }

    private void updateExistsNode(ExistsNode node, ConfigExistsNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome outcomeTrue = this.toNodeOutcome(configNode.getOutcomeTrue(), nodeMap, labelMap);
        node.setOutcomeTrue(outcomeTrue);
        NodeOutcome outcomeFalse = this.toNodeOutcome(configNode.getOutcomeFalse(), nodeMap, labelMap);
        node.setOutcomeFalse(outcomeFalse);
    }

    private void updateBoolNode(BoolNode node, ConfigBoolNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome outcomeTrue = this.toNodeOutcome(configNode.getOutcomeTrue(), nodeMap, labelMap);
        node.setOutcomeTrue(outcomeTrue);
        NodeOutcome outcomeFalse = this.toNodeOutcome(configNode.getOutcomeFalse(), nodeMap, labelMap);
        node.setOutcomeFalse(outcomeFalse);
        NodeOutcome outcomeMissing = this.toNodeOutcome(configNode.getOutcomeMissing(), nodeMap, labelMap);
        node.setOutcomeMissing(outcomeMissing);
    }

    private void updateBoolMultiNode(BoolMultiNode node, ConfigBoolMultiNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        Map<String, ConfigBoolMultiQuery> clauses = configNode.getOutcomes().stream().collect(Collectors.toMap(ConfigBoolMultiQuery::getId, clause -> clause));
        node.setClauses(node.getClauses().stream().map(clause -> this.updateClause(clause, (ConfigBoolMultiQuery)clauses.get(clause.getId()), nodeMap, labelMap)).toList());
        NodeOutcome outcomeMissing = this.toNodeOutcome(configNode.getOutcomeMissing(), nodeMap, labelMap);
        node.setOutcomeMissing(outcomeMissing);
        NodeOutcome outcomeDefault = this.toNodeOutcome(configNode.getOutcomeDefault(), nodeMap, labelMap);
        node.setOutcomeDefault(outcomeDefault);
    }

    private BoolMultiQuery updateClause(BoolMultiQuery clause, ConfigBoolMultiQuery configBoolMultiQuery, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome outcomeDefault = this.toNodeOutcome(configBoolMultiQuery.getOutcomeTrue(), nodeMap, labelMap);
        clause.setOutcomeTrue(outcomeDefault);
        return clause;
    }

    private void updateEnumNode(CategoricalNode node, ConfigCategoricalNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        HashMap outcomeMap = new HashMap();
        configNode.getOutcomeMap().forEach((key, configOutcome) -> {
            NodeOutcome outcome = this.toNodeOutcome(configOutcome, nodeMap, labelMap);
            outcomeMap.put(key, outcome);
        });
        node.setOutcomeMap(outcomeMap);
        NodeOutcome outcomeMissing = this.toNodeOutcome(configNode.getOutcomeMissing(), nodeMap, labelMap);
        node.setOutcomeMissing(outcomeMissing);
        NodeOutcome outcomeDefault = this.toNodeOutcome(configNode.getOutcomeDefault(), nodeMap, labelMap);
        node.setOutcomeDefault(outcomeDefault);
    }

    private NodeOutcome toNodeOutcome(@Nullable ConfigNodeOutcome configNodeOutcome, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome nodeOutcome;
        if (configNodeOutcome != null) {
            Node nextNode = nodeMap.get(configNodeOutcome.getNextNode());
            Label label = labelMap.get(configNodeOutcome.getLabel());
            nodeOutcome = NodeOutcome.builder().nextNode(nextNode).label(label).build();
        } else {
            nodeOutcome = null;
        }
        return nodeOutcome;
    }
}

