/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.util.Objects;
import org.molgenis.vcf.decisiontree.filter.Classifier;
import org.molgenis.vcf.decisiontree.filter.RecordWriter;
import org.molgenis.vcf.decisiontree.filter.VcfReader;
import org.molgenis.vcf.decisiontree.runner.AppRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppRunnerImpl
implements AppRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppRunnerImpl.class);
    private final Classifier classifier;
    private final VcfReader vcfReader;
    private final RecordWriter recordWriter;

    AppRunnerImpl(Classifier classifier, VcfReader vcfReader, RecordWriter recordWriter) {
        this.classifier = Objects.requireNonNull(classifier);
        this.vcfReader = Objects.requireNonNull(vcfReader);
        this.recordWriter = Objects.requireNonNull(recordWriter);
    }

    public void run() {
        LOGGER.info("classifying variants with decision tree ...");
        this.classifier.classify(this.vcfReader);
        LOGGER.info("done");
    }

    public void close() {
        try {
            this.recordWriter.close();
        }
        catch (Exception e) {
            LOGGER.error("error closing writer", (Throwable)e);
        }
        try {
            this.vcfReader.close();
        }
        catch (Exception e) {
            LOGGER.error("error closing reader", (Throwable)e);
        }
    }
}

