/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.molgenis.vcf.decisiontree.filter.Allele;
import org.molgenis.vcf.decisiontree.filter.FlagListException;
import org.molgenis.vcf.decisiontree.filter.UnknownFieldException;
import org.molgenis.vcf.decisiontree.filter.UnsupportedFormatFieldException;
import org.molgenis.vcf.decisiontree.filter.VcfRecord;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.GenotypeFieldType;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.molgenis.vcf.decisiontree.filter.model.SampleFieldType;
import org.molgenis.vcf.decisiontree.utils.VcfUtils;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.molgenis.vcf.utils.metadata.ValueCount;
import org.molgenis.vcf.utils.metadata.ValueType;
import org.springframework.lang.Nullable;

public class VcfRecord {
    private static final List<String> PASS_FILTER = List.of("PASS");
    private VariantContext variantContext;

    public VcfRecord(VariantContext variantContext) {
        this.variantContext = Objects.requireNonNull(variantContext);
    }

    public VariantContext getVariantContext() {
        return this.variantContext;
    }

    public int getNrAltAlleles() {
        return this.variantContext.getNAlleles() - 1;
    }

    public Allele getAltAllele(int altAlleleIndex) {
        String bases = this.variantContext.getAlternateAllele(altAlleleIndex).getBaseString();
        int alleleIndex = altAlleleIndex + 1;
        return new Allele(bases, alleleIndex);
    }

    public Object getValue(Field field, Allele allele) {
        return this.getValue(field, allele, null);
    }

    public Object getValue(Field field, Allele allele, @Nullable SampleContext sampleContext) {
        FieldType fieldType = field.getFieldType();
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$FieldType[fieldType.ordinal()]) {
            case 1 -> this.getCommonValue(field, allele);
            case 2 -> this.getInfoValue(field, allele);
            case 3 -> this.getNestedVepValue(field);
            case 4 -> sampleContext != null ? this.getNestedGTValue((NestedField)field, sampleContext) : null;
            case 5 -> {
                if (sampleContext == null) {
                    throw new UnsupportedOperationException("Cannot filter on FORMAT fields when running in variant filter mode.");
                }
                yield this.getFormatField(field, sampleContext);
            }
            case 6 -> sampleContext != null ? this.getSampleValue(field, sampleContext) : null;
            default -> throw new UnexpectedEnumException((Enum)fieldType);
        };
    }

    private Object getSampleValue(Field field, SampleContext sampleContext) {
        SampleFieldType sampleField = SampleFieldType.valueOf((String)field.getId().toUpperCase());
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$SampleFieldType[sampleField.ordinal()]) {
            case 1 -> sampleContext.getId();
            case 2 -> sampleContext.getAffectedStatus().toString();
            case 3 -> sampleContext.getSex().toString();
            case 4 -> sampleContext.getFatherId();
            case 5 -> sampleContext.getMotherId();
            case 6 -> sampleContext.getFamilyId();
            case 7 -> {
                List phenotypes = sampleContext.getPhenotypes();
                yield phenotypes.isEmpty() ? null : phenotypes;
            }
            default -> throw new UnexpectedEnumException((Enum)sampleField);
        };
    }

    private Object getNestedGTValue(NestedField field, SampleContext sampleContext) {
        Genotype genotype;
        Genotype genotype2 = genotype = sampleContext != null ? this.variantContext.getGenotype(sampleContext.getIndex().intValue()) : null;
        if (genotype == null) {
            return null;
        }
        GenotypeFieldType genotypeFieldType = GenotypeFieldType.valueOf((String)field.getId());
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$GenotypeFieldType[genotypeFieldType.ordinal()]) {
            case 1 -> genotype.getAlleles().stream().map(htsjdk.variant.variantcontext.Allele::getBaseString).toList();
            case 2 -> genotype.getAlleles().stream().map(allele -> this.variantContext.getAlleles().indexOf(allele)).toList();
            case 3 -> {
                switch (1.$SwitchMap$htsjdk$variant$variantcontext$GenotypeType[genotype.getType().ordinal()]) {
                    case 1: {
                        yield GenotypeType.MIXED.name();
                    }
                    case 2: {
                        yield GenotypeType.HET.name();
                    }
                    case 3: {
                        yield GenotypeType.HOM_REF.name();
                    }
                    case 4: {
                        yield GenotypeType.HOM_VAR.name();
                    }
                    case 5: {
                        yield GenotypeType.NO_CALL.name();
                    }
                    case 6: {
                        yield GenotypeType.UNAVAILABLE.name();
                    }
                }
                throw new UnexpectedEnumException((Enum)genotype.getType());
            }
            case 4 -> genotype.isMixed();
            case 5 -> genotype.isCalled();
            case 6 -> {
                int ploidy = genotype.getPloidy();
                yield ploidy != 0 ? Integer.valueOf(ploidy) : null;
            }
            case 7 -> genotype.isPhased();
            case 8 -> genotype.isNonInformative();
            default -> throw new UnexpectedEnumException((Enum)genotypeFieldType);
        };
    }

    private Object getFormatField(Field field, SampleContext sampleContext) {
        Object typedValue;
        Genotype genotype = this.variantContext.getGenotype(sampleContext.getIndex().intValue());
        if (genotype == null) {
            return null;
        }
        switch (field.getId()) {
            case "GT": {
                String separator = genotype.isPhased() ? "|" : "/";
                typedValue = String.join((CharSequence)separator, genotype.getAlleles().stream().map(allele -> this.variantContext.getAlleles().indexOf(allele)).map(index -> this.mapAlleleString(index)).toList());
                break;
            }
            case "AD": {
                int[] ad = genotype.getAD();
                typedValue = ad != null ? IntStream.of(ad).boxed().toList() : null;
                break;
            }
            case "DP": {
                typedValue = genotype.getDP();
                if ((Integer)typedValue != -1) break;
                typedValue = null;
                break;
            }
            case "GQ": {
                int gq = genotype.getGQ();
                typedValue = gq != -1 ? Integer.valueOf(gq) : null;
                break;
            }
            case "PL": {
                int[] pl = genotype.getPL();
                typedValue = pl != null ? IntStream.of(pl).boxed().toList() : null;
                break;
            }
            default: {
                typedValue = this.getExtendedAttributeValue(field, genotype);
            }
        }
        return typedValue;
    }

    private String mapAlleleString(Integer index) {
        return index != -1 ? Integer.toString(index) : ".";
    }

    private Object getExtendedAttributeValue(Field field, Genotype genotype) {
        Object value = genotype.getExtendedAttribute(field.getId());
        if (value != null && !(value instanceof String)) {
            throw new UnsupportedFormatFieldException(value.getClass());
        }
        ValueCount valueCount = field.getValueCount();
        ValueCount.Type valueCountType = valueCount.getType();
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$metadata$ValueCount$Type[valueCountType.ordinal()]) {
            case 1, 2, 3 -> value != null ? VcfUtils.getTypedVcfListValue((Field)field, (String)value.toString()) : null;
            case 4 -> {
                if (valueCount.getCount() == 1) {
                    yield value != null ? VcfUtils.getTypedVcfValue((Field)field, (String)value.toString()) : null;
                }
                yield value != null ? VcfUtils.getTypedVcfListValue((Field)field, (String)value.toString()) : null;
            }
            default -> throw new UnexpectedEnumException((Enum)valueCountType);
        };
    }

    public List<String> getVepValues(Field vepField) {
        return this.getVariantContext().getAttributeAsStringList(vepField.getId(), "");
    }

    private Object getNestedVepValue(Field field) {
        String singleValue;
        String[] split;
        String stringValue;
        Object value = null;
        NestedField nestedField = (NestedField)field;
        String separator = Pattern.quote(nestedField.getParent().getSeparator().toString());
        int index = nestedField.getIndex();
        String parentId = nestedField.getParent().getId();
        List infoValues = VcfUtils.getInfoAsStringList((VariantContext)this.variantContext, (String)parentId, (String)".");
        if (!infoValues.isEmpty() && !(stringValue = (split = (singleValue = (String)infoValues.get(0)).split(separator, -1))[index]).isEmpty()) {
            if (field.getSeparator() != null) {
                String nestedSeparator = Pattern.quote(nestedField.getSeparator().toString());
                value = VcfUtils.getTypedVcfValue((Field)field, (String)stringValue, (String)nestedSeparator);
            } else {
                value = VcfUtils.getTypedVcfValue((Field)field, (String)stringValue);
            }
        }
        return value;
    }

    private Object getCommonValue(Field field, Allele allele) {
        return switch (field.getId()) {
            case "#CHROM" -> this.variantContext.getContig();
            case "POS" -> this.variantContext.getStart();
            case "ID" -> this.variantContext.hasID() ? Arrays.asList(this.variantContext.getID().split(";")) : Collections.emptyList();
            case "REF" -> this.variantContext.getReference().getBaseString();
            case "ALT" -> Arrays.asList(allele.getBases().split(","));
            case "QUAL" -> this.variantContext.hasLog10PError() ? Double.valueOf(this.variantContext.getPhredScaledQual()) : null;
            case "FILTER" -> this.getCommonFilterValue();
            default -> throw new UnknownFieldException(field.getId(), FieldType.COMMON);
        };
    }

    private Object getCommonFilterValue() {
        Set filters = this.variantContext.getFiltersMaybeNull();
        List<Object> value = filters == null ? Collections.emptyList() : (filters.isEmpty() ? PASS_FILTER : (filters.size() == 1 ? List.of((String)filters.iterator().next()) : new ArrayList(filters)));
        return value;
    }

    private Object getInfoValue(Field field, Allele allele) {
        ValueCount valueCount = field.getValueCount();
        ValueCount.Type valueCountType = valueCount.getType();
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$metadata$ValueCount$Type[valueCountType.ordinal()]) {
            case 1 -> {
                List aInfoList = this.getInfoList(field);
                yield !aInfoList.isEmpty() ? aInfoList.get(allele.getIndex() - 1) : null;
            }
            case 2 -> {
                List rInfoList = this.getInfoList(field);
                yield !rInfoList.isEmpty() ? rInfoList.get(allele.getIndex()) : null;
            }
            case 3 -> this.getInfoList(field);
            case 4 -> valueCount.getCount() <= 1 ? this.getInfo(field) : this.getInfoList(field);
            default -> throw new UnexpectedEnumException((Enum)valueCountType);
        };
    }

    private Object getInfo(Field field) {
        ValueType valueType = field.getValueType();
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$metadata$ValueType[valueType.ordinal()]) {
            case 1 -> VcfUtils.getInfoAsInteger((VariantContext)this.variantContext, (Field)field);
            case 2 -> VcfUtils.getInfoAsBoolean((VariantContext)this.variantContext, (Field)field);
            case 3 -> VcfUtils.getInfoAsDouble((VariantContext)this.variantContext, (Field)field);
            case 4, 5, 6 -> VcfUtils.getInfoAsString((VariantContext)this.variantContext, (Field)field);
            default -> throw new UnexpectedEnumException((Enum)valueType);
        };
    }

    private List<?> getInfoList(Field field) {
        ValueType valueType = field.getValueType();
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$metadata$ValueType[valueType.ordinal()]) {
            case 1 -> VcfUtils.getInfoAsIntegerList((VariantContext)this.variantContext, (Field)field);
            case 3 -> VcfUtils.getInfoAsDoubleList((VariantContext)this.variantContext, (Field)field);
            case 4, 5, 6 -> VcfUtils.getInfoAsStringList((VariantContext)this.variantContext, (Field)field);
            case 2 -> throw new FlagListException(field.getId());
            default -> throw new UnexpectedEnumException((Enum)valueType);
        };
    }

    public void setAttribute(Field attribute, Object value) {
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(this.variantContext);
        variantContextBuilder.attribute(attribute.getId(), value);
        this.variantContext = variantContextBuilder.make();
    }

    public VariantContext unwrap() {
        return this.variantContext;
    }

    public String toDisplayString() {
        return String.format("%s:%s %s", this.variantContext.getContig(), this.variantContext.getStart(), this.variantContext.getReference().getBaseString());
    }

    public VcfRecord getFilteredCopy(String consequence, Field vepField) {
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(this.variantContext);
        variantContextBuilder.attribute(vepField.getId(), List.of(consequence));
        VariantContext filterVariantContext = variantContextBuilder.make();
        return new VcfRecord(filterVariantContext);
    }
}

