/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.vcf.decisiontree.filter.NestedFormatHeaderLine;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.VcfRecord;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.runner.VepHelper;
import org.molgenis.vcf.decisiontree.runner.info.FormatMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.GenotypeMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.MissingVepException;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;

public class VcfReader
implements AutoCloseable {
    private final VCFFileReader vcfFileReader;
    private final VepMetadataMapper vepMetadataMapper;
    private final boolean strict;
    private final GenotypeMetadataMapper genotypeMetadataMapper;
    private final FormatMetadataMapper formatMetadataMapper;
    private boolean inited = false;
    private NestedHeaderLine vepNestedHeaderLine = null;
    private NestedHeaderLine gtNestedHeaderLine = null;
    private Map<String, Field> formatNestedHeaderLine = null;

    public VcfReader(VCFFileReader vcfFileReader, VepMetadataMapper vepMetadataMapper, GenotypeMetadataMapper genotypeMetadataMapper, FormatMetadataMapper formatMetadataMapper, boolean strict) {
        this.vcfFileReader = Objects.requireNonNull(vcfFileReader);
        this.vepMetadataMapper = Objects.requireNonNull(vepMetadataMapper);
        this.genotypeMetadataMapper = Objects.requireNonNull(genotypeMetadataMapper);
        this.formatMetadataMapper = Objects.requireNonNull(formatMetadataMapper);
        this.strict = strict;
    }

    private void initNestedMeta() {
        if (!this.inited) {
            String vepID = VepHelper.getVepId((VCFHeader)this.vcfFileReader.getHeader());
            if (vepID == null) {
                throw new MissingVepException();
            }
            this.vepNestedHeaderLine = this.vepMetadataMapper.map(vepID, this.vcfFileReader.getFileHeader());
            this.gtNestedHeaderLine = this.genotypeMetadataMapper.map();
            this.formatNestedHeaderLine = this.formatMetadataMapper.map(this.vcfFileReader.getFileHeader());
            this.inited = true;
        }
    }

    public Stream<VcfRecord> stream() {
        return StreamSupport.stream(this.vcfFileReader.spliterator(), false).map(VcfRecord::new);
    }

    public VcfMetadata getMetadata() {
        this.initNestedMeta();
        return new VcfMetadata(this.vcfFileReader.getFileHeader(), this.vepNestedHeaderLine, this.gtNestedHeaderLine, new NestedFormatHeaderLine(this.formatMetadataMapper.map(this.vcfFileReader.getHeader())), this.strict);
    }

    @Override
    public void close() {
        this.vcfFileReader.close();
    }
}

