/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import org.molgenis.vcf.decisiontree.filter.BoolMultiNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.BoolNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.CategoricalNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.ExistsNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluatorService;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluatorServiceImpl;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiNode;
import org.molgenis.vcf.decisiontree.filter.model.BoolNode;
import org.molgenis.vcf.decisiontree.filter.model.CategoricalNode;
import org.molgenis.vcf.decisiontree.filter.model.DecisionNode;
import org.molgenis.vcf.decisiontree.filter.model.DecisionType;
import org.molgenis.vcf.decisiontree.filter.model.ExistsNode;
import org.molgenis.vcf.decisiontree.filter.model.NodeOutcome;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class NodeEvaluatorServiceImpl
implements NodeEvaluatorService {
    private final BoolNodeEvaluator boolNodeEvaluator;
    private final CategoricalNodeEvaluator categoricalNodeEvaluator;
    private final ExistsNodeEvaluator existsNodeEvaluator;
    private final BoolMultiNodeEvaluator boolMultiNodeEvaluator;

    NodeEvaluatorServiceImpl() {
        this.boolNodeEvaluator = new BoolNodeEvaluator();
        this.boolMultiNodeEvaluator = new BoolMultiNodeEvaluator();
        this.categoricalNodeEvaluator = new CategoricalNodeEvaluator();
        this.existsNodeEvaluator = new ExistsNodeEvaluator();
    }

    NodeEvaluatorServiceImpl(BoolNodeEvaluator boolNodeEvaluator, BoolMultiNodeEvaluator boolMultiNodeEvaluator, CategoricalNodeEvaluator categoricalNodeEvaluator, ExistsNodeEvaluator existsNodeEvaluator) {
        this.boolNodeEvaluator = boolNodeEvaluator;
        this.boolMultiNodeEvaluator = boolMultiNodeEvaluator;
        this.categoricalNodeEvaluator = categoricalNodeEvaluator;
        this.existsNodeEvaluator = existsNodeEvaluator;
    }

    public NodeOutcome evaluate(DecisionNode node, Variant variant, @Nullable SampleContext sampleContext) {
        DecisionType decisionType = node.getDecisionType();
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$DecisionType[decisionType.ordinal()]) {
            case 1 -> this.existsNodeEvaluator.evaluate((ExistsNode)node, variant, sampleContext);
            case 2 -> this.boolNodeEvaluator.evaluate((BoolNode)node, variant, sampleContext);
            case 3 -> this.boolMultiNodeEvaluator.evaluate((BoolMultiNode)node, variant, sampleContext);
            case 4 -> this.categoricalNodeEvaluator.evaluate((CategoricalNode)node, variant, sampleContext);
            default -> throw new UnexpectedEnumException((Enum)decisionType);
        };
    }
}

