/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import htsjdk.variant.vcf.VCFHeader;
import java.util.Arrays;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.filter.ConsequenceAnnotator;
import org.molgenis.vcf.decisiontree.filter.DecisionUtils;
import org.molgenis.vcf.decisiontree.filter.UnknownFieldException;
import org.molgenis.vcf.decisiontree.filter.model.Decision;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.runner.VepHelper;
import org.molgenis.vcf.decisiontree.runner.info.MissingVepException;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConsequenceAnnotatorImpl
implements ConsequenceAnnotator {
    private final boolean writeLabels;
    private final boolean writePaths;
    private final VCFHeader annotatedHeader;
    private final VepMetadataMapper vepMetadataMapper;

    public ConsequenceAnnotatorImpl(boolean writeLabels, boolean writePaths, VCFHeader annotatedHeader, VepMetadataMapper vepMetadataMapper) {
        this.writeLabels = writeLabels;
        this.writePaths = writePaths;
        this.annotatedHeader = Objects.requireNonNull(annotatedHeader);
        this.vepMetadataMapper = Objects.requireNonNull(vepMetadataMapper);
    }

    public String annotate(Decision decision, String consequence) {
        String vepId = VepHelper.getVepId((VCFHeader)this.annotatedHeader);
        if (vepId == null) {
            throw new MissingVepException();
        }
        NestedHeaderLine vepHeaderLine = this.vepMetadataMapper.map(vepId, this.annotatedHeader);
        CharSequence[] consequenceArray = consequence.split("\\|", -1);
        Field classField = vepHeaderLine.getField("VIPC");
        consequenceArray = ConsequenceAnnotatorImpl.annotateField((String)DecisionUtils.getDecisionClass((Decision)decision), (Field)classField, (String[])consequenceArray);
        if (this.writePaths) {
            Field pathField = vepHeaderLine.getField("VIPP");
            consequenceArray = ConsequenceAnnotatorImpl.annotateField((String)DecisionUtils.getDecisionsPath((Decision)decision), (Field)pathField, (String[])consequenceArray);
        }
        if (this.writeLabels) {
            Field labelsField = vepHeaderLine.getField("VIPL");
            consequenceArray = ConsequenceAnnotatorImpl.annotateField((String)DecisionUtils.getDecisionLabelsString((Decision)decision), (Field)labelsField, (String[])consequenceArray);
        }
        return String.join((CharSequence)"|", consequenceArray);
    }

    private static String[] annotateField(String annotation, Field field, String[] consequenceArray) {
        if (field instanceof NestedField) {
            NestedField nestedField = (NestedField)field;
            int index = nestedField.getIndex();
            if (index >= consequenceArray.length) {
                consequenceArray = Arrays.copyOf(consequenceArray, index + 1);
                Arrays.fill(consequenceArray, index + 1, consequenceArray.length, "");
            }
        } else {
            throw new UnknownFieldException(field.getId(), FieldType.INFO_VEP);
        }
        consequenceArray[index] = annotation;
        return consequenceArray;
    }
}

