/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.molgenis.vcf.decisiontree.filter.Allele;
import org.molgenis.vcf.decisiontree.filter.Classifier;
import org.molgenis.vcf.decisiontree.filter.ConsequenceAnnotator;
import org.molgenis.vcf.decisiontree.filter.DecisionTreeExecutor;
import org.molgenis.vcf.decisiontree.filter.RecordWriter;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.VcfReader;
import org.molgenis.vcf.decisiontree.filter.VcfRecord;
import org.molgenis.vcf.decisiontree.filter.model.Decision;
import org.molgenis.vcf.decisiontree.filter.model.DecisionTree;
import org.molgenis.vcf.decisiontree.runner.VepHelper;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassifierImpl
implements Classifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassifierImpl.class);
    private final DecisionTreeExecutor decisionTreeExecutor;
    private final VepHelper vepHelper;
    private final DecisionTree decisionTree;
    private final VcfMetadata vcfMetadata;
    private final ConsequenceAnnotator consequenceAnnotator;
    private final RecordWriter recordWriter;

    public ClassifierImpl(DecisionTreeExecutor decisionTreeExecutor, VepHelper vepHelper, DecisionTree decisionTree, ConsequenceAnnotator consequenceAnnotator, RecordWriter recordWriter, VcfMetadata vcfMetadata) {
        this.decisionTreeExecutor = Objects.requireNonNull(decisionTreeExecutor);
        this.vepHelper = Objects.requireNonNull(vepHelper);
        this.decisionTree = Objects.requireNonNull(decisionTree);
        this.consequenceAnnotator = Objects.requireNonNull(consequenceAnnotator);
        this.recordWriter = Objects.requireNonNull(recordWriter);
        this.vcfMetadata = Objects.requireNonNull(vcfMetadata);
    }

    public void classify(VcfReader vcfReader) {
        AtomicInteger nrRecord = new AtomicInteger(0);
        vcfReader.stream().map(arg_0 -> this.processRecord(arg_0)).forEach(vcfRecord -> {
            this.recordWriter.write(vcfRecord);
            if (nrRecord.incrementAndGet() % 25000 == 0) {
                LOGGER.debug("processed {} records", (Object)nrRecord);
            }
        });
    }

    private VcfRecord processRecord(VcfRecord vcfRecord) {
        NestedHeaderLine nestedHeaderLine = this.vcfMetadata.getVepHeaderLine();
        Map alleleCsqMap = this.vepHelper.getRecordPerConsequence(vcfRecord, nestedHeaderLine);
        ArrayList<String> annotatedCsqs = new ArrayList<String>();
        for (int alleleIndex = 0; alleleIndex < vcfRecord.getNrAltAlleles(); ++alleleIndex) {
            Integer vepAlleleIndex = alleleIndex + 1;
            Allele allele = vcfRecord.getAltAllele(alleleIndex);
            List<VcfRecord> singleCsqRecords = (List<VcfRecord>)alleleCsqMap.get(vepAlleleIndex);
            if (singleCsqRecords == null || singleCsqRecords.isEmpty()) {
                singleCsqRecords = List.of(this.vepHelper.createEmptyCsqRecord(vcfRecord, vepAlleleIndex, nestedHeaderLine));
            }
            for (VcfRecord singleCsqRecord : singleCsqRecords) {
                Variant variant = new Variant(this.vcfMetadata, singleCsqRecord, allele);
                Decision decision = this.decisionTreeExecutor.execute(this.decisionTree, variant);
                String csqString = (String)singleCsqRecord.getVepValues(nestedHeaderLine.getParentField()).get(0);
                annotatedCsqs.add(this.consequenceAnnotator.annotate(decision, csqString));
            }
        }
        vcfRecord.setAttribute(nestedHeaderLine.getParentField(), annotatedCsqs);
        return vcfRecord;
    }
}

