/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import org.molgenis.vcf.decisiontree.filter.EvaluationException;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.CategoricalNode;
import org.molgenis.vcf.decisiontree.filter.model.MissingField;
import org.molgenis.vcf.decisiontree.filter.model.Node;
import org.molgenis.vcf.decisiontree.filter.model.NodeOutcome;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.springframework.lang.Nullable;

public class CategoricalNodeEvaluator
implements NodeEvaluator<CategoricalNode> {
    public NodeOutcome evaluate(CategoricalNode node, Variant variant, @Nullable SampleContext sampleContext) {
        NodeOutcome nodeOutcome;
        if (node.getField() instanceof MissingField) {
            if (node.getOutcomeMissing() != null) {
                return node.getOutcomeMissing();
            }
            throw new EvaluationException((Node)node, variant, "missing 'missingOutcome'");
        }
        Object value = variant.getValue(node.getField(), sampleContext);
        if (value != null) {
            nodeOutcome = (NodeOutcome)node.getOutcomeMap().get(value);
            if (nodeOutcome == null && (nodeOutcome = node.getOutcomeDefault()) == null) {
                throw new EvaluationException((Node)node, variant, "missing 'defaultOutcome'");
            }
        } else {
            nodeOutcome = node.getOutcomeMissing();
            if (nodeOutcome == null) {
                throw new EvaluationException((Node)node, variant, "missing 'missingOutcome'");
            }
        }
        return nodeOutcome;
    }
}

