/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import java.util.Collection;
import org.molgenis.vcf.decisiontree.filter.BaseBoolNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.BoolQuery;
import org.molgenis.vcf.decisiontree.filter.model.DecisionNode;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.springframework.lang.Nullable;

interface BaseBoolNodeEvaluator<T extends DecisionNode>
extends NodeEvaluator<T> {
    default public boolean isMissingValue(Object value) {
        return value == null || value instanceof Collection && ((Collection)value).isEmpty();
    }

    default public boolean executeQuery(BoolQuery boolQuery, Object value) {
        Field field = boolQuery.getField();
        BoolQuery.Operator operator = boolQuery.getOperator();
        Object queryValue = boolQuery.getValue();
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$BoolQuery$Operator[operator.ordinal()]) {
            case 1 -> value.equals(queryValue);
            case 2 -> !value.equals(queryValue);
            case 3 -> this.executeLessQuery(field, value, queryValue);
            case 4 -> !this.executeGreaterQuery(field, value, queryValue);
            case 5 -> this.executeGreaterQuery(field, value, queryValue);
            case 6 -> !this.executeLessQuery(field, value, queryValue);
            case 7 -> this.executeInQuery(value, (Collection)queryValue);
            case 8 -> !this.executeInQuery(value, (Collection)queryValue);
            case 9 -> this.executeContainsQuery((Collection)value, queryValue);
            case 10 -> !this.executeContainsQuery((Collection)value, queryValue);
            case 11 -> this.executeContainsAllQuery((Collection)value, (Collection)queryValue);
            case 12 -> this.executeContainsAnyQuery((Collection)value, (Collection)queryValue);
            case 13 -> this.executeContainsNoneQuery((Collection)value, (Collection)queryValue);
            case 14 -> this.executeAnyGreaterQuery((Collection)value, queryValue);
            default -> throw new UnexpectedEnumException((Enum)operator);
        };
    }

    default public boolean executeAnyGreaterQuery(Collection<?> values, Object queryValue) {
        for (Object value : values) {
            if (!((Double)value > Double.valueOf(queryValue.toString()))) continue;
            return true;
        }
        return false;
    }

    default public boolean executeLessQuery(Field field, Object value, Object queryValue) {
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$metadata$ValueType[field.getValueType().ordinal()]) {
            case 1 -> (Integer)value < (Integer)queryValue;
            case 2 -> (Double)value < (Double)queryValue;
            default -> throw new UnexpectedEnumException((Enum)field.getValueType());
        };
    }

    default public boolean executeGreaterQuery(Field field, Object value, Object queryValue) {
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$metadata$ValueType[field.getValueType().ordinal()]) {
            case 1 -> (Integer)value > (Integer)queryValue;
            case 2 -> (Double)value > (Double)queryValue;
            default -> throw new UnexpectedEnumException((Enum)field.getValueType());
        };
    }

    default public boolean executeContainsQuery(Collection<?> values, Object queryValue) {
        return values.contains(queryValue);
    }

    default public boolean executeContainsAllQuery(Collection<?> values, Collection<?> queryValues) {
        return values.containsAll(queryValues);
    }

    default public boolean executeContainsAnyQuery(Collection<?> values, Collection<?> queryValues) {
        for (Object queryValue : queryValues) {
            if (!values.contains(queryValue)) continue;
            return true;
        }
        return false;
    }

    default public boolean executeContainsNoneQuery(Collection<?> values, Collection<?> queryValues) {
        return !this.executeContainsAnyQuery(values, queryValues);
    }

    default public boolean executeInQuery(Object value, Collection<?> queryValues) {
        return queryValues.contains(value);
    }

    default public BoolQuery postProcessQuery(BoolQuery query, Variant variant, @Nullable SampleContext sampleContext) {
        String stringQueryValue = query.getValue().toString();
        if (stringQueryValue.startsWith("field:")) {
            String fieldId = stringQueryValue.substring("field:".length());
            query = BoolQuery.builder().field(query.getField()).operator(query.getOperator()).value(variant.getValue(variant.getVcfMetadata().getField(fieldId), sampleContext)).build();
        }
        return query;
    }
}

