/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.writeback;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.exceptions.WritebackException;
import uk.ac.ebi.mydas.model.DasAnnotatedSegment;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.DasFeatureOrientation;
import uk.ac.ebi.mydas.model.DasMethod;
import uk.ac.ebi.mydas.model.DasPhase;
import uk.ac.ebi.mydas.model.DasTarget;
import uk.ac.ebi.mydas.model.DasType;

public class MyDasParser {
    private XmlPullParserFactory XPP_FACTORY = null;
    private String href = null;
    public static final String ELEMENT_DASGFF = "DASGFF";
    public static final String ELEMENT_GFF = "GFF";
    public static final String ELEMENT_SEGMENT = "SEGMENT";
    public static final String ELEMENT_FEATURE = "FEATURE";
    public static final String ELEMENT_TYPE = "TYPE";
    public static final String ELEMENT_METHOD = "METHOD";
    public static final String ELEMENT_START = "START";
    public static final String ELEMENT_END = "END";
    public static final String ELEMENT_SCORE = "SCORE";
    public static final String ELEMENT_ORIENTATION = "ORIENTATION";
    public static final String ELEMENT_PHASE = "PHASE";
    public static final String ELEMENT_NOTE = "NOTE";
    public static final String ELEMENT_LINK = "LINK";
    public static final String ELEMENT_TARGET = "TARGET";
    public static final String ELEMENT_PARENT = "PARENT";
    public static final String ELEMENT_PART = "PART";
    public static final String ATT_version = "version";
    public static final String ATT_href = "href";
    public static final String ATT_id = "id";
    public static final String ATT_start = "start";
    public static final String ATT_stop = "stop";
    public static final String ATT_label = "label";
    public static final String ATT_category = "category";
    public static final String ATT_cvid = "cvId";
    public static final String ATT_reference = "reference";
    public static final String ATT_subparts = "subparts";
    public static final String ATT_superparts = "su\u1e55erparts";

    public MyDasParser(XmlPullParserFactory xmlFactory) {
        this.XPP_FACTORY = xmlFactory;
    }

    public DasAnnotatedSegment parse2MyDasModel(String content) throws WritebackException {
        DasAnnotatedSegment segment = null;
        try {
            XmlPullParser xpp = this.XPP_FACTORY.newPullParser();
            xpp.setInput((Reader)new StringReader(content));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 0) {
                    segment = this.parse2MyDasModel(xpp);
                }
                eventType = xpp.next();
            }
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: The newPullParser could not be created", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The end of the document were not reached", e);
        }
        return segment;
    }

    private DasAnnotatedSegment parse2MyDasModel(XmlPullParser xpp) throws WritebackException {
        DasAnnotatedSegment segment = null;
        try {
            while (xpp.next() != 3 || !ELEMENT_DASGFF.equals(xpp.getName())) {
                String tagName;
                if (xpp.getEventType() != 2 || !ELEMENT_GFF.equals(tagName = xpp.getName())) continue;
                segment = this.parseGFF(xpp);
            }
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: While reading to look for the DASGFF tag", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The next part of the document could not be readed while looking for DASGFF tag", e);
        }
        return segment;
    }

    private DasAnnotatedSegment parseGFF(XmlPullParser xpp) throws WritebackException {
        DasAnnotatedSegment segment = null;
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String attName = xpp.getAttributeName(i);
            if (!attName.equals(ATT_href)) continue;
            this.href = xpp.getAttributeValue(i);
        }
        try {
            while (xpp.next() != 3 || !ELEMENT_GFF.equals(xpp.getName())) {
                String tagName;
                if (xpp.getEventType() != 2 || !ELEMENT_SEGMENT.equals(tagName = xpp.getName())) continue;
                segment = this.parseSegment(xpp);
            }
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: While reading to look for the GFF tag", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The next part of the document could not be readed while looking for GFF tag", e);
        }
        return segment;
    }

    private DasAnnotatedSegment parseSegment(XmlPullParser xpp) throws WritebackException {
        DasAnnotatedSegment segment = null;
        String id = null;
        String start = null;
        String stop = null;
        String version = null;
        String label = null;
        ArrayList<DasFeature> features = null;
        try {
            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                String attName = xpp.getAttributeName(i);
                if (attName.equals(ATT_id)) {
                    id = xpp.getAttributeValue(i);
                    continue;
                }
                if (attName.equals(ATT_start)) {
                    start = xpp.getAttributeValue(i);
                    continue;
                }
                if (attName.equals(ATT_stop)) {
                    stop = xpp.getAttributeValue(i);
                    continue;
                }
                if (attName.equals(ATT_version)) {
                    version = xpp.getAttributeValue(i);
                    continue;
                }
                if (!attName.equals(ATT_label)) continue;
                label = xpp.getAttributeValue(i);
            }
            features = new ArrayList<DasFeature>();
            while (xpp.next() != 3 || !ELEMENT_SEGMENT.equals(xpp.getName())) {
                String tagName;
                if (xpp.getEventType() != 2 || !ELEMENT_FEATURE.equals(tagName = xpp.getName())) continue;
                features.add(this.parseFeature(xpp));
            }
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: While reading to look for the GFF tag", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The next part of the document could not be readed while looking for GFF tag", e);
        }
        try {
            segment = new DasAnnotatedSegment(id, new Integer(start), new Integer(stop), version, label, features);
        }
        catch (NumberFormatException e) {
            throw new WritebackException("Error parsing the document: The start(" + start + ") or the stop(" + stop + ") attribute were not converted to numbers", e);
        }
        catch (DataSourceException e) {
            throw new WritebackException("Error parsing the document: The segment was not created", e);
        }
        return segment;
    }

    private DasFeature parseFeature(XmlPullParser xpp) throws WritebackException {
        DasFeature feature = null;
        String id = null;
        String label = null;
        DasType type = null;
        DasMethod method = null;
        ArrayList<String> notes = new ArrayList<String>();
        if (this.href != null) {
            notes.add("HREF=" + this.href);
        }
        Integer start = null;
        Integer end = null;
        Double score = null;
        DasFeatureOrientation orientation = null;
        DasPhase phase = null;
        HashMap<URL, String> links = new HashMap<URL, String>();
        ArrayList<DasTarget> targets = new ArrayList<DasTarget>();
        ArrayList<String> parents = new ArrayList<String>();
        ArrayList<String> parts = new ArrayList<String>();
        try {
            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                String attName = xpp.getAttributeName(i);
                if (attName.equals(ATT_id)) {
                    id = xpp.getAttributeValue(i);
                    continue;
                }
                if (!attName.equals(ATT_label)) continue;
                label = xpp.getAttributeValue(i);
            }
            while (xpp.next() != 3 || !ELEMENT_FEATURE.equals(xpp.getName())) {
                if (xpp.getEventType() != 2) continue;
                String tagName = xpp.getName();
                if (ELEMENT_TYPE.equals(tagName)) {
                    type = this.parseType(xpp);
                    continue;
                }
                if (ELEMENT_METHOD.equals(tagName)) {
                    method = this.parseMethod(xpp);
                    continue;
                }
                if (ELEMENT_START.equals(tagName)) {
                    xpp.next();
                    try {
                        start = Integer.parseInt(xpp.getText());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new WritebackException("Error parsing the document: The start(" + start + ") attribute of the feature were not converted to numbers", e);
                    }
                }
                if (ELEMENT_END.equals(tagName)) {
                    xpp.next();
                    try {
                        end = Integer.parseInt(xpp.getText());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new WritebackException("Error parsing the document: The end(" + end + ") attribute of the feature were not converted to numbers", e);
                    }
                }
                if (ELEMENT_SCORE.equals(tagName)) {
                    xpp.next();
                    score = Double.parseDouble(xpp.getText());
                    continue;
                }
                if (ELEMENT_ORIENTATION.equals(tagName)) {
                    orientation = this.parseOrientation(xpp);
                    continue;
                }
                if (ELEMENT_PHASE.equals(tagName)) {
                    phase = this.parsePhase(xpp);
                    continue;
                }
                if (ELEMENT_NOTE.equals(tagName)) {
                    xpp.next();
                    notes.add(xpp.getText());
                    continue;
                }
                if (ELEMENT_LINK.equals(tagName)) {
                    this.addLink(links, xpp);
                    continue;
                }
                if (ELEMENT_TARGET.equals(tagName)) {
                    targets.add(this.parseTarget(xpp));
                    continue;
                }
                if (ELEMENT_PARENT.equals(tagName)) {
                    this.addParent(parents, xpp);
                    continue;
                }
                if (!ELEMENT_PART.equals(tagName)) continue;
                this.addPart(parts, xpp);
                xpp.next();
                parts.add(xpp.getAttributeValue(null, ATT_id));
            }
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: While reading to look for the GFF tag", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The next part of the document could not be readed while looking for GFF tag", e);
        }
        try {
            feature = new DasFeature(id, label, type, method, start, end, score, orientation, phase, notes, links, targets, parents, parts);
        }
        catch (DataSourceException e) {
            throw new WritebackException("Error parsing the document: The feature was not created", e);
        }
        return feature;
    }

    private DasType parseType(XmlPullParser xpp) throws WritebackException {
        DasType type = null;
        String id = null;
        String category = null;
        String cvId = null;
        String label = null;
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String attName = xpp.getAttributeName(i);
            if (attName.equals(ATT_id)) {
                id = xpp.getAttributeValue(i);
                continue;
            }
            if (attName.equals(ATT_category)) {
                category = xpp.getAttributeValue(i);
                continue;
            }
            if (!attName.equals(ATT_cvid)) continue;
            cvId = xpp.getAttributeValue(i);
        }
        try {
            xpp.next();
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: The content of the type could not be readed", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The content of the type could not be readed", e);
        }
        label = xpp.getText();
        type = new DasType(id, category, cvId, label);
        return type;
    }

    private DasMethod parseMethod(XmlPullParser xpp) throws WritebackException {
        DasMethod method = null;
        String id = null;
        String cvId = null;
        String label = null;
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String attName = xpp.getAttributeName(i);
            if (attName.equals(ATT_id)) {
                id = xpp.getAttributeValue(i);
                continue;
            }
            if (!attName.equals(ATT_cvid)) continue;
            cvId = xpp.getAttributeValue(i);
        }
        try {
            xpp.next();
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: The content of the method could not be readed", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The content of the method could not be readed", e);
        }
        label = xpp.getText();
        try {
            method = new DasMethod(id, label, cvId);
        }
        catch (DataSourceException e) {
            throw new WritebackException("Error parsing the document: The method was not created", e);
        }
        return method;
    }

    private DasFeatureOrientation parseOrientation(XmlPullParser xpp) throws WritebackException {
        try {
            xpp.next();
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: The orientation could not be readed", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The orientation could not be readed", e);
        }
        String ori = xpp.getText();
        if (ori.equals("+")) {
            return DasFeatureOrientation.ORIENTATION_SENSE_STRAND;
        }
        if (ori.equals("-")) {
            return DasFeatureOrientation.ORIENTATION_ANTISENSE_STRAND;
        }
        return DasFeatureOrientation.ORIENTATION_NOT_APPLICABLE;
    }

    private DasPhase parsePhase(XmlPullParser xpp) throws WritebackException {
        try {
            xpp.next();
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: The phase could not be readed", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The phase could not be readed", e);
        }
        String phase = xpp.getText();
        if (phase.equals("0")) {
            return DasPhase.PHASE_READING_FRAME_0;
        }
        if (phase.equals("1")) {
            return DasPhase.PHASE_READING_FRAME_1;
        }
        if (phase.equals("2")) {
            return DasPhase.PHASE_READING_FRAME_2;
        }
        return DasPhase.PHASE_NOT_APPLICABLE;
    }

    private void addLink(Map<URL, String> links, XmlPullParser xpp) throws WritebackException {
        URL url = null;
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String attName = xpp.getAttributeName(i);
            if (!attName.equals(ATT_href)) continue;
            try {
                url = new URL(xpp.getAttributeValue(i));
                continue;
            }
            catch (MalformedURLException e) {
                throw new WritebackException("Error parsing the document: The href in a link tag was not a valid URL", e);
            }
        }
        try {
            xpp.next();
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: The link could not be readed", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The link could not be readed", e);
        }
        String text = xpp.getText();
        links.put(url, text);
    }

    private DasTarget parseTarget(XmlPullParser xpp) throws WritebackException {
        String id = null;
        String label = null;
        int start = 0;
        int stop = 0;
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String attName = xpp.getAttributeName(i);
            if (attName.equals(ATT_id)) {
                id = xpp.getAttributeValue(i);
                continue;
            }
            if (attName.equals(ATT_start)) {
                start = Integer.parseInt(xpp.getAttributeValue(i));
                continue;
            }
            if (!attName.equals(ATT_stop)) continue;
            stop = Integer.parseInt(xpp.getAttributeValue(i));
        }
        try {
            xpp.next();
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("Error parsing the document: The link could not be readed", e);
        }
        catch (IOException e) {
            throw new WritebackException("Error parsing the document: The link could not be readed", e);
        }
        label = xpp.getText();
        DasTarget target = null;
        try {
            target = new DasTarget(id, start, stop, label);
        }
        catch (DataSourceException e) {
            throw new WritebackException("Error parsing the document: The target was not created", e);
        }
        return target;
    }

    private void addParent(List<String> parents, XmlPullParser xpp) {
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String attName = xpp.getAttributeName(i);
            if (!attName.equals(ATT_id)) continue;
            parents.add(xpp.getAttributeValue(i));
        }
    }

    private void addPart(List<String> parts, XmlPullParser xpp) {
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String attName = xpp.getAttributeName(i);
            if (!attName.equals(ATT_id)) continue;
            parts.add(xpp.getAttributeValue(i));
        }
    }
}

