/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.util.PriorityQueue;
import uk.ac.ebi.mydas.search.HitQueue;

public abstract class MyDasCollector
extends TopDocsCollector<ScoreDoc> {
    private static Map<String, Integer> hitsPerSegment;
    private static IndexSearcher searcher;
    ScoreDoc pqTop = (ScoreDoc)this.pq.top();
    int docBase = 0;
    Scorer scorer;

    public static MyDasCollector create(int numHits, boolean docsScoredInOrder, IndexSearcher indexSearcher) {
        hitsPerSegment = new HashMap<String, Integer>();
        searcher = indexSearcher;
        if (docsScoredInOrder) {
            return new InOrderTopScoreDocCollector(numHits);
        }
        return new OutOfOrderTopScoreDocCollector(numHits);
    }

    private MyDasCollector(int numHits) {
        super((PriorityQueue)new HitQueue(numHits, true));
    }

    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        float maxScore = Float.NaN;
        if (start == 0) {
            maxScore = results[0].score;
        } else {
            for (int i = this.pq.size(); i > 1; --i) {
                this.pq.pop();
            }
            maxScore = ((ScoreDoc)this.pq.pop()).score;
        }
        return new TopDocs(this.totalHits, results, maxScore);
    }

    public void setNextReader(IndexReader reader, int base) {
        this.docBase = base;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    public Integer getSizePerSegment(String segmentId) {
        return hitsPerSegment.get(segmentId);
    }

    private static class OutOfOrderTopScoreDocCollector
    extends MyDasCollector {
        private OutOfOrderTopScoreDocCollector(int numHits) {
            super(numHits);
        }

        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            assert (!Float.isNaN(score));
            ++this.totalHits;
            if (score < this.pqTop.score || score == this.pqTop.score && (doc += this.docBase) > this.pqTop.doc) {
                return;
            }
            this.pqTop.doc = doc;
            this.pqTop.score = score;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
            String segmentId = searcher.doc(doc).get("segmentId");
            Integer current = (Integer)hitsPerSegment.get(segmentId);
            if (null == current) {
                hitsPerSegment.put(segmentId, 1);
            } else {
                hitsPerSegment.put(segmentId, current + 1);
            }
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class InOrderTopScoreDocCollector
    extends MyDasCollector {
        private InOrderTopScoreDocCollector(int numHits) {
            super(numHits);
        }

        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            assert (score != Float.NEGATIVE_INFINITY);
            assert (!Float.isNaN(score));
            ++this.totalHits;
            if (score <= this.pqTop.score) {
                return;
            }
            this.pqTop.doc = doc + this.docBase;
            this.pqTop.score = score;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
            String segmentId = searcher.doc(doc).get("segmentId");
            Integer current = (Integer)hitsPerSegment.get(segmentId);
            if (null == current) {
                hitsPerSegment.put(segmentId, 1);
            } else {
                hitsPerSegment.put(segmentId, current + 1);
            }
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }
    }
}

