/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.search;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import uk.ac.ebi.mydas.configuration.DataSourceConfiguration;
import uk.ac.ebi.mydas.configuration.ServerConfiguration;
import uk.ac.ebi.mydas.datasource.AnnotationDataSource;
import uk.ac.ebi.mydas.exceptions.BadReferenceObjectException;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.exceptions.SearcherException;
import uk.ac.ebi.mydas.exceptions.UnimplementedFeatureException;
import uk.ac.ebi.mydas.model.DasAnnotatedSegment;
import uk.ac.ebi.mydas.model.DasEntryPoint;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.DasTarget;

public class Indexer {
    private String dirPath;
    private ServerConfiguration config;
    private static final Logger logger = Logger.getLogger(Indexer.class);

    public Indexer(String dirPath, ServerConfiguration config) {
        this.dirPath = dirPath;
        this.config = config;
    }

    public void generateIndexes() throws SearcherException {
        List<String> dsns = this.config.getDsnNames();
        if (dsns == null || dsns.size() == 0) {
            logger.error((Object)"No DSNs");
            throw new SearcherException("No datasources to query");
        }
        for (String dsn : dsns) {
            DataSourceConfiguration dsnConfig = this.config.getDataSourceConfigMap().get(dsn);
            String capabilities = dsnConfig.getCapabilities();
            if (!capabilities.contains("advanced-search")) continue;
            if (capabilities.contains("entry_points") && capabilities.contains("feature-by-id")) {
                try {
                    if (!(dsnConfig.getDataSource() instanceof AnnotationDataSource)) continue;
                    AnnotationDataSource refDsn = dsnConfig.getDataSource();
                    FSDirectory dir = FSDirectory.open((File)new File(this.dirPath + "/" + dsn));
                    IndexWriter writer = new IndexWriter((Directory)dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), true, IndexWriter.MaxFieldLength.LIMITED);
                    Integer max = dsnConfig.getMaxEntryPoints();
                    int total = refDsn.getTotalEntryPoints();
                    if (max == null) {
                        max = total;
                    }
                    for (int i = 0; i <= total; i += max.intValue()) {
                        Collection<DasEntryPoint> entryPoints = refDsn.getEntryPoints(i + 1, i + max);
                        if (entryPoints == null) {
                            throw new SearcherException("Entry points is null,The entry-point capability is not well implemented.");
                        }
                        ArrayList<DasEntryPoint> ignored = new ArrayList<DasEntryPoint>();
                        for (DasEntryPoint entryPoint : entryPoints) {
                            try {
                                this.processEntryPoint(entryPoint, refDsn, writer);
                            }
                            catch (BadReferenceObjectException e) {
                                ignored.add(entryPoint);
                            }
                        }
                        for (DasEntryPoint entryPoint : ignored) {
                            try {
                                this.processEntryPoint(entryPoint, refDsn, writer);
                            }
                            catch (BadReferenceObjectException e) {
                                logger.error((Object)("The entry point was ignored:" + entryPoint.getSegmentId()));
                            }
                        }
                    }
                    writer.optimize();
                    writer.close();
                    continue;
                }
                catch (DataSourceException e) {
                    throw new SearcherException("Error trying to query information of a data source", e);
                }
                catch (UnimplementedFeatureException e) {
                    throw new SearcherException("The Entry-Point capability is a requirenment for the searching functions", e);
                }
                catch (IOException e) {
                    throw new SearcherException("Error trying to write the index file ", e);
                }
            }
            throw new SearcherException("The capabilities 'entry-points' and 'feature-by-id' are required to be able to index");
        }
    }

    private void processEntryPoint(DasEntryPoint entryPoint, AnnotationDataSource refDsn, IndexWriter writer) throws BadReferenceObjectException, DataSourceException, CorruptIndexException, IOException {
        DasAnnotatedSegment segment = refDsn.getFeatures(entryPoint.getSegmentId(), null);
        for (DasFeature feature : segment.getFeatures()) {
            String sep;
            Document doc = new Document();
            String type = "";
            String method = "";
            String notes = "";
            String links = "";
            String targets = "";
            String parents = "";
            String parts = "";
            String segmentS = "";
            doc.add((Fieldable)new Field("segmentId", segment.getSegmentId(), Field.Store.YES, Field.Index.ANALYZED));
            segmentS = segmentS + segment.getSegmentId();
            if (segment.getSegmentLabel() != null) {
                doc.add((Fieldable)new Field("segmentLabel", segment.getSegmentLabel(), Field.Store.YES, Field.Index.ANALYZED));
                segmentS = segmentS + " " + segment.getSegmentLabel();
            }
            if (segment.getVersion() != null) {
                doc.add((Fieldable)new Field("segmentVersion", segment.getVersion(), Field.Store.YES, Field.Index.ANALYZED));
                segmentS = segmentS + " " + segment.getVersion();
            }
            if (segment.getStartCoordinate() != null) {
                doc.add((Fieldable)new Field("segmentStart", "" + segment.getStartCoordinate(), Field.Store.YES, Field.Index.ANALYZED));
                segmentS = segmentS + " " + segment.getStartCoordinate();
            }
            if (segment.getStopCoordinate() != null) {
                doc.add((Fieldable)new Field("segmentStop", "" + segment.getStopCoordinate(), Field.Store.YES, Field.Index.ANALYZED));
                segmentS = segmentS + " " + segment.getStopCoordinate();
            }
            doc.add((Fieldable)new Field("featureId", feature.getFeatureId(), Field.Store.YES, Field.Index.ANALYZED));
            if (feature.getFeatureLabel() != null) {
                doc.add((Fieldable)new Field("featureLabel", feature.getFeatureLabel(), Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getType() != null) {
                if (feature.getType().getId() != null) {
                    doc.add((Fieldable)new Field("typeId", feature.getType().getId(), Field.Store.YES, Field.Index.ANALYZED));
                    type = type + feature.getType().getId() + " ";
                }
                if (feature.getType().getCvId() != null) {
                    doc.add((Fieldable)new Field("typeCvId", feature.getType().getCvId(), Field.Store.YES, Field.Index.ANALYZED));
                    type = type + feature.getType().getCvId() + " ";
                }
                if (feature.getType().getLabel() != null) {
                    doc.add((Fieldable)new Field("typeLabel", feature.getType().getLabel(), Field.Store.YES, Field.Index.ANALYZED));
                    type = type + feature.getType().getLabel() + " ";
                }
                if (feature.getType().getCategory() != null) {
                    doc.add((Fieldable)new Field("typeCategory", feature.getType().getCategory(), Field.Store.YES, Field.Index.ANALYZED));
                    type = type + feature.getType().getCategory() + " ";
                }
                doc.add((Fieldable)new Field("type", type, Field.Store.NO, Field.Index.ANALYZED));
            }
            if (feature.getMethod() != null) {
                method = method + feature.getMethod().getId() + " ";
                doc.add((Fieldable)new Field("methodId", feature.getMethod().getId(), Field.Store.YES, Field.Index.ANALYZED));
                if (feature.getMethod().getCvId() != null) {
                    method = method + feature.getMethod().getCvId() + " ";
                    doc.add((Fieldable)new Field("methodCvId", feature.getMethod().getCvId(), Field.Store.YES, Field.Index.ANALYZED));
                }
                if (feature.getMethod().getLabel() != null) {
                    method = method + feature.getMethod().getLabel() + " ";
                    doc.add((Fieldable)new Field("methodLabel", feature.getMethod().getLabel(), Field.Store.YES, Field.Index.ANALYZED));
                }
                doc.add((Fieldable)new Field("method", method, Field.Store.NO, Field.Index.ANALYZED));
            }
            doc.add((Fieldable)new Field("start", "" + feature.getStartCoordinate(), Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("stop", "" + feature.getStopCoordinate(), Field.Store.YES, Field.Index.ANALYZED));
            if (feature.getScore() != null) {
                doc.add((Fieldable)new Field("score", "" + feature.getScore(), Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getOrientation() != null) {
                doc.add((Fieldable)new Field("orientation", "" + feature.getOrientation(), Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getPhase() != null) {
                doc.add((Fieldable)new Field("phase", "" + feature.getPhase(), Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getNotes() != null) {
                sep = "";
                for (String note : feature.getNotes()) {
                    notes = notes + sep + note;
                    sep = " ==NOTE== ";
                }
                doc.add((Fieldable)new Field("notes", notes, Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getLinks() != null) {
                sep = "";
                for (URL key : feature.getLinks().keySet()) {
                    links = links + sep + feature.getLinks().get(key) + " _-_ " + key;
                    sep = " ==LINK== ";
                }
                doc.add((Fieldable)new Field("links", links, Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getTargets() != null) {
                sep = "";
                for (DasTarget target : feature.getTargets()) {
                    targets = targets + sep + target.getTargetId();
                    targets = targets + " _-_ " + target.getStartCoordinate();
                    targets = targets + " _-_ " + target.getStopCoordinate();
                    if (target.getTargetName() != null) {
                        targets = targets + " _-_ " + target.getTargetName();
                    }
                    sep = " ==TARGET== ";
                }
                doc.add((Fieldable)new Field("targets", targets, Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getParents() != null) {
                sep = "";
                for (String parent : feature.getParents()) {
                    parents = parents + sep + parent;
                    sep = " ==PARENT== ";
                }
                doc.add((Fieldable)new Field("parents", parents, Field.Store.YES, Field.Index.ANALYZED));
            }
            if (feature.getParts() != null) {
                sep = "";
                for (String part : feature.getParts()) {
                    parts = parts + sep + part;
                    sep = " ==PART== ";
                }
                doc.add((Fieldable)new Field("parts", parts, Field.Store.YES, Field.Index.ANALYZED));
            }
            doc.add((Fieldable)new Field("all", segmentS + " " + feature.getFeatureId() + " " + type + " " + method + " " + notes + " " + links + " " + targets + " " + parents + " " + parts, Field.Store.NO, Field.Index.ANALYZED));
            writer.addDocument(doc);
        }
    }
}

