/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model.structure;

import java.io.IOException;
import java.util.Collection;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.structure.DasChain;
import uk.ac.ebi.mydas.model.structure.DasConnect;
import uk.ac.ebi.mydas.model.structure.DasObject;
import uk.ac.ebi.mydas.model.structure.ObjectDetail;

public class DasStructure {
    protected final DasObject object;
    protected final Collection<ObjectDetail> objectDetails;
    protected final Collection<DasChain> chains;
    protected final Collection<DasConnect> connects;

    public DasStructure(DasObject object, Collection<ObjectDetail> objectDetails, Collection<DasChain> chains, Collection<DasConnect> connects) throws DataSourceException {
        if (object == null) {
            throw new DataSourceException("An attempt to instantiate a DasStructure object without the minimal required mandatory values.");
        }
        this.object = object;
        this.objectDetails = objectDetails;
        this.chains = chains;
        this.connects = connects;
    }

    public void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(DAS_XML_NAMESPACE, "dasstructure");
        this.object.serialize(DAS_XML_NAMESPACE, serializer);
        if (this.objectDetails != null) {
            for (ObjectDetail objDetail : this.objectDetails) {
                objDetail.serialize(DAS_XML_NAMESPACE, serializer);
            }
        }
        if (this.chains != null) {
            for (DasChain chain : this.chains) {
                chain.serialize(DAS_XML_NAMESPACE, serializer);
            }
        }
        if (this.connects != null) {
            for (DasConnect connect : this.connects) {
                connect.serialize(DAS_XML_NAMESPACE, serializer);
            }
        }
        serializer.endTag(DAS_XML_NAMESPACE, "dasstructure");
    }
}

