/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model.structure;

import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.exceptions.DataSourceException;

public class DasObject {
    protected final String dbAccessionId;
    protected final Integer intObjectId;
    protected final String objectVersion;
    protected final String type;
    protected final String dbSource;
    protected final String dbVersion;
    protected final String dbCoordSystem;

    public DasObject(String dbAccessionId, Integer intObjectId, String objectVersion, String type, String dbSource, String dbVersion, String dbCoordSystem) throws DataSourceException {
        if (dbAccessionId == null || objectVersion == null || dbSource == null || dbVersion == null) {
            throw new DataSourceException("An attempt to instantiate a DasObject without the minimal required mandatory values.");
        }
        this.dbAccessionId = dbAccessionId;
        this.intObjectId = intObjectId;
        this.objectVersion = objectVersion;
        this.type = type;
        this.dbSource = dbSource;
        this.dbVersion = dbVersion;
        this.dbCoordSystem = dbCoordSystem;
    }

    public void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(DAS_XML_NAMESPACE, "object");
        serializer.attribute(DAS_XML_NAMESPACE, "dbAccessionId", this.dbAccessionId);
        if (this.intObjectId != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "intObjectId", this.intObjectId.toString());
        }
        serializer.attribute(DAS_XML_NAMESPACE, "objectVersion", this.objectVersion);
        if (this.type != null && this.type.length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "type", this.type);
        }
        serializer.attribute(DAS_XML_NAMESPACE, "dbSource", this.dbSource);
        serializer.attribute(DAS_XML_NAMESPACE, "dbVersion", this.dbVersion);
        if (this.dbCoordSystem != null && this.dbCoordSystem.length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "dbCoordSys", this.dbCoordSystem);
        }
        serializer.endTag(DAS_XML_NAMESPACE, "object");
    }
}

