/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model.structure;

import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.exceptions.DataSourceException;

public class DasAtom {
    protected final double x;
    protected final double y;
    protected final double z;
    protected final String atomName;
    protected final String atomId;
    protected final Double occupancy;
    protected final Double tempFactor;
    protected final String altLoc;

    public DasAtom(double x, double y, double z, String atomName, String atomId, Double occupancy, Double tempFactor, String altLoc) throws DataSourceException {
        if (atomName == null || atomId == null) {
            throw new DataSourceException("An attempt to instantiate an Atom without the minimal required mandatory values.");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.atomName = atomName;
        this.atomId = atomId;
        this.occupancy = occupancy;
        this.tempFactor = tempFactor;
        this.altLoc = altLoc;
    }

    public void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(DAS_XML_NAMESPACE, "atom");
        serializer.attribute(DAS_XML_NAMESPACE, "atomID", this.atomId);
        serializer.attribute(DAS_XML_NAMESPACE, "atomName", this.atomName);
        serializer.attribute(DAS_XML_NAMESPACE, "x", "" + this.x);
        serializer.attribute(DAS_XML_NAMESPACE, "y", "" + this.y);
        serializer.attribute(DAS_XML_NAMESPACE, "z", "" + this.z);
        if (this.occupancy != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "occupancy", this.occupancy.toString());
        }
        if (this.tempFactor != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "tempFactor", this.tempFactor.toString());
        }
        if (this.altLoc != null && this.altLoc.length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "altLoc", this.altLoc);
        }
        serializer.endTag(DAS_XML_NAMESPACE, "atom");
    }
}

