/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model.alignment;

import java.io.IOException;
import java.util.Collection;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.alignment.Segment;

public class Block {
    protected final String blockScore;
    protected final String blockOrder;
    protected final Collection<Segment> segments;

    public Block(String blockScore, String blockOrder, Collection<Segment> segments) throws DataSourceException {
        if (blockOrder == null) {
            throw new DataSourceException("An attempt to instantiate a Block object without the minimal required mandatory values.");
        }
        if (segments == null || segments.size() < 2) {
            throw new DataSourceException("An attempt to instantiate a Block object without the minimal required mandatory values.");
        }
        this.blockScore = blockScore;
        this.blockOrder = blockOrder;
        this.segments = segments;
    }

    public void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(DAS_XML_NAMESPACE, "block");
        if (this.blockScore != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "blockScore", this.blockScore);
        }
        serializer.attribute(DAS_XML_NAMESPACE, "blockOrder", this.blockOrder);
        if (this.segments != null) {
            for (Segment segment : this.segments) {
                segment.serialize(DAS_XML_NAMESPACE, serializer);
            }
        }
        serializer.endTag(DAS_XML_NAMESPACE, "block");
    }
}

