/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model.alignment;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.alignment.AlignObject;
import uk.ac.ebi.mydas.model.alignment.Block;
import uk.ac.ebi.mydas.model.alignment.Geo3D;

public class Alignment {
    protected final String alignType;
    protected final String name;
    protected final String description;
    protected final Integer position;
    protected final Integer max;
    protected final Collection<AlignObject> alignObjects;
    protected final Map<String, Double> scores;
    protected final Collection<Block> blocks;
    protected final Collection<Geo3D> geo3Ds;

    public Alignment(String alignType, String name, String description, Integer position, Integer max, Collection<AlignObject> alignObjects, Map<String, Double> scores, Collection<Block> blocks, Collection<Geo3D> geo3Ds) throws DataSourceException {
        if (alignObjects == null || alignObjects.size() < 2) {
            throw new DataSourceException("An attempt to instantiate a DasAlignment object without the minimal required mandatory values.");
        }
        if (blocks == null || blocks.size() < 1) {
            throw new DataSourceException("An attempt to instantiate a DasAlignment object without the minimal required mandatory values.");
        }
        this.alignType = alignType;
        this.name = name;
        this.description = description;
        this.position = position;
        this.max = max;
        this.alignObjects = alignObjects;
        this.scores = scores;
        this.blocks = blocks;
        this.geo3Ds = geo3Ds;
    }

    public void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(DAS_XML_NAMESPACE, "alignment");
        if (this.alignType != null && this.alignType.length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "alignType", this.alignType);
        }
        if (this.name != null && this.name.length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "name", this.name);
        }
        if (this.description != null && this.description.length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "description", this.description);
        }
        if (this.position != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "position", this.position.toString());
        }
        if (this.max != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "max", this.max.toString());
        }
        for (AlignObject alignObject : this.alignObjects) {
            alignObject.serialize(DAS_XML_NAMESPACE, serializer);
        }
        if (this.scores != null) {
            for (String key : this.scores.keySet()) {
                serializer.startTag(DAS_XML_NAMESPACE, "score");
                serializer.attribute(DAS_XML_NAMESPACE, "methodName", key);
                serializer.attribute(DAS_XML_NAMESPACE, "value", this.scores.get(key).toString());
                serializer.endTag(DAS_XML_NAMESPACE, "score");
            }
        }
        if (this.blocks != null) {
            for (Block block : this.blocks) {
                block.serialize(DAS_XML_NAMESPACE, serializer);
            }
        }
        if (this.geo3Ds != null) {
            for (Geo3D geo3D : this.geo3Ds) {
                geo3D.serialize(DAS_XML_NAMESPACE, serializer);
            }
        }
        serializer.endTag(DAS_XML_NAMESPACE, "alignment");
    }
}

