/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model.alignment;

import java.io.IOException;
import java.util.Collection;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.alignment.AlignObjectDetail;
import uk.ac.ebi.mydas.model.alignment.AlignType;

public class AlignObject {
    protected final String dbAccessionId;
    protected final String objectVersion;
    protected final String intObjectId;
    protected final AlignType type;
    protected final String dbSource;
    protected final String dbVersion;
    protected final String dbCoordSys;
    protected final Collection<AlignObjectDetail> alignObjectDetails;
    protected final String sequence;

    public AlignObject(String dbAccessionId, String objectVersion, String intObjectId, AlignType type, String dbSource, String dbVersion, String dbCoordSys, Collection<AlignObjectDetail> alignObjectDetails, String sequence) throws DataSourceException {
        if (dbAccessionId == null || objectVersion == null || intObjectId == null || dbSource == null || dbVersion == null) {
            throw new DataSourceException("An attempt to instantiate a AlignObject object without the minimal required mandatory values.");
        }
        this.dbAccessionId = dbAccessionId;
        this.objectVersion = objectVersion;
        this.intObjectId = intObjectId;
        this.type = type;
        this.dbSource = dbSource;
        this.dbVersion = dbVersion;
        this.dbCoordSys = dbCoordSys;
        this.alignObjectDetails = alignObjectDetails;
        this.sequence = sequence;
    }

    public void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(DAS_XML_NAMESPACE, "alignObject");
        serializer.attribute(DAS_XML_NAMESPACE, "dbAccessionId", this.dbAccessionId);
        serializer.attribute(DAS_XML_NAMESPACE, "objectVersion", this.objectVersion);
        serializer.attribute(DAS_XML_NAMESPACE, "intObjectId", this.intObjectId);
        if (this.type != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "type", this.type.toString());
        }
        serializer.attribute(DAS_XML_NAMESPACE, "dbSource", this.dbSource);
        serializer.attribute(DAS_XML_NAMESPACE, "dbVersion", this.dbVersion);
        if (this.dbCoordSys != null && this.dbCoordSys.length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "dbCoordSys", this.dbCoordSys);
        }
        if (this.alignObjectDetails != null) {
            for (AlignObjectDetail alignObjectDetail : this.alignObjectDetails) {
                alignObjectDetail.serialize(DAS_XML_NAMESPACE, serializer);
            }
        }
        if (this.sequence != null && this.sequence.length() > 0) {
            serializer.startTag(DAS_XML_NAMESPACE, "sequence");
            serializer.text(this.sequence);
            serializer.endTag(DAS_XML_NAMESPACE, "sequence");
        }
        serializer.endTag(DAS_XML_NAMESPACE, "alignObject");
    }
}

