/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.mydas.exceptions.CoordinateErrorException;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.DasSegment;

public class DasSequence
extends DasSegment
implements Serializable {
    protected String sequenceString;
    protected String molType;
    public static final String TYPE_DNA = "DNA";
    public static final String TYPE_ssRNA = "ssRNA";
    public static final String TYPE_dsRNA = "dsRNA";
    public static final String TYPE_PROTEIN = "Protein";
    protected static final List<String> PERMITTED_TYPES = new ArrayList<String>(4);
    private String label;

    public DasSequence(String segmentId, String sequence, int startCoordinate, String version, String label) throws DataSourceException {
        super(startCoordinate, sequence == null ? startCoordinate : startCoordinate + sequence.length() - 1, segmentId, version);
        if (sequence == null || sequence.length() == 0) {
            throw new DataSourceException("An attempt has been made to instantiate a DasSequence object that has no sequenceString");
        }
        this.sequenceString = sequence;
        this.label = label;
    }

    public String getSequenceString() {
        return this.sequenceString;
    }

    public String getRestrictedSequenceString(int requestedStart, int requestedStop) throws CoordinateErrorException {
        return this.sequenceString.substring(requestedStart - this.startCoordinate, requestedStop - this.startCoordinate + 1);
    }

    public String getMolType() {
        return this.molType;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        PERMITTED_TYPES.add(TYPE_DNA);
        PERMITTED_TYPES.add(TYPE_ssRNA);
        PERMITTED_TYPES.add(TYPE_dsRNA);
        PERMITTED_TYPES.add(TYPE_PROTEIN);
    }
}

