/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.DasFeatureOrientation;
import uk.ac.ebi.mydas.model.DasGroup;
import uk.ac.ebi.mydas.model.DasMethod;
import uk.ac.ebi.mydas.model.DasPhase;
import uk.ac.ebi.mydas.model.DasTarget;
import uk.ac.ebi.mydas.model.DasType;

public class DasFeature
implements Serializable {
    protected final String featureId;
    protected final String featureLabel;
    protected String typeId;
    protected String typeCategory;
    protected String typeLabel;
    protected String methodId;
    protected String methodLabel;
    protected final DasType type;
    protected final DasMethod method;
    protected final int startCoordinate;
    protected final int endCoordinate;
    protected final Double score;
    protected final DasFeatureOrientation orientation;
    protected final DasPhase phase;
    protected final Collection<String> notes;
    protected final Map<URL, String> links;
    protected final Collection<DasTarget> targets;
    protected Collection<String> parents;
    protected Collection<String> parts;
    protected Collection<DasGroup> groups;

    public DasFeature(String featureId, String featureLabel, DasType type, DasMethod method, int startCoordinate, int endCoordinate, Double score, DasFeatureOrientation orientation, DasPhase phase, Collection<String> notes, Map<URL, String> links, Collection<DasTarget> targets, Collection<String> parents, Collection<String> parts) throws DataSourceException {
        if (featureId == null || type == null || method == null) {
            throw new DataSourceException("An attempt to instantiate a DasFeature object without the minimal required mandatory values.");
        }
        if (orientation == null) {
            orientation = DasFeatureOrientation.ORIENTATION_NOT_APPLICABLE;
        }
        if (phase == null) {
            phase = DasPhase.PHASE_NOT_APPLICABLE;
        }
        this.featureId = featureId;
        this.featureLabel = featureLabel;
        this.type = type;
        this.method = method;
        this.startCoordinate = startCoordinate;
        this.endCoordinate = endCoordinate;
        this.score = score;
        this.orientation = orientation;
        this.phase = phase;
        this.notes = notes;
        this.links = links;
        this.targets = targets;
        this.parents = parents;
        this.parts = parts;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getFeatureLabel() {
        return this.featureLabel;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeCategory() {
        return this.typeCategory;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public String getMethodLabel() {
        return this.methodLabel;
    }

    public int getStartCoordinate() {
        return this.startCoordinate;
    }

    public int getStopCoordinate() {
        return this.endCoordinate;
    }

    public Double getScore() {
        return this.score;
    }

    public DasFeatureOrientation getOrientation() {
        return this.orientation;
    }

    public DasPhase getPhase() {
        return this.phase;
    }

    public Collection<String> getNotes() {
        return this.notes;
    }

    public Map<URL, String> getLinks() {
        return this.links;
    }

    public Collection<DasTarget> getTargets() {
        return this.targets;
    }

    public Collection<DasGroup> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DasFeature that = (DasFeature)o;
        if (this.endCoordinate != that.endCoordinate) {
            return false;
        }
        if (this.startCoordinate != that.startCoordinate) {
            return false;
        }
        if (!this.featureId.equals(that.featureId)) {
            return false;
        }
        if (this.featureLabel != null ? !this.featureLabel.equals(that.featureLabel) : that.featureLabel != null) {
            return false;
        }
        if (this.parents != null ? !((Object)this.parents).equals(that.parents) : that.parents != null) {
            return false;
        }
        if (this.parts != null ? !((Object)this.parts).equals(that.parts) : that.parts != null) {
            return false;
        }
        if (this.links != null ? !((Object)this.links).equals(that.links) : that.links != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.notes != null ? !((Object)this.notes).equals(that.notes) : that.notes != null) {
            return false;
        }
        if (!this.orientation.equals(that.orientation)) {
            return false;
        }
        if (!this.phase.equals(that.phase)) {
            return false;
        }
        if (!this.score.equals(that.score)) {
            return false;
        }
        if (this.targets != null ? !((Object)this.targets).equals(that.targets) : that.targets != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.featureId.hashCode();
        result = 31 * result + (this.featureLabel != null ? this.featureLabel.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + this.startCoordinate;
        result = 31 * result + this.endCoordinate;
        result = 31 * result + this.score.hashCode();
        result = 31 * result + this.orientation.hashCode();
        result = 31 * result + this.phase.hashCode();
        result = 31 * result + (this.notes != null ? ((Object)this.notes).hashCode() : 0);
        result = 31 * result + (this.links != null ? ((Object)this.links).hashCode() : 0);
        result = 31 * result + (this.targets != null ? ((Object)this.targets).hashCode() : 0);
        result = 31 * result + (this.parents != null ? ((Object)this.parents).hashCode() : 0);
        result = 31 * result + (this.parts != null ? ((Object)this.parts).hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "";
        result = result + (this.featureLabel != null ? " LABEL: " + this.featureLabel : "");
        result = result + " TYPE: " + this.type.toString();
        result = result + (this.method != null ? " METHOD " + this.method.toString() : "");
        result = result + " START: " + this.startCoordinate;
        result = result + " STOP: " + this.endCoordinate;
        result = result + " SCORE: " + this.score;
        result = result + " ORIENTATION: " + this.orientation;
        result = result + " PHASE: " + this.phase.hashCode();
        result = result + (this.notes != null ? " NOTES: " + this.notes.toString() : "");
        result = result + (this.links != null ? " LINKS: " + this.links.toString() : "");
        result = result + (this.targets != null ? " TARGETS: " + this.targets.toString() : "");
        result = result + (this.parents != null ? " PARENTS: " + this.parents.toString() : "");
        result = result + (this.parts != null ? " PARTS: " + this.parts.toString() : "");
        return result;
    }

    public DasType getType() {
        return this.type;
    }

    public DasMethod getMethod() {
        return this.method;
    }

    public Collection<String> getParents() {
        return this.parents;
    }

    public Collection<String> getParts() {
        return this.parts;
    }
}

