/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model;

import java.io.Serializable;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.DasEntryPointOrientation;

public class DasEntryPoint
implements Serializable {
    private String segmentId;
    private Integer startCoordinate;
    private Integer stopCoordinate;
    private String type;
    private String version;
    private DasEntryPointOrientation orientation;
    private String description;
    private boolean subparts;

    public DasEntryPoint(String segmentId, Integer startCoordinate, Integer stopCoordinate, String type, String version, DasEntryPointOrientation orientation, String description, boolean hasSubparts) throws DataSourceException {
        if (segmentId == null || segmentId.length() == 0) {
            throw new DataSourceException("A new DasEntryPoint object must be initialised with a segmentId.");
        }
        this.segmentId = segmentId;
        this.startCoordinate = startCoordinate;
        this.stopCoordinate = stopCoordinate;
        this.type = type;
        this.version = version;
        this.orientation = orientation == null ? DasEntryPointOrientation.NO_INTRINSIC_ORIENTATION : orientation;
        this.description = description;
        this.subparts = hasSubparts;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public Integer getStartCoordinate() {
        return this.startCoordinate;
    }

    public Integer getStopCoordinate() {
        return this.stopCoordinate;
    }

    public String getType() {
        return this.type;
    }

    public DasEntryPointOrientation getOrientation() {
        return this.orientation;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasSubparts() {
        return this.subparts;
    }

    public String getVersion() {
        return this.version;
    }
}

