/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.extendedmodel.DasFeatureE;
import uk.ac.ebi.mydas.model.DasAnnotatedSegment;
import uk.ac.ebi.mydas.model.DasFeatureOrientation;
import uk.ac.ebi.mydas.model.DasMethod;
import uk.ac.ebi.mydas.model.DasPhase;
import uk.ac.ebi.mydas.model.DasTarget;
import uk.ac.ebi.mydas.model.DasType;

public class DasComponentFeature
extends DasFeatureE
implements Serializable {
    private Collection<DasComponentFeature> subComponents = null;
    private Collection<DasComponentFeature> superComponents = null;

    private DasComponentFeature(String featureId, String featureLabel, String targetSegmentId, String componentTargetLabel, int startCoordinateOnComponent, int endCoordinateOnComponent, DasType type, DasMethod method, int startCoodinateOnSegment, int endCoordinateOnSegment, Double score, DasFeatureOrientation orientation, DasPhase phase, Collection<String> notes, Map<URL, String> links) throws DataSourceException {
        super(featureId, featureLabel, type, method, startCoodinateOnSegment, endCoordinateOnSegment, score, orientation, phase, notes, links, new ArrayList<DasTarget>(1), null, null);
        DasTarget componentTarget = new DasTarget(targetSegmentId, startCoordinateOnComponent, endCoordinateOnComponent, componentTargetLabel);
        this.getTargets().add(componentTarget);
    }

    DasComponentFeature(DasAnnotatedSegment segment) throws DataSourceException {
        super(segment.getSegmentId(), null, new DasType("ThisSegment", "component", null, null), new DasMethod("assembly", null, null), segment.getStartCoordinate(), segment.getStopCoordinate(), 0.0, DasFeatureOrientation.ORIENTATION_NOT_APPLICABLE, DasPhase.PHASE_NOT_APPLICABLE, null, null, new ArrayList<DasTarget>(1), null, null);
        this.getTargets().add(new DasTarget(segment.getSegmentId(), segment.getStartCoordinate(), segment.getStopCoordinate(), segment.getSegmentLabel()));
    }

    public boolean hasSubParts() {
        return this.subComponents != null && this.subComponents.size() > 0;
    }

    public boolean hasSuperParts() {
        return this.superComponents != null && this.superComponents.size() > 0;
    }

    public DasComponentFeature addSubComponent(String componentFeatureId, int startCoordinateOnSegment, int stopCoordinateOnSegment, int startCoordinateOnComponent, int stopCoordinateOnComponent, String componentFeatureLabel, DasType componentType, String targetSegmentId, String componentTargetLabel, DasMethod componentMethod, Double componentScore, DasFeatureOrientation componentOrientation, DasPhase componentPhase, Collection<String> componentNotes, Map<URL, String> componentLinks) throws DataSourceException {
        if (this.subComponents == null) {
            this.subComponents = new ArrayList<DasComponentFeature>();
        }
        DasComponentFeature newSubComponent = new DasComponentFeature(componentFeatureId, componentFeatureLabel, targetSegmentId, componentTargetLabel, startCoordinateOnComponent, stopCoordinateOnComponent, componentType, componentMethod, startCoordinateOnSegment, stopCoordinateOnSegment, componentScore, componentOrientation, componentPhase, componentNotes, componentLinks);
        this.subComponents.add(newSubComponent);
        if (this.parts == null) {
            this.parts = new ArrayList();
        }
        this.parts.add(newSubComponent.getFeatureId());
        newSubComponent.addSuperComponent(this);
        return newSubComponent;
    }

    private void addSubComponent(DasComponentFeature subComponentFeature) {
        if (this.subComponents == null) {
            this.subComponents = new ArrayList<DasComponentFeature>();
        }
        if (this.parts == null) {
            this.parts = new ArrayList();
        }
        this.parts.add(subComponentFeature.getFeatureId());
        this.subComponents.add(subComponentFeature);
    }

    public DasComponentFeature addSuperComponent(String componentFeatureId, int startCoordinateOnSegment, int stopCoordinateOnSegment, int startCoordinateOnComponent, int stopCoordinateOnComponent, String componentFeatureLabel, DasType componentType, String targetSegmentId, String componentTargetLabel, DasMethod componentMethod, Double componentScore, DasFeatureOrientation componentOrientation, DasPhase componentPhase, Collection<String> componentNotes, Map<URL, String> componentLinks) throws DataSourceException {
        if (this.superComponents == null) {
            this.superComponents = new ArrayList<DasComponentFeature>();
        }
        DasComponentFeature newSuperComponent = new DasComponentFeature(componentFeatureId, componentFeatureLabel, targetSegmentId, componentTargetLabel, startCoordinateOnComponent, stopCoordinateOnComponent, componentType, componentMethod, startCoordinateOnSegment, stopCoordinateOnSegment, componentScore, componentOrientation, componentPhase, componentNotes, componentLinks);
        this.superComponents.add(newSuperComponent);
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        this.parents.add(newSuperComponent.getFeatureId());
        newSuperComponent.addSubComponent(this);
        return newSuperComponent;
    }

    private void addSuperComponent(DasComponentFeature superComponentFeature) {
        if (this.superComponents == null) {
            this.superComponents = new ArrayList<DasComponentFeature>();
        }
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        this.parents.add(superComponentFeature.getFeatureId());
        this.superComponents.add(superComponentFeature);
    }

    private Collection<DasComponentFeature> getSubComponents() {
        if (this.subComponents == null) {
            return Collections.emptyList();
        }
        return this.subComponents;
    }

    public Collection<DasComponentFeature> getReportableSubComponents() {
        ArrayList<DasComponentFeature> deepComponents = new ArrayList<DasComponentFeature>();
        for (DasComponentFeature component : this.getSubComponents()) {
            deepComponents.add(component);
        }
        return deepComponents;
    }

    private Collection<DasComponentFeature> getSuperComponents() {
        if (this.superComponents == null) {
            return Collections.emptyList();
        }
        return this.superComponents;
    }

    public Collection<DasComponentFeature> getReportableSuperComponents() {
        ArrayList<DasComponentFeature> deepSuperComponents = new ArrayList<DasComponentFeature>();
        for (DasComponentFeature component : this.getSuperComponents()) {
            deepSuperComponents.add(component);
        }
        return deepSuperComponents;
    }

    public boolean isTypeIsReference() {
        return true;
    }

    @Override
    public String toString() {
        String text = "Feature :" + super.toString();
        text = text + "| supercomponents : {";
        text = text + "} | subcomponents : {";
        for (DasComponentFeature component : this.getSubComponents()) {
            text = text + "-" + component.toString() + "-";
        }
        return text + "}";
    }
}

