/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.DasComponentFeature;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.DasSegment;
import uk.ac.ebi.mydas.model.DasSequence;

public class DasAnnotatedSegment
extends DasSegment
implements Serializable {
    private static final Logger logger = Logger.getLogger(DasAnnotatedSegment.class);
    Collection<DasFeature> features;
    DasComponentFeature selfComponent;
    String segmentLabel;
    String type;
    Integer totalFeatures;

    public DasAnnotatedSegment(String segmentId, Integer startCoordinate, Integer stopCoordinate, String version, String segmentLabel, Collection<DasFeature> features) throws DataSourceException {
        super(startCoordinate, stopCoordinate, segmentId, version);
        this.features = features;
        this.segmentLabel = segmentLabel;
    }

    public DasAnnotatedSegment(String segmentId, Integer startCoordinate, Integer stopCoordinate, String version, String segmentLabel, Collection<DasFeature> features, Integer total) throws DataSourceException {
        this(segmentId, startCoordinate, stopCoordinate, version, segmentLabel, features);
        this.totalFeatures = total;
    }

    public DasAnnotatedSegment(DasSequence sequence, String segmentLabel, Collection<DasFeature> features) throws DataSourceException {
        this(sequence.getSegmentId(), sequence.getStartCoordinate(), sequence.getStopCoordinate(), sequence.getVersion(), segmentLabel, features);
    }

    public Collection<DasFeature> getFeatures() {
        if (this.selfComponent == null) {
            return this.features;
        }
        ArrayList<DasFeature> allFeatures = new ArrayList<DasFeature>(this.features);
        allFeatures.add(this.selfComponent);
        allFeatures.addAll(this.selfComponent.getReportableSubComponents());
        allFeatures.addAll(this.selfComponent.getReportableSuperComponents());
        return allFeatures;
    }

    public Collection<DasFeature> getFeatures(int requestedStart, int requestedStop) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"DasAnnotatedSegment.getFeatures (start, stop) called.  StrictlyEnclosed = false");
        }
        Collection<DasFeature> allFeatures = this.getFeatures();
        ArrayList<DasFeature> restrictedFeatures = new ArrayList<DasFeature>(allFeatures.size());
        if (this.features != null) {
            for (DasFeature feature : allFeatures) {
                if (requestedStop >= feature.getStartCoordinate() && requestedStop <= feature.getStopCoordinate() || requestedStart >= feature.getStartCoordinate() && requestedStart <= feature.getStopCoordinate() || requestedStart <= feature.getStartCoordinate() && requestedStop >= feature.getStopCoordinate()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Overlap.  Feature passed: Requested start: " + requestedStart + ". Requested stop: " + requestedStop + ". Feature start: " + feature.getStartCoordinate() + ". Feature stop: " + feature.getStopCoordinate()));
                    }
                    restrictedFeatures.add(feature);
                }
                if (feature.getStartCoordinate() != 0 || feature.getStopCoordinate() != 0) continue;
                restrictedFeatures.add(feature);
            }
        }
        return restrictedFeatures;
    }

    public String getSegmentLabel() {
        return this.segmentLabel;
    }

    public String getType() {
        return this.type;
    }

    public DasComponentFeature getSelfComponentFeature() throws DataSourceException {
        if (this.selfComponent == null) {
            this.selfComponent = new DasComponentFeature(this);
        }
        return this.selfComponent;
    }

    public Integer getTotalFeatures() {
        if (this.totalFeatures == null) {
            this.totalFeatures = this.features.size();
        }
        return this.totalFeatures;
    }

    public void setTotalFeatures(Integer total) {
        this.totalFeatures = total;
    }
}

