/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.extendedmodel;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.controller.DasFeatureRequestFilter;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.extendedmodel.DasLinkE;
import uk.ac.ebi.mydas.extendedmodel.DasMethodE;
import uk.ac.ebi.mydas.extendedmodel.DasTargetE;
import uk.ac.ebi.mydas.extendedmodel.DasTypeE;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.DasFeatureOrientation;
import uk.ac.ebi.mydas.model.DasMethod;
import uk.ac.ebi.mydas.model.DasPhase;
import uk.ac.ebi.mydas.model.DasTarget;
import uk.ac.ebi.mydas.model.DasType;

public class DasFeatureE
extends DasFeature {
    public DasFeatureE(String featureId, String featureLabel, DasType type, DasMethod method, int startCoordinate, int endCoordinate, Double score, DasFeatureOrientation orientation, DasPhase phase, Collection<String> notes, Map<URL, String> links, Collection<DasTarget> targets, Collection<String> parents, Collection<String> parts) throws DataSourceException {
        super(featureId, featureLabel, type, method, startCoordinate, endCoordinate, score, orientation, phase, notes, links, targets, parents, parts);
    }

    public DasFeatureE(DasFeature feature) throws DataSourceException {
        super(feature.getFeatureId(), feature.getFeatureLabel(), feature.getType(), feature.getMethod(), feature.getStartCoordinate(), feature.getStopCoordinate(), feature.getScore(), feature.getOrientation(), feature.getPhase(), feature.getNotes(), feature.getLinks(), feature.getTargets(), feature.getParents(), feature.getParts());
    }

    public void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer, DasFeatureRequestFilter filter, boolean categorize, boolean isUseFeatureIdForFeatureLabel, boolean hasReferences, boolean hasSuperParts, boolean hasSubParts) throws IllegalArgumentException, IllegalStateException, IOException, DataSourceException {
        if (filter.featurePasses(this)) {
            serializer.startTag(DAS_XML_NAMESPACE, "FEATURE");
            serializer.attribute(DAS_XML_NAMESPACE, "id", this.getFeatureId());
            if (this.getFeatureLabel() != null && this.getFeatureLabel().length() > 0) {
                serializer.attribute(DAS_XML_NAMESPACE, "label", this.getFeatureLabel());
            } else if (isUseFeatureIdForFeatureLabel) {
                serializer.attribute(DAS_XML_NAMESPACE, "label", this.getFeatureId());
            }
            new DasTypeE(this.getType()).serialize(DAS_XML_NAMESPACE, serializer, null, hasReferences, hasSubParts, hasSuperParts, true);
            new DasMethodE(this.getMethod()).serialize(DAS_XML_NAMESPACE, serializer);
            if (this.getStartCoordinate() != 0 && this.getStopCoordinate() != 0) {
                serializer.startTag(DAS_XML_NAMESPACE, "START");
                serializer.text(Integer.toString(this.getStartCoordinate()));
                serializer.endTag(DAS_XML_NAMESPACE, "START");
                serializer.startTag(DAS_XML_NAMESPACE, "END");
                serializer.text(Integer.toString(this.getStopCoordinate()));
                serializer.endTag(DAS_XML_NAMESPACE, "END");
            }
            if (this.getScore() != null) {
                serializer.startTag(DAS_XML_NAMESPACE, "SCORE");
                serializer.text(Double.toString(this.getScore()));
                serializer.endTag(DAS_XML_NAMESPACE, "SCORE");
            }
            if (this.getOrientation() != null && this.getOrientation() != DasFeatureOrientation.ORIENTATION_NOT_APPLICABLE) {
                serializer.startTag(DAS_XML_NAMESPACE, "ORIENTATION");
                serializer.text(this.getOrientation().toString());
                serializer.endTag(DAS_XML_NAMESPACE, "ORIENTATION");
            }
            if (this.getPhase() != null && this.getPhase() != DasPhase.PHASE_NOT_APPLICABLE) {
                serializer.startTag(DAS_XML_NAMESPACE, "PHASE");
                serializer.text(this.getPhase().toString());
                serializer.endTag(DAS_XML_NAMESPACE, "PHASE");
            }
            if (this.getNotes() != null) {
                for (String note : this.getNotes()) {
                    serializer.startTag(DAS_XML_NAMESPACE, "NOTE");
                    serializer.text(note);
                    serializer.endTag(DAS_XML_NAMESPACE, "NOTE");
                }
            }
            if (this.getLinks() != null) {
                for (URL url : this.getLinks().keySet()) {
                    if (url == null) continue;
                    new DasLinkE(url, this.getLinks().get(url)).serialize(DAS_XML_NAMESPACE, serializer);
                }
            }
            if (this.targets != null) {
                for (DasTarget target : this.getTargets()) {
                    new DasTargetE(target).serialize(DAS_XML_NAMESPACE, serializer);
                }
            }
            if (this.parents != null) {
                for (String parent : this.getParents()) {
                    serializer.startTag(DAS_XML_NAMESPACE, "PARENT");
                    serializer.attribute(DAS_XML_NAMESPACE, "id", parent);
                    serializer.endTag(DAS_XML_NAMESPACE, "PARENT");
                }
            }
            if (this.parts != null) {
                for (String part : this.getParts()) {
                    serializer.startTag(DAS_XML_NAMESPACE, "PART");
                    serializer.attribute(DAS_XML_NAMESPACE, "id", part);
                    serializer.endTag(DAS_XML_NAMESPACE, "PART");
                }
            }
            serializer.endTag(DAS_XML_NAMESPACE, "FEATURE");
        }
    }
}

