/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.controller;

import java.util.regex.Matcher;

public class SegmentQuery {
    private final String segmentId;
    private final Integer startCoordinate;
    private final Integer stopCoordinate;
    private boolean empty = false;

    public SegmentQuery(Matcher segmentRangePatternMatcher) {
        this.segmentId = segmentRangePatternMatcher.group(1);
        if (this.segmentId.trim().equals("")) {
            this.empty = true;
        }
        String startString = segmentRangePatternMatcher.group(3);
        String stopString = segmentRangePatternMatcher.group(5);
        this.startCoordinate = startString == null || startString.length() == 0 ? null : new Integer(startString);
        this.stopCoordinate = stopString == null || stopString.length() == 0 ? null : new Integer(stopString);
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public Integer getStartCoordinate() {
        return this.startCoordinate;
    }

    public Integer getStopCoordinate() {
        return this.stopCoordinate;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.segmentId);
        if (this.startCoordinate != null) {
            buf.append('_').append(this.startCoordinate);
            buf.append('_').append(this.stopCoordinate);
        }
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

