/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import uk.ac.ebi.mydas.configuration.DataSourceConfiguration;
import uk.ac.ebi.mydas.controller.DasCommandManager;
import uk.ac.ebi.mydas.controller.DataSourceManager;
import uk.ac.ebi.mydas.controller.XDasStatus;
import uk.ac.ebi.mydas.exceptions.BadCommandArgumentsException;
import uk.ac.ebi.mydas.exceptions.BadCommandException;
import uk.ac.ebi.mydas.exceptions.BadDataSourceException;
import uk.ac.ebi.mydas.exceptions.BadReferenceObjectException;
import uk.ac.ebi.mydas.exceptions.BadStylesheetException;
import uk.ac.ebi.mydas.exceptions.ConfigurationException;
import uk.ac.ebi.mydas.exceptions.CoordinateErrorException;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.exceptions.SearcherException;
import uk.ac.ebi.mydas.exceptions.UnimplementedFeatureException;
import uk.ac.ebi.mydas.exceptions.WritebackException;

public class MydasServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(MydasServlet.class);
    private DasCommandManager dasCommands = null;
    private static final Pattern REQUEST_URI_PATTERN = Pattern.compile("/das/([^\\s/?]+)/?([^\\s/?]*)$");
    private static final Pattern DAS_ONLY_URI_PATTERN = Pattern.compile("/das[/]?$");
    private static DataSourceManager DATA_SOURCE_MANAGER = null;
    static final String RESOURCE_FOLDER = "/";
    private static final String CONFIGURATION_FILE_NAME = "/MydasServerConfig.xml";
    private static final String HEADER_KEY_X_DAS_VERSION = "X-DAS-Version";
    private static final String HEADER_KEY_X_DAS_STATUS = "X-DAS-Status";
    private static final String HEADER_KEY_X_DAS_SERVER = "X-DAS-Server";
    private static final String HEADER_KEY_X_DAS_CAPABILITIES = "X-DAS-Capabilities";
    private static final String HEADER_KEY_CORS = "Access-Control-Allow-Origin";
    private static final String HEADER_KEY_CORS_EXPOSE = "Access-Control-Expose-Headers";
    private static final String HEADER_KEY_CORS_METHODS = "Access-Control-Allow-Methods";
    private static final String HEADER_KEY_CORS_HEADERS = "Access-Control-Allow-Headers";
    private static final String HEADER_KEY_CORS_AGE = "Access-Control-Max-Age";
    private static final String HEADER_VALUE_DAS_VERSION = "DAS/1.6";
    private static final String HEADER_VALUE_DAS_SERVER = "MyDAS1.6.7";
    private static final String HEADER_VALUE_X_DAS_DEFAULT_CAPABILITIES = "sources/1.0";
    private static final String HEADER_VALUE_CORS = "*";
    private static final String HEADER_VALUE_CORS_EXPOSE = "X-DAS-Version, X-DAS-Status, X-DAS-Server, X-DAS-Capabilities";
    private static final String HEADER_VALUE_CORS_METHODS = "GET, POST, OPTIONS";
    private static final String HEADER_VALUE_CORS_HEADERS = "X-DAS-Version, X-DAS-Client";
    private static final String HEADER_VALUE_CORS_AGE = "2592000";
    private static final String ENCODING_REQUEST_HEADER_KEY = "Accept-Encoding";
    private static final String ENCODING_RESPONSE_HEADER_KEY = "Content-Encoding";
    private static final String ENCODING_GZIPPED = "gzip";
    private static XmlPullParserFactory PULL_PARSER_FACTORY = null;

    public void init() throws ServletException {
        super.init();
        if (DATA_SOURCE_MANAGER == null) {
            DATA_SOURCE_MANAGER = new DataSourceManager(this.getServletContext());
            try {
                DATA_SOURCE_MANAGER.init(CONFIGURATION_FILE_NAME);
            }
            catch (Exception e) {
                logger.error((Object)"Fatal Exception thrown at initialisation.  None of the datasources will be usable.", (Throwable)e);
                throw new IllegalStateException("Fatal Exception thrown at initialisation.  None of the datasources will be usable.", e);
            }
        }
        this.dasCommands = new DasCommandManager(DATA_SOURCE_MANAGER, this);
        if (PULL_PARSER_FACTORY == null) {
            try {
                PULL_PARSER_FACTORY = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
                PULL_PARSER_FACTORY.setNamespaceAware(true);
            }
            catch (XmlPullParserException xppe) {
                logger.error((Object)"Fatal Exception thrown at initialisation.  Cannot initialise the PullParserFactory required to allow generation of the DAS XML.", (Throwable)xppe);
                throw new IllegalStateException("Fatal Exception thrown at initialisation.  Cannot initialise the PullParserFactory required to allow generation of the DAS XML.", xppe);
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (DATA_SOURCE_MANAGER != null) {
            DATA_SOURCE_MANAGER.destroy();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.parseAndHandleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DataSourceConfiguration dataSourceConfig = DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfigMap().get("writeback");
        try {
            this.dasCommands.writebackCreate(request, response, dataSourceConfig);
        }
        catch (WritebackException e) {
            logger.error((Object)"Writebackexception thrown", (Throwable)e);
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "Writeback error creating a feature.", request, response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DataSourceConfiguration dataSourceConfig = DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfigMap().get("writeback");
        try {
            this.dasCommands.writebackDelete(request, response, dataSourceConfig);
        }
        catch (WritebackException e) {
            logger.error((Object)"WritebackException thrown", (Throwable)e);
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "Writeback error deleting a feature.", request, response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DataSourceConfiguration dataSourceConfig = DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfigMap().get("writeback");
        try {
            this.dasCommands.writebackUpdate(request, response, dataSourceConfig);
        }
        catch (WritebackException e) {
            logger.error((Object)"WritebackException thrown", (Throwable)e);
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "Writeback error creating a feature.", request, response);
        }
    }

    private void parseAndHandleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block46: {
            String queryString = request.getQueryString();
            if (queryString != null && !queryString.contains("feature_id")) {
                queryString = queryString.replaceAll("/{2,}", RESOURCE_FOLDER);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RequestURI: '" + request.getRequestURI() + "'"));
                logger.debug((Object)("Query String2: '" + queryString + "'"));
            }
            Matcher match = REQUEST_URI_PATTERN.matcher(request.getRequestURI().replaceAll("/{2,}", RESOURCE_FOLDER));
            String capabilities = null;
            try {
                if (DATA_SOURCE_MANAGER == null || DATA_SOURCE_MANAGER.getServerConfiguration() == null || DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration() == null || DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfigMap() == null) {
                    throw new ConfigurationException("The datasources were not initialized successfully.");
                }
                if (match.find()) {
                    DataSourceConfiguration dataSourceConfig;
                    if (Commands.COMMAND_DSN.matches(match.group(1))) {
                        if (match.group(2) == null || match.group(2).length() == 0) {
                            this.dasCommands.dsnCommand(request, response, queryString);
                            break block46;
                        }
                        throw new BadCommandException("A bad dsn command has been sent to the server, including unrecognised additional query parameters.");
                    }
                    if (Commands.COMMAND_SOURCES.matches(match.group(1))) {
                        this.dasCommands.sourceCommand(request, response, queryString, null);
                        break block46;
                    }
                    if (Commands.COMMAND_INDEXER.matches(match.group(1))) {
                        this.dasCommands.indexerCommand(request, response);
                        break block46;
                    }
                    String dsnName = match.group(1);
                    if ((match.group(2) == null || match.group(2).length() == 0) && null != DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfigMap().get(dsnName)) {
                        this.dasCommands.sourceCommand(request, response, queryString, dsnName);
                        return;
                    }
                    String command = match.group(2);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("dsnName: '" + dsnName + "'"));
                        logger.debug((Object)("command: '" + command + "'"));
                    }
                    if ((dataSourceConfig = DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfigMap().get(dsnName)) != null) {
                        capabilities = dataSourceConfig.getCapabilities();
                        if (dataSourceConfig.isOK()) {
                            if (Commands.COMMAND_DNA.matches(command)) {
                                this.dasCommands.dnaCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_TYPES.matches(command)) {
                                this.dasCommands.typesCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_STYLESHEET.matches(command)) {
                                this.dasCommands.stylesheetCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_FEATURES.matches(command)) {
                                this.dasCommands.featuresCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_ENTRY_POINTS.matches(command)) {
                                this.dasCommands.entryPointsCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_SEQUENCE.matches(command)) {
                                this.dasCommands.sequenceCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_STRUCTURE.matches(command)) {
                                this.dasCommands.structureCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_ALIGNMENT.matches(command)) {
                                this.dasCommands.alignmentCommand(request, response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_LINK.matches(command)) {
                                this.dasCommands.linkCommand(response, dataSourceConfig, queryString);
                            } else if (Commands.COMMAND_HISTORICAL.matches(command)) {
                                this.dasCommands.writebackHistorical(request, response, dataSourceConfig);
                            } else {
                                this.dasCommands.otherCommand(request, response, dataSourceConfig, command, queryString);
                            }
                            break block46;
                        }
                        throw new BadDataSourceException("The datasource was not correctly initialised.");
                    }
                    capabilities = null;
                    throw new BadDataSourceException("The requested datasource does not exist.");
                }
                if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().isSlashDasPointsToDsn() && DAS_ONLY_URI_PATTERN.matcher(request.getRequestURI()).find()) {
                    this.dasCommands.sourceCommand(request, response, queryString, null);
                    break block46;
                }
                throw new BadCommandException("The command is not recognised.");
            }
            catch (BadCommandException bce) {
                logger.error((Object)"BadCommandException thrown", (Throwable)bce);
                this.writeHeader(request, response, XDasStatus.STATUS_400_BAD_COMMAND, false, capabilities);
                this.reportError(XDasStatus.STATUS_400_BAD_COMMAND, "Bad Command - Command not recognised as a valid DAS command.", request, response);
            }
            catch (BadDataSourceException bdse) {
                logger.error((Object)"BadDataSourceException thrown", (Throwable)bdse);
                this.writeHeader(request, response, XDasStatus.STATUS_401_BAD_DATA_SOURCE, false, capabilities);
                this.reportError(XDasStatus.STATUS_401_BAD_DATA_SOURCE, "Bad Data Source", request, response);
            }
            catch (BadCommandArgumentsException bcae) {
                logger.error((Object)"BadCommandArgumentsException thrown", (Throwable)bcae);
                this.writeHeader(request, response, XDasStatus.STATUS_402_BAD_COMMAND_ARGUMENTS, false, capabilities);
                this.reportError(XDasStatus.STATUS_402_BAD_COMMAND_ARGUMENTS, "Bad Command Arguments - Command not recognised as a valid DAS command.", request, response);
            }
            catch (BadReferenceObjectException broe) {
                logger.error((Object)"BadReferenceObjectException thrown", (Throwable)broe);
                this.writeHeader(request, response, XDasStatus.STATUS_403_BAD_REFERENCE_OBJECT, false, capabilities);
                this.reportError(XDasStatus.STATUS_403_BAD_REFERENCE_OBJECT, "Unrecognised reference object: the requested segment is not available from this server.", request, response);
            }
            catch (BadStylesheetException bse) {
                logger.error((Object)"BadStylesheetException thrown:", (Throwable)bse);
                this.writeHeader(request, response, XDasStatus.STATUS_404_BAD_STYLESHEET, false, capabilities);
                this.reportError(XDasStatus.STATUS_404_BAD_STYLESHEET, "Bad Stylesheet.", request, response);
            }
            catch (CoordinateErrorException cee) {
                logger.error((Object)"CoordinateErrorException thrown", (Throwable)cee);
                this.writeHeader(request, response, XDasStatus.STATUS_405_COORDINATE_ERROR, false, capabilities);
                this.reportError(XDasStatus.STATUS_405_COORDINATE_ERROR, "Coordinate error - the requested coordinates are outside the scope of the requested segment.", request, response);
            }
            catch (XmlPullParserException xppe) {
                logger.error((Object)"XmlPullParserException thrown when attempting to ouput XML.", (Throwable)xppe);
                this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, capabilities);
                this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "An error has occurred when attempting to output the DAS XML.", request, response);
            }
            catch (DataSourceException dse) {
                logger.error((Object)"DataSourceException thrown by a data source.", (Throwable)dse);
                this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, capabilities);
                this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "The data source has thrown a 'DataSourceException' indicating a software error has occurred: " + dse.getMessage(), request, response);
            }
            catch (ConfigurationException ce) {
                logger.error((Object)"ConfigurationException thrown: This mydas installation was not correctly initialised.", (Throwable)ce);
                this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, capabilities);
                this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "This installation of MyDas is not correctly configured.", request, response);
            }
            catch (UnimplementedFeatureException efe) {
                logger.error((Object)"UnimplementedFeatureException thrown", (Throwable)efe);
                this.writeHeader(request, response, XDasStatus.STATUS_501_UNIMPLEMENTED_FEATURE, false, capabilities);
                this.reportError(XDasStatus.STATUS_501_UNIMPLEMENTED_FEATURE, "Unimplemented feature: this DAS server cannot serve the request you have made.", request, response);
            }
            catch (WritebackException e) {
                logger.error((Object)"WritebackException thrown", (Throwable)e);
                this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
                this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "Writeback error creating a feature.", request, response);
            }
            catch (SearcherException e) {
                logger.error((Object)"Searching/indexing thrown", (Throwable)e);
                this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
                this.reportError(XDasStatus.STATUS_500_SERVER_ERROR, "Problem executing one of the Searching functions.", request, response);
            }
        }
    }

    void reportError(XDasStatus dasStatus, String errorMessage, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        ((Writer)out).write("<html><head><title>DAS Error</title></head><body><h2>MyDas Error Message</h2><h4>Request: <code>");
        ((Writer)out).write(request.getRequestURI());
        if (request.getQueryString() != null) {
            ((Writer)out).write(63);
            ((Writer)out).write(request.getQueryString());
        }
        ((Writer)out).write("</code></h4>");
        if (dasStatus != null) {
            ((Writer)out).write("<h4>");
            ((Writer)out).write(HEADER_KEY_X_DAS_STATUS);
            ((Writer)out).write(": ");
            ((Writer)out).write(dasStatus.toString());
            ((Writer)out).write("</h4>");
        }
        ((Writer)out).write("<h4>Error: <span style='color:red'>");
        ((Writer)out).write(errorMessage);
        ((Writer)out).write("</span></h4></body></html>");
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    void writeHeader(HttpServletRequest request, HttpServletResponse response, XDasStatus status, boolean compressionAllowed, String capabilities) throws IOException {
        response.setHeader(HEADER_KEY_X_DAS_VERSION, HEADER_VALUE_DAS_VERSION);
        if (capabilities != null) {
            response.setHeader(HEADER_KEY_X_DAS_CAPABILITIES, capabilities);
        } else {
            response.setHeader(HEADER_KEY_X_DAS_CAPABILITIES, HEADER_VALUE_X_DAS_DEFAULT_CAPABILITIES);
        }
        response.setHeader(HEADER_KEY_X_DAS_STATUS, status.toString());
        response.setHeader(HEADER_KEY_X_DAS_SERVER, HEADER_VALUE_DAS_SERVER);
        if (compressionAllowed && this.compressResponse(request)) {
            response.setHeader(ENCODING_RESPONSE_HEADER_KEY, ENCODING_GZIPPED);
        }
        response.setHeader(HEADER_KEY_CORS, HEADER_VALUE_CORS);
        response.setHeader(HEADER_KEY_CORS_EXPOSE, HEADER_VALUE_CORS_EXPOSE);
        response.setHeader(HEADER_KEY_CORS_METHODS, HEADER_VALUE_CORS_METHODS);
        response.setHeader(HEADER_KEY_CORS_HEADERS, HEADER_VALUE_CORS_HEADERS);
        response.setHeader(HEADER_KEY_CORS_AGE, HEADER_VALUE_CORS_AGE);
        if (status == XDasStatus.STATUS_400_BAD_COMMAND || status == XDasStatus.STATUS_401_BAD_DATA_SOURCE || status == XDasStatus.STATUS_402_BAD_COMMAND_ARGUMENTS) {
            response.setStatus(400);
        } else if (status == XDasStatus.STATUS_404_BAD_STYLESHEET) {
            response.setStatus(404);
        } else if (status == XDasStatus.STATUS_500_SERVER_ERROR || status == XDasStatus.STATUS_501_UNIMPLEMENTED_FEATURE) {
            response.setStatus(500);
        }
        response.setContentType("application/xml;charset=UTF-8");
    }

    boolean compressResponse(HttpServletRequest request) {
        String clientEncodingAbility = request.getHeader(ENCODING_REQUEST_HEADER_KEY);
        return DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().isGzipped() && clientEncodingAbility != null && clientEncodingAbility.contains(ENCODING_GZIPPED);
    }

    static enum Commands {
        COMMAND_DSN("dsn"),
        COMMAND_DNA("dna"),
        COMMAND_TYPES("types"),
        COMMAND_LINK("link"),
        COMMAND_STYLESHEET("stylesheet"),
        COMMAND_FEATURES("features"),
        COMMAND_ENTRY_POINTS("entry_points"),
        COMMAND_SEQUENCE("sequence"),
        COMMAND_ALIGNMENT("alignment"),
        COMMAND_STRUCTURE("structure"),
        COMMAND_SOURCES("sources"),
        COMMAND_HISTORICAL("historical"),
        COMMAND_INDEXER("indexer");

        private String commandString;

        private Commands(String commandString) {
            this.commandString = commandString;
        }

        boolean matches(String command) {
            return this.commandString.equals(command);
        }
    }
}

