/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.controller;

import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.controller.SegmentQuery;
import uk.ac.ebi.mydas.controller.SequenceReporter;
import uk.ac.ebi.mydas.exceptions.CoordinateErrorException;
import uk.ac.ebi.mydas.model.DasSequence;

class FoundSequenceReporter
implements SequenceReporter {
    private final boolean restricted;
    private int requestedStart;
    private int requestedStop;
    private final DasSequence sequence;

    FoundSequenceReporter(DasSequence sequence, SegmentQuery segmentQuery) throws CoordinateErrorException {
        boolean bl = this.restricted = segmentQuery.getStartCoordinate() != null;
        if (this.restricted) {
            this.requestedStart = segmentQuery.getStartCoordinate();
            this.requestedStop = segmentQuery.getStopCoordinate();
        }
        this.sequence = sequence;
        if (this.restricted && (this.requestedStart <= 0 || this.requestedStop <= 0 || this.requestedStart > this.requestedStop || this.requestedStart < sequence.getStartCoordinate())) {
            throw new CoordinateErrorException(sequence.getSegmentId(), this.requestedStart, this.requestedStop);
        }
    }

    String getSequenceString() throws CoordinateErrorException {
        if (this.restricted) {
            if (this.requestedStop > this.sequence.getStopCoordinate()) {
                return this.sequence.getRestrictedSequenceString(this.requestedStart, this.sequence.getStopCoordinate());
            }
            return this.sequence.getRestrictedSequenceString(this.requestedStart, this.requestedStop);
        }
        return this.sequence.getSequenceString();
    }

    String getSegmentName() {
        return this.sequence.getSegmentId();
    }

    String getSequenceVersion() {
        return this.sequence.getVersion();
    }

    String getSequenceLabel() {
        return this.sequence.getLabel();
    }

    String getSequenceMoleculeType() {
        return this.sequence.getMolType();
    }

    @Override
    public Integer getStart() {
        return this.restricted ? this.requestedStart : this.sequence.getStartCoordinate();
    }

    @Override
    public Integer getStop() {
        return this.restricted ? (this.requestedStop > this.sequence.getStopCoordinate() ? this.sequence.getStopCoordinate() : this.requestedStop) : this.sequence.getStopCoordinate();
    }

    @Override
    public String getSegmentId() {
        return this.sequence.getSegmentId();
    }

    void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer) throws IOException, IllegalArgumentException, IllegalStateException, CoordinateErrorException {
        this.serialize(DAS_XML_NAMESPACE, serializer, false);
    }

    void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer, boolean dna) throws IOException, IllegalArgumentException, IllegalStateException, CoordinateErrorException {
        serializer.startTag(DAS_XML_NAMESPACE, "SEQUENCE");
        serializer.attribute(DAS_XML_NAMESPACE, "id", this.getSegmentName());
        serializer.attribute(DAS_XML_NAMESPACE, "start", Integer.toString(this.getStart()));
        serializer.attribute(DAS_XML_NAMESPACE, "stop", Integer.toString(this.getStop()));
        serializer.attribute(DAS_XML_NAMESPACE, "version", this.getSequenceVersion());
        if (!dna && this.getSequenceLabel() != null && this.getSequenceLabel().length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "label", this.getSequenceLabel());
        }
        if (dna) {
            serializer.startTag(DAS_XML_NAMESPACE, "DNA");
            serializer.attribute(DAS_XML_NAMESPACE, "length", Integer.toString(this.getSequenceString().length()));
        }
        serializer.text(this.getSequenceString());
        if (dna) {
            serializer.endTag(DAS_XML_NAMESPACE, "DNA");
        }
        serializer.endTag(DAS_XML_NAMESPACE, "SEQUENCE");
    }
}

