/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.controller;

import java.io.IOException;
import java.util.Collection;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.controller.DasFeatureRequestFilter;
import uk.ac.ebi.mydas.controller.SegmentQuery;
import uk.ac.ebi.mydas.controller.SegmentReporter;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.extendedmodel.DasFeatureE;
import uk.ac.ebi.mydas.model.DasAnnotatedSegment;
import uk.ac.ebi.mydas.model.DasComponentFeature;
import uk.ac.ebi.mydas.model.DasFeature;

public class FoundFeaturesReporter
implements SegmentReporter {
    private final boolean restricted;
    private Integer requestedStart;
    private Integer requestedStop;
    private final DasAnnotatedSegment annotatedSegment;

    FoundFeaturesReporter(DasAnnotatedSegment annotatedSegment, SegmentQuery segmentQuery) {
        boolean bl = this.restricted = segmentQuery.getStartCoordinate() != null;
        if (this.restricted) {
            this.requestedStart = segmentQuery.getStartCoordinate();
            this.requestedStop = segmentQuery.getStopCoordinate();
        }
        this.annotatedSegment = annotatedSegment;
    }

    FoundFeaturesReporter(DasAnnotatedSegment annotatedSegment) {
        this.restricted = false;
        this.annotatedSegment = annotatedSegment;
    }

    Collection<DasFeature> getFeatures() {
        return this.restricted ? this.annotatedSegment.getFeatures(this.requestedStart, this.requestedStop) : this.annotatedSegment.getFeatures();
    }

    @Override
    public Integer getStart() {
        return this.restricted ? this.requestedStart : this.annotatedSegment.getStartCoordinate();
    }

    @Override
    public Integer getStop() {
        return this.restricted ? (this.requestedStop > this.annotatedSegment.getStopCoordinate() ? this.annotatedSegment.getStopCoordinate() : this.requestedStop) : this.annotatedSegment.getStopCoordinate();
    }

    @Override
    public String getSegmentId() {
        return this.annotatedSegment.getSegmentId();
    }

    String getSegmentLabel() {
        return this.annotatedSegment.getSegmentLabel();
    }

    String getType() {
        return this.annotatedSegment.getType();
    }

    String getVersion() {
        return this.annotatedSegment.getVersion();
    }

    public Integer getTotalFeatures() {
        return this.annotatedSegment.getTotalFeatures();
    }

    void serialize(String DAS_XML_NAMESPACE, XmlSerializer serializer, DasFeatureRequestFilter filter, boolean categorize, boolean isFeaturesStrictlyEnclosed, boolean isUseFeatureIdForFeatureLabel) throws IllegalArgumentException, IllegalStateException, IOException, DataSourceException {
        serializer.startTag(DAS_XML_NAMESPACE, "SEGMENT");
        serializer.attribute(DAS_XML_NAMESPACE, "id", this.getSegmentId());
        if (this.getStart() != null && this.getStop() != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "start", Integer.toString(this.getStart()));
            serializer.attribute(DAS_XML_NAMESPACE, "stop", Integer.toString(this.getStop()));
        }
        if (this.getTotalFeatures() != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "total", Integer.toString(this.getTotalFeatures()));
        }
        if (this.getType() != null && this.getType().length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "type", this.getType());
        }
        if (this.getVersion() != null) {
            serializer.attribute(DAS_XML_NAMESPACE, "version", this.getVersion());
        }
        if (this.getSegmentLabel() != null && this.getSegmentLabel().length() > 0) {
            serializer.attribute(DAS_XML_NAMESPACE, "label", this.getSegmentLabel());
        }
        for (DasFeature feature : this.getFeatures()) {
            boolean hasSuperParts = false;
            boolean hasSubParts = false;
            if (feature instanceof DasComponentFeature) {
                DasComponentFeature refFeature = (DasComponentFeature)feature;
                hasSuperParts = refFeature.hasSuperParts();
                hasSubParts = refFeature.hasSubParts();
            }
            new DasFeatureE(feature).serialize(DAS_XML_NAMESPACE, serializer, filter, categorize, isUseFeatureIdForFeatureLabel, feature instanceof DasComponentFeature, hasSuperParts, hasSubParts);
        }
        serializer.endTag(DAS_XML_NAMESPACE, "SEGMENT");
    }
}

