/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.controller;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import uk.ac.ebi.mydas.configuration.ConfigurationManager;
import uk.ac.ebi.mydas.configuration.DataSourceConfiguration;
import uk.ac.ebi.mydas.configuration.ServerConfiguration;
import uk.ac.ebi.mydas.exceptions.ConfigurationException;
import uk.ac.ebi.mydas.exceptions.DataSourceException;

public class DataSourceManager {
    private static final Logger LOGGER = Logger.getLogger(DataSourceManager.class);
    private final ServletContext svCon;
    private ServerConfiguration serverConfiguration;
    private ConfigurationManager configManager;

    protected DataSourceManager(ServletContext servletContext) {
        this.svCon = servletContext;
    }

    public void init(String configurationFileName) throws IOException, ConfigurationException {
        this.loadConfiguration(configurationFileName);
        this.initialiseDataSources();
    }

    private void loadConfiguration(String fileName) throws IOException, ConfigurationException {
        this.configManager = new ConfigurationManager();
        try {
            this.configManager.unmarshal(this.svCon.getResourceAsStream(fileName));
            this.serverConfiguration = this.configManager.getServerConfiguration();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("JAXBException thrown when attempting to unmarshall the DAS source configuration.", e);
        }
    }

    private void initialiseDataSources() throws ConfigurationException {
        if (this.serverConfiguration == null) {
            throw new ConfigurationException("An attempt to initialise the data sources has been made, but there is no valid ServerConfiguration object.");
        }
        if (this.serverConfiguration.getGlobalConfiguration() == null) {
            throw new ConfigurationException("An attempt to initialise the data sources has been made, but the Global Configuration has not been loaded.");
        }
        for (DataSourceConfiguration dsnConfig : this.serverConfiguration.getDataSourceConfigMap().values()) {
            try {
                if (dsnConfig.loadDataSource()) {
                    dsnConfig.getDataSource().init(this.svCon, this.serverConfiguration.getGlobalConfiguration().getGlobalParameters(), dsnConfig);
                }
                if (dsnConfig.isOK()) continue;
                LOGGER.error((Object)("Data Source Failed to Load and Initialise: " + dsnConfig.toString()));
            }
            catch (DataSourceException e) {
                LOGGER.error((Object)("Data Source Failed to Load and Initialise: " + dsnConfig.toString()));
            }
        }
    }

    public void destroy() {
        for (DataSourceConfiguration dataSourceConfiguration : this.serverConfiguration.getDataSourceConfigMap().values()) {
            try {
                if (!dataSourceConfiguration.isOK()) continue;
                dataSourceConfiguration.getDataSource().destroy();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception thrown by dataSourceConfiguration " + dataSourceConfiguration.getName()), (Throwable)e);
            }
        }
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public ConfigurationManager getConfigManager() {
        return this.configManager;
    }
}

