/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.mydas.controller.SegmentQuery;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.Range;

public class DasFeatureRequestFilter {
    private Collection<String> typeIds = null;
    private Collection<String> categoryIds = null;
    private Collection<String> featureIds = null;
    private Collection<String> groupIds = null;
    private Integer maxbins = null;
    private Range rows = null;
    private String advanceQuery = null;
    private List<SegmentQuery> requestedSegments;
    private boolean paginated = false;
    private Integer totalFeatures;

    public Integer getTotalFeatures() {
        return this.totalFeatures;
    }

    public void setTotalFeatures(Integer totalFeatures) {
        this.totalFeatures = totalFeatures;
    }

    public boolean isPaginated() {
        return this.paginated;
    }

    public void setPaginated(boolean paginated) {
        this.paginated = paginated;
    }

    public Range getRows() {
        return this.rows;
    }

    public void setRows(Range rows) {
        this.rows = rows;
    }

    public Collection<String> getTypeIds() {
        return this.typeIds;
    }

    public Collection<String> getCategoryIds() {
        return this.categoryIds;
    }

    public List<SegmentQuery> getRequestedSegments() {
        return this.requestedSegments;
    }

    public void setRequestedSegments(List<SegmentQuery> requestedSegments) {
        this.requestedSegments = requestedSegments;
    }

    public String getAdvanceQuery() {
        return this.advanceQuery;
    }

    public void setAdvanceQuery(String advanceQuery) {
        this.advanceQuery = advanceQuery;
    }

    public Integer getMaxbins() {
        return this.maxbins;
    }

    public void setMaxbins(Integer maxbins) {
        this.maxbins = maxbins;
    }

    DasFeatureRequestFilter() {
    }

    void addTypeId(String typeId) {
        if (typeId != null) {
            if (this.typeIds == null) {
                this.typeIds = new ArrayList<String>();
            }
            this.typeIds.add(typeId);
        }
    }

    void addCategoryId(String categoryId) {
        if (categoryId != null) {
            if (this.categoryIds == null) {
                this.categoryIds = new ArrayList<String>();
            }
            this.categoryIds.add(categoryId);
        }
    }

    void addFeatureId(String featureId) {
        if (featureId != null) {
            if (this.featureIds == null) {
                this.featureIds = new ArrayList<String>();
            }
            this.featureIds.add(featureId);
        }
    }

    void addGroupId(String groupId) {
        if (groupId != null) {
            if (this.groupIds == null) {
                this.groupIds = new ArrayList<String>();
            }
            this.groupIds.add(groupId);
        }
    }

    boolean containsFeatureIds() {
        return this.featureIds != null && this.featureIds.size() > 0;
    }

    boolean containsGroupIds() {
        return this.groupIds != null && this.groupIds.size() > 0;
    }

    public Collection<String> getFeatureIds() {
        if (this.featureIds == null) {
            return Collections.emptyList();
        }
        return this.featureIds;
    }

    Collection<String> getGroupIds() {
        if (this.groupIds == null) {
            return Collections.emptyList();
        }
        return this.groupIds;
    }

    public boolean featurePasses(DasFeature feature) {
        if (!(this.featureIds == null || feature.getFeatureId() != null && this.featureIds.contains(feature.getFeatureId()))) {
            return false;
        }
        if (!(this.typeIds == null || feature.getType().getId() != null && this.typeIds.contains(feature.getType().getId()))) {
            return false;
        }
        return this.categoryIds == null || feature.getType().getCategory() != null && this.categoryIds.contains(feature.getType().getCategory());
    }
}

