/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.controller;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.mydas.configuration.DataSourceConfiguration;
import uk.ac.ebi.mydas.configuration.Mydasserver;
import uk.ac.ebi.mydas.configuration.PropertyType;
import uk.ac.ebi.mydas.controller.DasFeatureRequestFilter;
import uk.ac.ebi.mydas.controller.DataSourceManager;
import uk.ac.ebi.mydas.controller.ErrorSegmentReporter;
import uk.ac.ebi.mydas.controller.ErrorSequenceReporter;
import uk.ac.ebi.mydas.controller.FoundFeaturesReporter;
import uk.ac.ebi.mydas.controller.FoundSequenceReporter;
import uk.ac.ebi.mydas.controller.MydasServlet;
import uk.ac.ebi.mydas.controller.SegmentQuery;
import uk.ac.ebi.mydas.controller.SegmentReporter;
import uk.ac.ebi.mydas.controller.SequenceReporter;
import uk.ac.ebi.mydas.controller.UnknownFeatureSegmentReporter;
import uk.ac.ebi.mydas.controller.UnknownSegmentReporter;
import uk.ac.ebi.mydas.controller.XDasStatus;
import uk.ac.ebi.mydas.datasource.AlignmentDataSource;
import uk.ac.ebi.mydas.datasource.AnnotationDataSource;
import uk.ac.ebi.mydas.datasource.CommandExtender;
import uk.ac.ebi.mydas.datasource.RangeHandlingAnnotationDataSource;
import uk.ac.ebi.mydas.datasource.RangeHandlingReferenceDataSource;
import uk.ac.ebi.mydas.datasource.ReferenceDataSource;
import uk.ac.ebi.mydas.datasource.StructureDataSource;
import uk.ac.ebi.mydas.datasource.WritebackDataSource;
import uk.ac.ebi.mydas.exceptions.BadCommandArgumentsException;
import uk.ac.ebi.mydas.exceptions.BadCommandException;
import uk.ac.ebi.mydas.exceptions.BadReferenceObjectException;
import uk.ac.ebi.mydas.exceptions.BadStylesheetException;
import uk.ac.ebi.mydas.exceptions.CoordinateErrorException;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.exceptions.SearcherException;
import uk.ac.ebi.mydas.exceptions.UnimplementedFeatureException;
import uk.ac.ebi.mydas.exceptions.WritebackException;
import uk.ac.ebi.mydas.extendedmodel.DasEntryPointE;
import uk.ac.ebi.mydas.extendedmodel.DasTypeE;
import uk.ac.ebi.mydas.extendedmodel.DasUnknownFeatureSegment;
import uk.ac.ebi.mydas.model.DasAnnotatedSegment;
import uk.ac.ebi.mydas.model.DasEntryPoint;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.DasSegment;
import uk.ac.ebi.mydas.model.DasSequence;
import uk.ac.ebi.mydas.model.DasType;
import uk.ac.ebi.mydas.model.ErrorSegment;
import uk.ac.ebi.mydas.model.Range;
import uk.ac.ebi.mydas.model.alignment.DasAlignment;
import uk.ac.ebi.mydas.model.structure.DasStructure;
import uk.ac.ebi.mydas.search.Indexer;
import uk.ac.ebi.mydas.search.Searcher;
import uk.ac.ebi.mydas.writeback.MyDasParser;

public class DasCommandManager {
    private static final Logger logger = Logger.getLogger(DasCommandManager.class);
    public static final String ENCODE = "UTF-8";
    private MydasServlet mydasServlet = null;
    private static DataSourceManager DATA_SOURCE_MANAGER = null;
    private static XmlPullParserFactory PULL_PARSER_FACTORY = null;
    private static final String DAS_XML_NAMESPACE = null;
    private static final String INDENTATION_PROPERTY = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    private static final String INDENTATION_PROPERTY_VALUE = "  ";
    public static final int MERGE_TYPE_AND = 1;
    public static final int MERGE_TYPE_OR = 2;
    private static final Pattern SEGMENT_RANGE_PATTERN = Pattern.compile("^segment=([^:\\s]*)(:([-]?(\\d+)),([-]?(\\d+)))?$");
    private static final Pattern ROWS_RANGE_PATTERN = Pattern.compile("^rows=([-]?(\\d+))-([-]?(\\d+))$");
    public static final List<String> VALID_LINK_COMMAND_FIELDS = new ArrayList<String>(5);

    public DasCommandManager(DataSourceManager dsm, MydasServlet mydasServlet) {
        this.mydasServlet = mydasServlet;
        DATA_SOURCE_MANAGER = dsm;
        if (PULL_PARSER_FACTORY == null) {
            try {
                PULL_PARSER_FACTORY = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
                PULL_PARSER_FACTORY.setNamespaceAware(true);
            }
            catch (XmlPullParserException xppe) {
                logger.error((Object)"Fatal Exception thrown at initialisation.  Cannot initialise the PullParserFactory required to allow generation of the DAS XML.", (Throwable)xppe);
                throw new IllegalStateException("Fatal Exception thrown at initialisation.  Cannot initialise the PullParserFactory required to allow generation of the DAS XML.", xppe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dsnCommand(HttpServletRequest request, HttpServletResponse response, String queryString) throws XmlPullParserException, IOException {
        if (DATA_SOURCE_MANAGER.getServerConfiguration() == null) {
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            logger.error((Object)"A request has been made to the das server, however initialisation failed - possibly the mydasserverconfig.xml file was not found.");
            return;
        }
        if (queryString == null || queryString.length() == 0) {
            List<String> dsns = DATA_SOURCE_MANAGER.getServerConfiguration().getDsnNames();
            if (dsns == null || dsns.size() == 0) {
                this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
                logger.error((Object)"The dsn command has been called, but no dsns have been initialised successfully.");
            } else {
                this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, null);
                XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
                BufferedWriter out = null;
                try {
                    out = this.getResponseWriter(request, response);
                    serializer.setOutput((Writer)out);
                    serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
                    serializer.startDocument(null, Boolean.valueOf(false));
                    serializer.text("\n");
                    if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getDsnXSLT() != null) {
                        serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getDsnXSLT());
                        serializer.text("\n");
                    }
                    serializer.docdecl(" DASDSN SYSTEM \"http://www.biodas.org/dtd/dasdsn.dtd\"");
                    serializer.text("\n");
                    serializer.startTag(DAS_XML_NAMESPACE, "DASDSN");
                    for (String dsn : dsns) {
                        DataSourceConfiguration dsnConfig = DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfig(dsn);
                        serializer.startTag(DAS_XML_NAMESPACE, "DSN");
                        serializer.startTag(DAS_XML_NAMESPACE, "SOURCE");
                        serializer.attribute(DAS_XML_NAMESPACE, "id", dsnConfig.getId());
                        if (dsnConfig.getVersion() != null && dsnConfig.getVersion().length() > 0) {
                            serializer.attribute(DAS_XML_NAMESPACE, "version", dsnConfig.getVersion());
                        }
                        if (dsnConfig.getName() != null && dsnConfig.getName().length() > 0) {
                            serializer.text(dsnConfig.getName());
                        } else {
                            serializer.text(dsnConfig.getId());
                        }
                        serializer.endTag(DAS_XML_NAMESPACE, "SOURCE");
                        serializer.startTag(DAS_XML_NAMESPACE, "MAPMASTER");
                        serializer.text(dsnConfig.getMapmaster());
                        serializer.endTag(DAS_XML_NAMESPACE, "MAPMASTER");
                        if (dsnConfig.getDescription() != null && dsnConfig.getDescription().length() > 0) {
                            serializer.startTag(DAS_XML_NAMESPACE, "DESCRIPTION");
                            serializer.text(dsnConfig.getDescription());
                            serializer.endTag(DAS_XML_NAMESPACE, "DESCRIPTION");
                        }
                        serializer.endTag(DAS_XML_NAMESPACE, "DSN");
                    }
                    serializer.endTag(DAS_XML_NAMESPACE, "DASDSN");
                    serializer.flush();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        } else {
            this.writeHeader(request, response, XDasStatus.STATUS_402_BAD_COMMAND_ARGUMENTS, true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dnaCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws XmlPullParserException, IOException, DataSourceException, UnimplementedFeatureException, BadReferenceObjectException, BadCommandArgumentsException, CoordinateErrorException {
        if (!dsnConfig.isDnaCommandEnabled()) throw new UnimplementedFeatureException("The dna command has been disabled for this data source.");
        if (!(dsnConfig.getDataSource() instanceof ReferenceDataSource)) throw new UnimplementedFeatureException("The dna command has been called on an annotation server.");
        Collection<SequenceReporter> sequences = this.getSequences(dsnConfig, queryString, true);
        this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
        XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
        BufferedWriter out = null;
        try {
            out = this.getResponseWriter(request, response);
            serializer.setOutput((Writer)out);
            serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
            serializer.startDocument(null, Boolean.valueOf(false));
            serializer.text("\n");
            if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getDnaXSLT() != null) {
                serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getDnaXSLT());
                serializer.text("\n");
            }
            serializer.docdecl(" DASDNA SYSTEM \"http://www.biodas.org/dtd/dasdna.dtd\"");
            serializer.text("\n");
            serializer.startTag(DAS_XML_NAMESPACE, "DASDNA");
            for (SequenceReporter sequenceReporter : sequences) {
                if (sequenceReporter instanceof FoundSequenceReporter) {
                    FoundSequenceReporter foundSequenceReporter = (FoundSequenceReporter)sequenceReporter;
                    foundSequenceReporter.serialize(DAS_XML_NAMESPACE, serializer, true);
                    continue;
                }
                if (!(sequenceReporter instanceof ErrorSequenceReporter)) continue;
                ErrorSequenceReporter errorSequenceReporter = (ErrorSequenceReporter)sequenceReporter;
                errorSequenceReporter.serialize(DAS_XML_NAMESPACE, serializer);
            }
            serializer.endTag(DAS_XML_NAMESPACE, "DASDNA");
            serializer.flush();
            return;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private Collection<SequenceReporter> getSequences(DataSourceConfiguration dsnConfig, String queryString, boolean unknownSegmentsHandled) throws DataSourceException, BadCommandArgumentsException, BadReferenceObjectException, CoordinateErrorException {
        String[] referenceStrings;
        ReferenceDataSource refDsn = (ReferenceDataSource)dsnConfig.getDataSource();
        if (refDsn == null) {
            throw new DataSourceException("An attempt has been made to retrieve a sequenceString from datasource " + dsnConfig.getId() + " however the DataSource object is null.");
        }
        ArrayList<SequenceReporter> sequenceCollection = new ArrayList<SequenceReporter>();
        if (queryString == null || queryString.length() == 0) {
            throw new BadCommandArgumentsException("Expecting at least one reference in the query string, but found nothing.");
        }
        for (String referenceString : referenceStrings = queryString.split(";")) {
            Matcher referenceStringMatcher = SEGMENT_RANGE_PATTERN.matcher(referenceString);
            if (!referenceStringMatcher.find()) continue;
            SegmentQuery segmentQuery = new SegmentQuery(referenceStringMatcher);
            try {
                DasSequence sequence = segmentQuery.getStartCoordinate() == null ? refDsn.getSequence(segmentQuery.getSegmentId()) : (refDsn instanceof RangeHandlingReferenceDataSource ? ((RangeHandlingReferenceDataSource)refDsn).getSequence(segmentQuery.getSegmentId(), segmentQuery.getStartCoordinate(), segmentQuery.getStopCoordinate()) : refDsn.getSequence(segmentQuery.getSegmentId()));
                if (segmentQuery.getStartCoordinate() != null && segmentQuery.getStopCoordinate() != null) {
                    boolean error = false;
                    if (segmentQuery.getStartCoordinate() != null && segmentQuery.getStopCoordinate() != null) {
                        error = segmentQuery.getStartCoordinate() <= 0 || segmentQuery.getStopCoordinate() <= 0 ? true : (segmentQuery.getStartCoordinate() > segmentQuery.getStopCoordinate() ? true : sequence.getStartCoordinate() > segmentQuery.getStartCoordinate() || segmentQuery.getStartCoordinate() > sequence.getStopCoordinate() || sequence.getStartCoordinate() > segmentQuery.getStopCoordinate());
                    }
                    if (error) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("SEGMENT START & STOP OUT OF BOUNDS: query(" + segmentQuery.getStartCoordinate() + ", " + segmentQuery.getStopCoordinate() + ") " + "vs bounds(" + sequence.getStartCoordinate() + ", " + sequence.getStopCoordinate() + ")"));
                        }
                        throw new BadReferenceObjectException(segmentQuery.getSegmentId(), "start and stop out of segment bounds", new IndexOutOfBoundsException("start and stop out of segment bounds"));
                    }
                }
                sequenceCollection.add(new FoundSequenceReporter(sequence, segmentQuery));
            }
            catch (BadReferenceObjectException broe) {
                if (unknownSegmentsHandled) {
                    sequenceCollection.add(new ErrorSequenceReporter(segmentQuery));
                    continue;
                }
                throw broe;
            }
            catch (CoordinateErrorException cee) {
                if (unknownSegmentsHandled) {
                    sequenceCollection.add(new ErrorSequenceReporter(segmentQuery));
                    continue;
                }
                throw cee;
            }
        }
        if (sequenceCollection.size() == 0) {
            throw new BadCommandArgumentsException("The query string did not include any segments, so no sequence can be returned.");
        }
        return sequenceCollection;
    }

    private Collection<DasType> getAllTypes(DataSourceConfiguration dsnConfig) throws DataSourceException {
        Collection<DasType> allTypes = dsnConfig.getDataSource().getTypes();
        return allTypes == null ? Collections.EMPTY_LIST : allTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void typesCommandAllTypes(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, List<String> typeFilter) throws DataSourceException, XmlPullParserException, IOException {
        Collection<DasType> allTypes = this.getAllTypes(dsnConfig);
        HashMap<DasType, Integer> allTypesReport = new HashMap<DasType, Integer>(allTypes.size());
        for (DasType type : allTypes) {
            if (type == null || typeFilter.size() != 0 && !typeFilter.contains(type.getId())) continue;
            Integer typeCount = typeFilter.size() != 0 ? dsnConfig.getDataSource().getTotalCountForType(type) : dsnConfig.getDataSource().getTotalCountForType(type);
            allTypesReport.put(type, typeCount);
        }
        this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
        XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
        BufferedWriter out = null;
        try {
            out = this.getResponseWriter(request, response);
            serializer.setOutput((Writer)out);
            serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
            serializer.startDocument(null, Boolean.valueOf(false));
            serializer.text("\n");
            if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getTypesXSLT() != null) {
                serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getTypesXSLT());
                serializer.text("\n");
            }
            serializer.startTag(DAS_XML_NAMESPACE, "DASTYPES");
            serializer.startTag(DAS_XML_NAMESPACE, "GFF");
            serializer.attribute(DAS_XML_NAMESPACE, "version", "1.0");
            serializer.attribute(DAS_XML_NAMESPACE, "href", this.buildRequestHref(request));
            serializer.startTag(DAS_XML_NAMESPACE, "SEGMENT");
            serializer.attribute(DAS_XML_NAMESPACE, "label", "Complete datasource summary");
            for (DasType type : allTypesReport.keySet()) {
                new DasTypeE(type).serialize(DAS_XML_NAMESPACE, serializer, (Integer)allTypesReport.get(type), false);
            }
            serializer.endTag(DAS_XML_NAMESPACE, "SEGMENT");
            serializer.endTag(DAS_XML_NAMESPACE, "GFF");
            serializer.endTag(DAS_XML_NAMESPACE, "DASTYPES");
            serializer.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void typesCommandSpecificSegments(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, List<SegmentQuery> requestedSegments, List<String> typeFilter) throws DataSourceException, BadReferenceObjectException, XmlPullParserException, IOException, CoordinateErrorException {
        HashMap typesReport = new HashMap(requestedSegments.size());
        Collection<SegmentReporter> segmentReporters = this.features2reporters(this.getFeatureCollection(dsnConfig, requestedSegments, true, null), requestedSegments);
        for (SegmentReporter uncastReporter : segmentReporters) {
            HashMap<DasType, Integer> segmentTypes;
            SegmentReporter segmentReporter;
            if (uncastReporter instanceof FoundFeaturesReporter) {
                segmentReporter = (FoundFeaturesReporter)uncastReporter;
                segmentTypes = new HashMap<DasType, Integer>();
                typesReport.put(segmentReporter, segmentTypes);
                if (dsnConfig.isIncludeTypesWithZeroCount()) {
                    Collection<DasType> allTypes = this.getAllTypes(dsnConfig);
                    for (DasType type : allTypes) {
                        if (type == null || typeFilter.size() != 0 && !typeFilter.contains(type.getId())) continue;
                        segmentTypes.put(type, 0);
                    }
                }
                for (DasFeature feature : ((FoundFeaturesReporter)segmentReporter).getFeatures()) {
                    if (typeFilter.size() != 0 && !typeFilter.contains(feature.getType().getId())) continue;
                    DasType featureType = feature.getType();
                    if (segmentTypes.keySet().contains(featureType)) {
                        segmentTypes.put(featureType, (Integer)segmentTypes.get(featureType) + 1);
                        continue;
                    }
                    segmentTypes.put(featureType, 1);
                }
                continue;
            }
            if (uncastReporter instanceof UnknownSegmentReporter) {
                segmentReporter = (UnknownSegmentReporter)uncastReporter;
                segmentTypes = new HashMap();
                typesReport.put(segmentReporter, segmentTypes);
                continue;
            }
            if (!(uncastReporter instanceof ErrorSegmentReporter)) continue;
            segmentReporter = (ErrorSegmentReporter)uncastReporter;
            segmentTypes = new HashMap();
            typesReport.put(segmentReporter, segmentTypes);
        }
        this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
        XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
        BufferedWriter out = null;
        try {
            out = this.getResponseWriter(request, response);
            serializer.setOutput((Writer)out);
            serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
            serializer.startDocument(null, Boolean.valueOf(false));
            serializer.text("\n");
            if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getTypesXSLT() != null) {
                serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getTypesXSLT());
                serializer.text("\n");
            }
            serializer.docdecl(" DASTYPES SYSTEM \"http://www.biodas.org/dtd/dastypes.dtd\"");
            serializer.text("\n");
            serializer.startTag(DAS_XML_NAMESPACE, "DASTYPES");
            serializer.startTag(DAS_XML_NAMESPACE, "GFF");
            serializer.attribute(DAS_XML_NAMESPACE, "version", "1.0");
            serializer.attribute(DAS_XML_NAMESPACE, "href", this.buildRequestHref(request));
            for (SegmentReporter segmentReporter : typesReport.keySet()) {
                if (segmentReporter instanceof UnknownSegmentReporter) {
                    boolean referenceSource = dsnConfig.getDataSource() instanceof ReferenceDataSource;
                    ((UnknownSegmentReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer, referenceSource);
                    continue;
                }
                if (segmentReporter instanceof ErrorSegmentReporter) {
                    ((ErrorSegmentReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer);
                    continue;
                }
                if (!(segmentReporter instanceof FoundFeaturesReporter)) continue;
                FoundFeaturesReporter featureReporter = (FoundFeaturesReporter)segmentReporter;
                serializer.startTag(DAS_XML_NAMESPACE, "SEGMENT");
                serializer.attribute(DAS_XML_NAMESPACE, "id", featureReporter.getSegmentId());
                if (featureReporter.getStart() != null && featureReporter.getStop() != null) {
                    serializer.attribute(DAS_XML_NAMESPACE, "start", Integer.toString(featureReporter.getStart()));
                    serializer.attribute(DAS_XML_NAMESPACE, "stop", Integer.toString(featureReporter.getStop()));
                }
                if (featureReporter.getType() != null && featureReporter.getType().length() > 0) {
                    serializer.attribute(DAS_XML_NAMESPACE, "type", featureReporter.getType());
                }
                serializer.attribute(DAS_XML_NAMESPACE, "version", featureReporter.getVersion());
                if (featureReporter.getSegmentLabel() != null && featureReporter.getSegmentLabel().length() > 0) {
                    serializer.attribute(DAS_XML_NAMESPACE, "label", featureReporter.getSegmentLabel());
                }
                Map typeMap = (Map)typesReport.get(featureReporter);
                for (DasType type : typeMap.keySet()) {
                    new DasTypeE(type).serialize(DAS_XML_NAMESPACE, serializer, (Integer)typeMap.get(type), false);
                }
                serializer.endTag(DAS_XML_NAMESPACE, "SEGMENT");
            }
            serializer.endTag(DAS_XML_NAMESPACE, "GFF");
            serializer.endTag(DAS_XML_NAMESPACE, "DASTYPES");
            serializer.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stylesheetCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws BadCommandArgumentsException, IOException, BadStylesheetException {
        block12: {
            String stylesheetFileName;
            if (queryString != null && queryString.trim().length() > 0) {
                throw new BadCommandArgumentsException("Arguments have been passed to the stylesheet command, which does not expect any.");
            }
            if (dsnConfig.getStyleSheet() != null && dsnConfig.getStyleSheet().trim().length() > 0) {
                stylesheetFileName = dsnConfig.getStyleSheet().trim();
            } else if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getDefaultStyleSheet() != null && DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getDefaultStyleSheet().trim().length() > 0) {
                stylesheetFileName = DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getDefaultStyleSheet().trim();
            } else {
                throw new BadStylesheetException("This data source has not defined a stylesheet.");
            }
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.mydasServlet.getServletContext().getResourceAsStream("/" + stylesheetFileName)));
                if (reader.ready()) {
                    this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
                    writer = this.getResponseWriter(request, response);
                    while (reader.ready()) {
                        writer.write(reader.readLine());
                    }
                    writer.flush();
                    break block12;
                }
                throw new BadStylesheetException("A problem has occurred reading in the stylesheet from the open stream");
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void featuresCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws XmlPullParserException, IOException, DataSourceException, BadCommandArgumentsException, UnimplementedFeatureException, BadReferenceObjectException, CoordinateErrorException {
        if (queryString == null || queryString.length() == 0) {
            throw new BadCommandArgumentsException("Expecting at least one reference in the query string, but found nothing.");
        }
        ArrayList<SegmentQuery> requestedSegments = new ArrayList<SegmentQuery>();
        String[] queryParts = queryString.split(";");
        DasFeatureRequestFilter filter = new DasFeatureRequestFilter();
        boolean categorize = true;
        for (String queryPart : queryParts) {
            Matcher segmentRangeMatcher = SEGMENT_RANGE_PATTERN.matcher(queryPart);
            if (segmentRangeMatcher.find()) {
                requestedSegments.add(new SegmentQuery(segmentRangeMatcher));
                continue;
            }
            String[] queryPartKeysValues = queryPart.split("=");
            if (queryPartKeysValues.length != 2) {
                throw new BadCommandArgumentsException("Bad command arguments to the features command: " + queryString);
            }
            String key = queryPartKeysValues[0];
            String value = queryPartKeysValues[1];
            if ("type".equals(key)) {
                filter.addTypeId(URLDecoder.decode(value, ENCODE));
                continue;
            }
            if ("category".equals(key)) {
                filter.addCategoryId(URLDecoder.decode(value, ENCODE));
                continue;
            }
            if ("categorize".equals(key)) {
                if (!"no".equals(value)) continue;
                categorize = false;
                continue;
            }
            if ("feature_id".equals(key)) {
                filter.addFeatureId(URLDecoder.decode(value, ENCODE));
                continue;
            }
            if ("query".equals(key)) {
                filter.setAdvanceQuery(value);
                continue;
            }
            if ("maxbins".equals(key)) {
                try {
                    filter.setMaxbins(new Integer(value));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new BadCommandArgumentsException("Bad command arguments to the features command. the maxbeans attribute should be Numeric: " + queryString);
                }
            }
            if (!"rows".equals(key)) continue;
            try {
                String[] limits = value.split("-");
                if (limits.length != 2) {
                    throw new BadCommandArgumentsException("Bad command arguments to the features command. the rows attribute should be of the form [START]-[END]: " + queryString);
                }
                filter.setRows(new Range(new Integer(limits[0]), new Integer(limits[1])));
            }
            catch (NumberFormatException nfe) {
                throw new BadCommandArgumentsException("Bad command arguments to the features command. the rows attribute should of the form [START]-[END] here START and END have to be integers: " + queryString);
            }
        }
        filter.setRequestedSegments(requestedSegments);
        Collection<DasAnnotatedSegment> segmentsByFeatureId = null;
        Collection<DasAnnotatedSegment> segmentsBySegmentId = null;
        Collection<SegmentReporter> segmentReporterCollections = null;
        Collection<DasAnnotatedSegment> merged = null;
        if (dsnConfig.getCapabilities().contains("advanced-search") && filter.getAdvanceQuery() != null) {
            Map<String, PropertyType> properties = DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getGlobalParameters();
            Searcher searcher = new Searcher(properties.get("indexerpath").getValue(), dsnConfig.getName());
            try {
                merged = searcher.search(filter);
            }
            catch (SearcherException e) {
                logger.error((Object)"Searching/indexing thrown", (Throwable)e);
            }
        } else {
            if (requestedSegments.size() > 0) {
                segmentsBySegmentId = this.getFeatureCollection(dsnConfig, requestedSegments, true, filter);
            }
            if (dsnConfig.getCapabilities().contains("feature-by-id") && filter.containsFeatureIds()) {
                try {
                    if (!dsnConfig.getCapabilities().contains("rows-for-feature")) {
                        throw new UnimplementedFeatureException("rows-for-feature capability no declared");
                    }
                    segmentsByFeatureId = dsnConfig.getDataSource().getFeatures(filter.getFeatureIds(), filter.getMaxbins(), filter.getRows());
                    filter.setPaginated(true);
                }
                catch (UnimplementedFeatureException ufe) {
                    segmentsByFeatureId = dsnConfig.getDataSource().getFeatures(filter.getFeatureIds(), filter.getMaxbins());
                }
            }
            if (segmentsBySegmentId != null) {
                merged = segmentsByFeatureId != null ? this.merge(segmentsBySegmentId, segmentsByFeatureId, 1) : segmentsBySegmentId;
            } else if (segmentsByFeatureId != null) {
                merged = segmentsByFeatureId;
            } else {
                throw new BadCommandArgumentsException("Bad command arguments to the features command: " + queryString);
            }
            Integer totalFeatures = null;
            if (!filter.isPaginated() && filter.getRows() != null && dsnConfig.getCapabilities().contains("rows-for-feature")) {
                totalFeatures = 0;
                Integer included = 0;
                ArrayList<DasAnnotatedSegment> paged = new ArrayList<DasAnnotatedSegment>();
                for (DasAnnotatedSegment segmentAux : merged) {
                    totalFeatures = totalFeatures + segmentAux.getFeatures().size();
                    if (filter.getRows().getFrom() > totalFeatures) continue;
                    if (filter.getRows().getTo() > totalFeatures) {
                        paged.add(segmentAux);
                        included = included + segmentAux.getFeatures().size();
                        continue;
                    }
                    List<DasFeature> featuresAux = ((ArrayList)segmentAux.getFeatures()).subList(filter.getRows().getFrom() - 1 - included, filter.getRows().getTo() - included);
                    paged.add(new DasAnnotatedSegment(segmentAux.getSegmentId(), segmentAux.getStartCoordinate(), segmentAux.getStopCoordinate(), segmentAux.getVersion(), segmentAux.getSegmentLabel(), featuresAux, segmentAux.getFeatures().size()));
                }
                filter.setPaginated(true);
                filter.setTotalFeatures(totalFeatures);
                merged = paged;
            }
        }
        segmentReporterCollections = this.features2reporters(merged, requestedSegments);
        this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
        XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
        BufferedWriter out = null;
        try {
            boolean referenceSource = dsnConfig.getDataSource() instanceof ReferenceDataSource;
            out = this.getResponseWriter(request, response);
            serializer.setOutput((Writer)out);
            serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
            serializer.startDocument(null, Boolean.valueOf(false));
            serializer.text("\n");
            if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getFeaturesXSLT() != null) {
                serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getFeaturesXSLT());
                serializer.text("\n");
            }
            serializer.startTag(DAS_XML_NAMESPACE, "DASGFF");
            serializer.startTag(DAS_XML_NAMESPACE, "GFF");
            serializer.attribute(DAS_XML_NAMESPACE, "href", this.buildRequestHref(request));
            if (filter.isPaginated() && filter.getTotalFeatures() != null) {
                serializer.attribute(DAS_XML_NAMESPACE, "total", "" + filter.getTotalFeatures());
            }
            for (SegmentReporter segmentReporter : segmentReporterCollections) {
                if (segmentReporter instanceof UnknownSegmentReporter) {
                    ((UnknownSegmentReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer, referenceSource);
                    continue;
                }
                if (segmentReporter instanceof ErrorSegmentReporter) {
                    ((ErrorSegmentReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer);
                    continue;
                }
                if (segmentReporter instanceof UnknownFeatureSegmentReporter) {
                    ((UnknownFeatureSegmentReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer);
                    continue;
                }
                ((FoundFeaturesReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer, filter, categorize, false, dsnConfig.isUseFeatureIdForFeatureLabel());
            }
            serializer.endTag(DAS_XML_NAMESPACE, "GFF");
            serializer.endTag(DAS_XML_NAMESPACE, "DASGFF");
            serializer.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    void linkCommand(HttpServletResponse response, DataSourceConfiguration dataSourceConfig, String queryString) throws IOException, BadCommandArgumentsException, DataSourceException, UnimplementedFeatureException {
        if (queryString == null || queryString.length() == 0) {
            throw new BadCommandArgumentsException("The link command has been called with no arguments.");
        }
        String[] queryParts = queryString.split(";");
        if (queryParts.length < 2) {
            throw new BadCommandArgumentsException("Not enough arguments have been passed to the link command.");
        }
        String field = null;
        String id = null;
        for (String keyValuePair : queryParts) {
            String[] queryPartKeysValues = keyValuePair.split("=");
            if (queryPartKeysValues.length != 2) {
                throw new BadCommandArgumentsException("keys and values cannot be extracted from the arguments to the link command");
            }
            if ("field".equals(queryPartKeysValues[0])) {
                field = queryPartKeysValues[1];
                continue;
            }
            if (!"id".equals(queryPartKeysValues[0])) continue;
            id = queryPartKeysValues[1];
        }
        if (field == null || !VALID_LINK_COMMAND_FIELDS.contains(field) || id == null) {
            throw new BadCommandArgumentsException("The link command must be passed a valid field and id argument.");
        }
        URL url = dataSourceConfig.getDataSource().getLinkURL(field, id);
        response.sendRedirect(response.encodeRedirectURL(url.toString()));
    }

    private Collection<DasAnnotatedSegment> getFeatureCollection(DataSourceConfiguration dsnConfig, List<SegmentQuery> requestedSegments, boolean unknownSegmentsHandled, DasFeatureRequestFilter filter) throws DataSourceException, BadReferenceObjectException, CoordinateErrorException {
        ArrayList<DasAnnotatedSegment> segments = new ArrayList<DasAnnotatedSegment>(requestedSegments.size());
        AnnotationDataSource dataSource = dsnConfig.getDataSource();
        Integer maxbins = null;
        if (filter != null) {
            maxbins = filter.getMaxbins();
        }
        Integer current = 0;
        for (SegmentQuery segmentQuery : requestedSegments) {
            try {
                DasAnnotatedSegment annotatedSegment;
                Range currentFeatureRange = null;
                if (filter != null && dsnConfig.getCapabilities().contains("rows-for-feature") && filter.getRows() != null) {
                    currentFeatureRange = new Range(filter.getRows().getFrom() - current, filter.getRows().getTo() - current);
                }
                if (segmentQuery.getStartCoordinate() == null) {
                    try {
                        if (currentFeatureRange == null) {
                            throw new UnimplementedFeatureException("if is null is because there is not necessity for pagination");
                        }
                        annotatedSegment = dataSource.getFeatures(segmentQuery.getSegmentId(), maxbins, currentFeatureRange);
                        filter.setPaginated(true);
                    }
                    catch (UnimplementedFeatureException ufe) {
                        annotatedSegment = dataSource.getFeatures(segmentQuery.getSegmentId(), maxbins);
                    }
                } else if (dataSource instanceof RangeHandlingAnnotationDataSource) {
                    try {
                        if (currentFeatureRange == null) {
                            throw new UnimplementedFeatureException("if is null is because there is not necesity for pagination");
                        }
                        annotatedSegment = ((RangeHandlingAnnotationDataSource)dataSource).getFeatures(segmentQuery.getSegmentId(), segmentQuery.getStartCoordinate(), segmentQuery.getStopCoordinate(), maxbins, currentFeatureRange);
                        filter.setPaginated(true);
                    }
                    catch (UnimplementedFeatureException ufe) {
                        annotatedSegment = ((RangeHandlingAnnotationDataSource)dataSource).getFeatures(segmentQuery.getSegmentId(), segmentQuery.getStartCoordinate(), segmentQuery.getStopCoordinate(), maxbins);
                    }
                } else if (dataSource instanceof RangeHandlingReferenceDataSource) {
                    try {
                        if (currentFeatureRange == null) {
                            throw new UnimplementedFeatureException("if is null is because there is not necesity for pagination");
                        }
                        annotatedSegment = ((RangeHandlingReferenceDataSource)dataSource).getFeatures(segmentQuery.getSegmentId(), segmentQuery.getStartCoordinate(), segmentQuery.getStopCoordinate(), maxbins, currentFeatureRange);
                        filter.setPaginated(true);
                    }
                    catch (UnimplementedFeatureException ufe) {
                        annotatedSegment = ((RangeHandlingReferenceDataSource)dataSource).getFeatures(segmentQuery.getSegmentId(), segmentQuery.getStartCoordinate(), segmentQuery.getStopCoordinate(), maxbins);
                    }
                } else {
                    try {
                        if (currentFeatureRange == null) {
                            throw new UnimplementedFeatureException("if is null is because there is not necesity for pagination");
                        }
                        annotatedSegment = dataSource.getFeatures(segmentQuery.getSegmentId(), maxbins, currentFeatureRange);
                        filter.setPaginated(true);
                    }
                    catch (UnimplementedFeatureException ufe) {
                        annotatedSegment = dataSource.getFeatures(segmentQuery.getSegmentId(), maxbins);
                    }
                }
                boolean error = false;
                if (segmentQuery.getStartCoordinate() != null && segmentQuery.getStopCoordinate() != null) {
                    error = segmentQuery.getStartCoordinate() <= 0 || segmentQuery.getStopCoordinate() <= 0 ? true : (segmentQuery.getStartCoordinate() > segmentQuery.getStopCoordinate() ? true : annotatedSegment.getStartCoordinate() > segmentQuery.getStartCoordinate() || segmentQuery.getStartCoordinate() > annotatedSegment.getStopCoordinate() || annotatedSegment.getStartCoordinate() > segmentQuery.getStopCoordinate());
                }
                if (error) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SEGMENT START & STOP OUT OF BOUNDS: query(" + segmentQuery.getStartCoordinate() + ", " + segmentQuery.getStopCoordinate() + ") " + "vs bounds(" + annotatedSegment.getStartCoordinate() + ", " + annotatedSegment.getStopCoordinate() + ")"));
                    }
                    throw new BadReferenceObjectException(segmentQuery.getSegmentId(), "start and stop out of segment bounds", new IndexOutOfBoundsException("start and stop out of segment bounds"));
                }
                segments.add(annotatedSegment);
                current = current + annotatedSegment.getTotalFeatures();
            }
            catch (BadReferenceObjectException broe) {
                if (unknownSegmentsHandled) {
                    if (dataSource instanceof ReferenceDataSource) {
                        segments.add(new ErrorSegment(segmentQuery));
                        continue;
                    }
                    segments.add(new DasUnknownFeatureSegment(segmentQuery));
                    continue;
                }
                throw broe;
            }
            catch (CoordinateErrorException cee) {
                if (unknownSegmentsHandled) {
                    segments.add(new DasUnknownFeatureSegment(segmentQuery));
                    continue;
                }
                throw cee;
            }
        }
        return segments;
    }

    private Collection<SegmentReporter> features2reporters(Collection<DasAnnotatedSegment> segments, Collection<SegmentQuery> segmentQueries) {
        ArrayList<SegmentReporter> segmentReporterLists = new ArrayList<SegmentReporter>(segments.size());
        for (DasAnnotatedSegment segment : segments) {
            SegmentQuery segmentQuery = this.getSegmentQueryById(segmentQueries, segment.getSegmentId());
            segmentReporterLists.add(this.segment2SegmentReporter(segment, segmentQuery));
        }
        return segmentReporterLists;
    }

    private SegmentReporter segment2SegmentReporter(DasSegment segment, SegmentQuery segmentQuery) {
        if (segment instanceof DasUnknownFeatureSegment) {
            DasUnknownFeatureSegment unknownSegment = (DasUnknownFeatureSegment)segment;
            if (unknownSegment.getSegmentQuery() != null) {
                return new UnknownSegmentReporter(unknownSegment.getSegmentQuery());
            }
            return new UnknownFeatureSegmentReporter(unknownSegment.getSegmentId());
        }
        if (segment instanceof ErrorSegment) {
            ErrorSegment errorSegment = (ErrorSegment)segment;
            return new ErrorSegmentReporter(errorSegment.getSegmentQuery());
        }
        if (segment instanceof DasAnnotatedSegment) {
            DasAnnotatedSegment annotatedSegment = (DasAnnotatedSegment)segment;
            if (segmentQuery != null) {
                return new FoundFeaturesReporter(annotatedSegment, segmentQuery);
            }
            return new FoundFeaturesReporter(annotatedSegment);
        }
        return null;
    }

    private SegmentQuery getSegmentQueryById(Collection<SegmentQuery> segmentQueries, String segmentId) {
        if (segmentQueries != null) {
            for (SegmentQuery segment : segmentQueries) {
                if (!segment.getSegmentId().equalsIgnoreCase(segmentId)) continue;
                return segment;
            }
        }
        return null;
    }

    protected Collection<SegmentReporter> getFeatureCollectionOld(DataSourceConfiguration dsnConfig, List<SegmentQuery> requestedSegments, boolean unknownSegmentsHandled, Integer maxbins) throws DataSourceException, BadReferenceObjectException, CoordinateErrorException {
        ArrayList<SegmentReporter> segmentReporterLists = new ArrayList<SegmentReporter>(requestedSegments.size());
        AnnotationDataSource dataSource = dsnConfig.getDataSource();
        for (SegmentQuery segmentQuery : requestedSegments) {
            try {
                DasAnnotatedSegment annotatedSegment = segmentQuery.getStartCoordinate() == null ? dataSource.getFeatures(segmentQuery.getSegmentId(), maxbins) : (dataSource instanceof RangeHandlingAnnotationDataSource ? ((RangeHandlingAnnotationDataSource)dataSource).getFeatures(segmentQuery.getSegmentId(), segmentQuery.getStartCoordinate(), segmentQuery.getStopCoordinate(), maxbins) : (dataSource instanceof RangeHandlingReferenceDataSource ? ((RangeHandlingReferenceDataSource)dataSource).getFeatures(segmentQuery.getSegmentId(), segmentQuery.getStartCoordinate(), segmentQuery.getStopCoordinate(), maxbins) : dataSource.getFeatures(segmentQuery.getSegmentId(), maxbins)));
                boolean error = false;
                if (segmentQuery.getStartCoordinate() != null && segmentQuery.getStopCoordinate() != null) {
                    error = segmentQuery.getStartCoordinate() <= 0 || segmentQuery.getStopCoordinate() <= 0 ? true : (segmentQuery.getStartCoordinate() > segmentQuery.getStopCoordinate() ? true : annotatedSegment.getStartCoordinate() > segmentQuery.getStartCoordinate() || segmentQuery.getStartCoordinate() > annotatedSegment.getStopCoordinate() || annotatedSegment.getStartCoordinate() > segmentQuery.getStopCoordinate());
                }
                if (error) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SEGMENT START & STOP OUT OF BOUNDS: query(" + segmentQuery.getStartCoordinate() + ", " + segmentQuery.getStopCoordinate() + ") " + "vs bounds(" + annotatedSegment.getStartCoordinate() + ", " + annotatedSegment.getStopCoordinate() + ")"));
                    }
                    throw new BadReferenceObjectException(segmentQuery.getSegmentId(), "start and stop out of segment bounds", new IndexOutOfBoundsException("start and stop out of segment bounds"));
                }
                segmentReporterLists.add(new FoundFeaturesReporter(annotatedSegment, segmentQuery));
            }
            catch (BadReferenceObjectException broe) {
                if (unknownSegmentsHandled) {
                    if (broe.getCause() != null) {
                        segmentReporterLists.add(new ErrorSegmentReporter(segmentQuery));
                        continue;
                    }
                    segmentReporterLists.add(new UnknownSegmentReporter(segmentQuery));
                    continue;
                }
                throw broe;
            }
            catch (CoordinateErrorException cee) {
                if (unknownSegmentsHandled) {
                    segmentReporterLists.add(new UnknownSegmentReporter(segmentQuery));
                    continue;
                }
                throw cee;
            }
        }
        return segmentReporterLists;
    }

    private String buildRequestHref(HttpServletRequest request) {
        StringBuffer requestURL = new StringBuffer(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getBaseURL());
        String requestURI = request.getRequestURI();
        requestURL.append(requestURI.substring(5 + requestURI.indexOf("/das/")));
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            requestURL.append('?').append(queryString);
        }
        return requestURL.toString();
    }

    private BufferedWriter getResponseWriter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.mydasServlet.compressResponse(request)) {
            GZIPOutputStream zipStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
            return new BufferedWriter(new PrintWriter(zipStream));
        }
        return new BufferedWriter(response.getWriter());
    }

    private void writeHeader(HttpServletRequest request, HttpServletResponse response, XDasStatus status, boolean compressionAllowed, String capabilities) throws IOException {
        this.mydasServlet.writeHeader(request, response, status, compressionAllowed, capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sourceCommand(HttpServletRequest request, HttpServletResponse response, String queryString, String source) throws XmlPullParserException, IOException {
        if (DATA_SOURCE_MANAGER.getServerConfiguration() == null) {
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            logger.error((Object)"A request has been made to the das server, however initialisation failed - possibly the mydasserverconfig.xml file was not found.");
            return;
        }
        List<String> dsns = DATA_SOURCE_MANAGER.getServerConfiguration().getDsnNames();
        if (dsns == null || dsns.size() == 0) {
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            logger.error((Object)"The source command has been called, but no sources have been initialised successfully.");
        } else {
            if (source == null) {
                this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, null);
            } else {
                DataSourceConfiguration dataSourceConfig = DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfigMap().get(source);
                this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dataSourceConfig.getCapabilities());
            }
            XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
            BufferedWriter out = null;
            try {
                out = this.getResponseWriter(request, response);
                serializer.setOutput((Writer)out);
                serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
                serializer.startDocument(null, Boolean.valueOf(false));
                serializer.text("\n");
                if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getSourcesXSLT() != null) {
                    serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getSourcesXSLT());
                    serializer.text("\n");
                }
                serializer.startTag(DAS_XML_NAMESPACE, "SOURCES");
                ArrayList<String> versionsadded = new ArrayList<String>();
                for (String dsn : dsns) {
                    if (source != null && !source.equals(dsn) || versionsadded.contains(dsn)) continue;
                    Mydasserver.Datasources.Datasource dsnConfig2 = DATA_SOURCE_MANAGER.getServerConfiguration().getDataSourceConfig(dsn).getConfig();
                    serializer.startTag(DAS_XML_NAMESPACE, "SOURCE");
                    serializer.attribute(DAS_XML_NAMESPACE, "uri", dsnConfig2.getUri());
                    if (dsnConfig2.getDocHref() != null && dsnConfig2.getDocHref().length() > 0) {
                        serializer.attribute(DAS_XML_NAMESPACE, "doc_href", dsnConfig2.getDocHref());
                    }
                    serializer.attribute(DAS_XML_NAMESPACE, "title", dsnConfig2.getTitle());
                    serializer.attribute(DAS_XML_NAMESPACE, "description", dsnConfig2.getDescription());
                    serializer.startTag(DAS_XML_NAMESPACE, "MAINTAINER");
                    serializer.attribute(DAS_XML_NAMESPACE, "email", dsnConfig2.getMaintainer().getEmail());
                    serializer.endTag(DAS_XML_NAMESPACE, "MAINTAINER");
                    for (Mydasserver.Datasources.Datasource.Version version : dsnConfig2.getVersion()) {
                        versionsadded.add(version.getUri());
                        serializer.startTag(DAS_XML_NAMESPACE, "VERSION");
                        serializer.attribute(DAS_XML_NAMESPACE, "uri", version.getUri());
                        serializer.attribute(DAS_XML_NAMESPACE, "created", version.getCreated().toString());
                        for (Mydasserver.Datasources.Datasource.Version.Coordinates coordinates : version.getCoordinates()) {
                            serializer.startTag(DAS_XML_NAMESPACE, "COORDINATES");
                            serializer.attribute(DAS_XML_NAMESPACE, "uri", coordinates.getUri());
                            serializer.attribute(DAS_XML_NAMESPACE, "source", coordinates.getSource());
                            serializer.attribute(DAS_XML_NAMESPACE, "authority", coordinates.getAuthority());
                            if (coordinates.getTaxid() != null && coordinates.getTaxid().length() > 0) {
                                serializer.attribute(DAS_XML_NAMESPACE, "taxid", coordinates.getTaxid());
                            }
                            if (coordinates.getVersion() != null && coordinates.getVersion().length() > 0) {
                                serializer.attribute(DAS_XML_NAMESPACE, "version", coordinates.getVersion());
                            }
                            serializer.attribute(DAS_XML_NAMESPACE, "test_range", coordinates.getTestRange());
                            serializer.text(coordinates.getValue());
                            serializer.endTag(DAS_XML_NAMESPACE, "COORDINATES");
                        }
                        for (Mydasserver.Datasources.Datasource.Version.Capability capability : version.getCapability()) {
                            serializer.startTag(DAS_XML_NAMESPACE, "CAPABILITY");
                            serializer.attribute(DAS_XML_NAMESPACE, "type", capability.getType());
                            if (capability.getQueryUri() != null && capability.getQueryUri().length() > 0) {
                                serializer.attribute(DAS_XML_NAMESPACE, "query_uri", capability.getQueryUri());
                            }
                            serializer.endTag(DAS_XML_NAMESPACE, "CAPABILITY");
                        }
                        for (PropertyType pt : version.getProperty()) {
                            if (!pt.isVisibility()) continue;
                            serializer.startTag(DAS_XML_NAMESPACE, "PROPERTY");
                            serializer.attribute(DAS_XML_NAMESPACE, "name", pt.getKey());
                            serializer.attribute(DAS_XML_NAMESPACE, "value", pt.getValue());
                            serializer.endTag(DAS_XML_NAMESPACE, "PROPERTY");
                        }
                        serializer.endTag(DAS_XML_NAMESPACE, "VERSION");
                    }
                    serializer.endTag(DAS_XML_NAMESPACE, "SOURCE");
                }
                serializer.endTag(DAS_XML_NAMESPACE, "SOURCES");
                serializer.flush();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void entryPointsCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws XmlPullParserException, IOException, DataSourceException, UnimplementedFeatureException, BadCommandArgumentsException {
        Integer start = null;
        Integer stop = null;
        Integer expectedSize = null;
        if (queryString != null && queryString.trim().length() > 0) {
            Matcher rowsRangeMatcher = ROWS_RANGE_PATTERN.matcher(queryString);
            if (!rowsRangeMatcher.find()) {
                throw new BadCommandArgumentsException("Unexpected arguments have been passed to the entry_points command.");
            }
            start = new Integer(rowsRangeMatcher.group(1));
            stop = new Integer(rowsRangeMatcher.group(3));
            if (start <= 0 || stop <= 0 || stop < start) {
                throw new BadCommandArgumentsException("Unexpected arguments(stop lower than start or negative values) have been passed to the entry_points command.");
            }
            expectedSize = stop - start + 1;
        }
        if (dsnConfig.getDataSource() instanceof AnnotationDataSource) {
            AnnotationDataSource refDsn = dsnConfig.getDataSource();
            start = start == null ? 1 : start;
            stop = stop == null ? refDsn.getTotalEntryPoints() : Math.min(stop, refDsn.getTotalEntryPoints());
            stop = dsnConfig.getMaxEntryPoints() != null ? Math.min(stop, start + dsnConfig.getMaxEntryPoints() - 1) : stop;
            expectedSize = stop - start + 1;
            if (start > refDsn.getTotalEntryPoints()) {
                throw new BadCommandArgumentsException("Unexpected arguments (both start ans stop out of bounds) have been passed to the entry_points command.");
            }
            Collection<DasEntryPoint> entryPoints = refDsn.getEntryPoints(start, stop);
            if (refDsn.getEntryPointVersion() == null) {
                throw new DataSourceException("The dsn " + dsnConfig.getId() + "is returning null for the entry point version, which is invalid.");
            }
            this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
            XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
            BufferedWriter out = null;
            try {
                out = this.getResponseWriter(request, response);
                serializer.setOutput((Writer)out);
                serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
                serializer.startDocument(null, Boolean.valueOf(false));
                serializer.text("\n");
                if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getEntryPointsXSLT() != null) {
                    serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getEntryPointsXSLT());
                    serializer.text("\n");
                }
                serializer.startTag(DAS_XML_NAMESPACE, "DASEP");
                serializer.startTag(DAS_XML_NAMESPACE, "ENTRY_POINTS");
                serializer.attribute(DAS_XML_NAMESPACE, "href", this.buildRequestHref(request));
                if (refDsn.getEntryPointVersion() != null) {
                    serializer.attribute(DAS_XML_NAMESPACE, "version", refDsn.getEntryPointVersion());
                }
                serializer.attribute(DAS_XML_NAMESPACE, "total", "" + refDsn.getTotalEntryPoints());
                if (start != null) {
                    serializer.attribute(DAS_XML_NAMESPACE, "start", "" + start);
                }
                if (stop != null) {
                    if (expectedSize.intValue() == entryPoints.size()) {
                        if (dsnConfig.getMaxEntryPoints() != null && dsnConfig.getMaxEntryPoints() < entryPoints.size()) {
                            stop = start + dsnConfig.getMaxEntryPoints() - 1;
                        }
                    } else if (dsnConfig.getMaxEntryPoints() != null) {
                        if (dsnConfig.getMaxEntryPoints() < entryPoints.size()) {
                            stop = start + dsnConfig.getMaxEntryPoints() - 1;
                        } else if (entryPoints.size() != 0) {
                            stop = start + entryPoints.size() - 1;
                        }
                    } else if (entryPoints.size() != 0) {
                        stop = start + entryPoints.size() - 1;
                    }
                    serializer.attribute(DAS_XML_NAMESPACE, "end", "" + stop);
                }
                Iterator<DasEntryPoint> iterator = entryPoints.iterator();
                for (int i = start.intValue(); i <= stop && iterator.hasNext(); ++i) {
                    DasEntryPoint entryPoint = iterator.next();
                    if (entryPoint == null) continue;
                    new DasEntryPointE(entryPoint).serialize(DAS_XML_NAMESPACE, serializer);
                }
                serializer.endTag(DAS_XML_NAMESPACE, "ENTRY_POINTS");
                serializer.endTag(DAS_XML_NAMESPACE, "DASEP");
                serializer.flush();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        } else {
            throw new UnimplementedFeatureException("An attempt to request entry_point information from an non-annotation server has been detected.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sequenceCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws XmlPullParserException, IOException, DataSourceException, UnimplementedFeatureException, BadReferenceObjectException, BadCommandArgumentsException, CoordinateErrorException {
        if (dsnConfig.getDataSource() instanceof ReferenceDataSource) {
            Collection<SequenceReporter> sequences = this.getSequences(dsnConfig, queryString, true);
            this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
            XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
            BufferedWriter out = null;
            try {
                out = this.getResponseWriter(request, response);
                serializer.setOutput((Writer)out);
                serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
                serializer.startDocument(null, Boolean.valueOf(false));
                serializer.text("\n");
                if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getSequenceXSLT() != null) {
                    serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getSequenceXSLT());
                    serializer.text("\n");
                }
                serializer.startTag(DAS_XML_NAMESPACE, "DASSEQUENCE");
                for (SequenceReporter sequenceReporter : sequences) {
                    if (sequenceReporter instanceof FoundSequenceReporter) {
                        FoundSequenceReporter foundSequenceReporter = (FoundSequenceReporter)sequenceReporter;
                        foundSequenceReporter.serialize(DAS_XML_NAMESPACE, serializer);
                        continue;
                    }
                    if (!(sequenceReporter instanceof ErrorSequenceReporter)) continue;
                    ErrorSequenceReporter errorSequenceReporter = (ErrorSequenceReporter)sequenceReporter;
                    errorSequenceReporter.serialize(DAS_XML_NAMESPACE, serializer);
                }
                serializer.endTag(DAS_XML_NAMESPACE, "DASSEQUENCE");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        } else {
            throw new UnimplementedFeatureException("An attempt to request sequence information from an anntation server has been detected.");
        }
    }

    void typesCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws BadCommandArgumentsException, BadReferenceObjectException, DataSourceException, CoordinateErrorException, IOException, XmlPullParserException {
        ArrayList<SegmentQuery> requestedSegments = new ArrayList<SegmentQuery>();
        ArrayList<String> typeFilter = new ArrayList<String>();
        if (queryString != null && queryString.length() > 0) {
            String[] queryParts;
            for (String queryPart : queryParts = queryString.split(";")) {
                Matcher segmentRangeMatcher = SEGMENT_RANGE_PATTERN.matcher(queryPart);
                if (segmentRangeMatcher.find()) {
                    requestedSegments.add(new SegmentQuery(segmentRangeMatcher));
                    continue;
                }
                String[] queryPartKeysValues = queryPart.split("=");
                if (queryPartKeysValues.length != 2) {
                    throw new BadCommandArgumentsException("Bad command arguments to the types command: " + queryString);
                }
                String key = queryPartKeysValues[0];
                String value = queryPartKeysValues[1];
                if (!"type".equals(key)) continue;
                typeFilter.add(URLDecoder.decode(value, ENCODE));
            }
        }
        if (requestedSegments.size() == 0) {
            this.typesCommandAllTypes(request, response, dsnConfig, typeFilter);
        } else {
            this.typesCommandSpecificSegments(request, response, dsnConfig, requestedSegments, typeFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void structureCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws DataSourceException, UnimplementedFeatureException, BadCommandArgumentsException, XmlPullParserException, IOException, BadReferenceObjectException {
        if (dsnConfig.getDataSource() instanceof StructureDataSource) {
            ArrayList<String> chains = null;
            ArrayList<String> models = new ArrayList<String>();
            String query = null;
            if (queryString != null && queryString.length() > 0) {
                String[] queryParts;
                for (String queryPart : queryParts = queryString.split(";")) {
                    String[] queryPartKeysValues = queryPart.split("=");
                    if (queryPartKeysValues.length != 2) {
                        throw new BadCommandArgumentsException("Bad command arguments to the structure command: " + queryString);
                    }
                    String key = queryPartKeysValues[0];
                    String value = queryPartKeysValues[1];
                    if ("query".equals(key)) {
                        query = value;
                        continue;
                    }
                    if ("chain".equals(key)) {
                        if (chains == null) {
                            chains = new ArrayList<String>();
                        }
                        chains.add(value);
                        continue;
                    }
                    if (!"model".equals(key)) continue;
                    if (models == null) {
                        models = new ArrayList();
                    }
                    models.add(value);
                }
                if (query == null) {
                    throw new BadCommandArgumentsException("Bad command arguments - missing the query argument of the command structure: " + queryString);
                }
                this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
                XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
                BufferedWriter out = null;
                DasStructure structure = ((StructureDataSource)((Object)dsnConfig.getDataSource())).getStructure(query, chains, models);
                try {
                    out = this.getResponseWriter(request, response);
                    serializer.setOutput((Writer)out);
                    serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
                    serializer.startDocument(null, Boolean.valueOf(false));
                    serializer.text("\n");
                    structure.serialize(DAS_XML_NAMESPACE, serializer);
                    serializer.flush();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        } else {
            throw new UnimplementedFeatureException("An attempt to request structure information from a non-structure server has been detected.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void alignmentCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dsnConfig, String queryString) throws DataSourceException, UnimplementedFeatureException, BadCommandArgumentsException, XmlPullParserException, IOException, BadReferenceObjectException {
        if (dsnConfig.getDataSource() instanceof AlignmentDataSource) {
            ArrayList<String> subjects = null;
            String query = null;
            String subjectcoordsys = null;
            Integer rowStart = null;
            Integer rowEnd = null;
            Integer colStart = null;
            Integer colEnd = null;
            if (queryString != null && queryString.length() > 0) {
                String[] queryParts;
                for (String queryPart : queryParts = queryString.split(";")) {
                    String[] queryPartKeysValues = queryPart.split("=");
                    if (queryPartKeysValues.length != 2) {
                        throw new BadCommandArgumentsException("Bad command arguments to the alignment command: " + queryString);
                    }
                    String key = queryPartKeysValues[0];
                    String value = queryPartKeysValues[1];
                    if ("query".equals(key)) {
                        query = value;
                        continue;
                    }
                    if ("subject".equals(key)) {
                        if (subjects == null) {
                            subjects = new ArrayList<String>();
                        }
                        subjects.add(value);
                        continue;
                    }
                    if ("subjectcoordsys".equals(key)) {
                        subjectcoordsys = value;
                        continue;
                    }
                    if ("rows".equals(key)) {
                        String[] rowParts = queryString.split("-");
                        if (rowParts.length != 2) {
                            throw new BadCommandArgumentsException("Bad command arguments to the alignment command: " + queryString);
                        }
                        try {
                            rowStart = new Integer(rowParts[0]);
                            rowEnd = new Integer(rowParts[1]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            throw new BadCommandArgumentsException("Bad command arguments to the alignment command: " + queryString, nfe);
                        }
                    }
                    if (!"cols".equals(key)) continue;
                    String[] colParts = queryString.split("-");
                    if (colParts.length != 2) {
                        throw new BadCommandArgumentsException("Bad command arguments to the alignment command: " + queryString);
                    }
                    try {
                        colStart = new Integer(colParts[0]);
                        colEnd = new Integer(colParts[1]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new BadCommandArgumentsException("Bad command arguments to the alignment command: " + queryString, nfe);
                    }
                }
                if (query == null) {
                    throw new BadCommandArgumentsException("Bad command arguments - missing the query argument of the command alignment: " + queryString);
                }
                this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dsnConfig.getCapabilities());
                XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
                BufferedWriter out = null;
                DasAlignment alignment = ((AlignmentDataSource)((Object)dsnConfig.getDataSource())).getAlignment(query, subjects, subjectcoordsys, rowStart, rowEnd, colStart, colEnd);
                try {
                    out = this.getResponseWriter(request, response);
                    serializer.setOutput((Writer)out);
                    serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
                    serializer.startDocument(null, Boolean.valueOf(false));
                    serializer.text("\n");
                    alignment.serialize(DAS_XML_NAMESPACE, serializer);
                    serializer.flush();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        } else {
            throw new UnimplementedFeatureException("An attempt to request structure information from a non-structure server has been detected.");
        }
    }

    public void otherCommand(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dataSourceConfig, String command, String queryString) throws BadCommandException {
        try {
            if (!(dataSourceConfig.getDataSource() instanceof CommandExtender)) {
                throw new BadCommandException("The command is not recognised.");
            }
            ((CommandExtender)((Object)dataSourceConfig.getDataSource())).executeOtherCommand(request, response, dataSourceConfig, command, queryString);
        }
        catch (DataSourceException e) {
            throw new BadCommandException("Data source impossible to recover for extended commands", e);
        }
    }

    public void writebackCreate(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dataSourceConfig) throws WritebackException {
        MyDasParser parser = new MyDasParser(PULL_PARSER_FACTORY);
        DasAnnotatedSegment segment = parser.parse2MyDasModel(request.getParameter("_content"));
        try {
            DasAnnotatedSegment segmentRes = ((WritebackDataSource)((Object)dataSourceConfig.getDataSource())).create(segment);
            this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dataSourceConfig.getCapabilities());
            this.serialize(request, response, dataSourceConfig, segmentRes);
        }
        catch (DataSourceException e) {
            throw new WritebackException("ERROR creating the feature", e);
        }
        catch (IllegalArgumentException e) {
            throw new WritebackException("ERROR creating the XML response", e);
        }
        catch (IllegalStateException e) {
            throw new WritebackException("ERROR creating the XML response", e);
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("ERROR creating the XML response", e);
        }
        catch (IOException e) {
            throw new WritebackException("ERROR creating the XML response", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dataSourceConfig, DasAnnotatedSegment segment) throws IllegalArgumentException, IllegalStateException, DataSourceException, XmlPullParserException, IOException {
        if (dataSourceConfig.getDataSource() instanceof WritebackDataSource) {
            if (PULL_PARSER_FACTORY == null) {
                try {
                    PULL_PARSER_FACTORY = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
                    PULL_PARSER_FACTORY.setNamespaceAware(true);
                }
                catch (XmlPullParserException xppe) {
                    logger.error((Object)"Fatal Exception thrown at initialisation.  Cannot initialise the PullParserFactory required to allow generation of the DAS XML.", (Throwable)xppe);
                    throw new IllegalStateException("Fatal Exception thrown at initialisation.  Cannot initialise the PullParserFactory required to allow generation of the DAS XML.", xppe);
                }
            }
            ArrayList<FoundFeaturesReporter> segmentReporterLists = new ArrayList<FoundFeaturesReporter>();
            segmentReporterLists.add(new FoundFeaturesReporter(segment));
            XmlSerializer serializer = PULL_PARSER_FACTORY.newSerializer();
            BufferedWriter out = null;
            try {
                out = this.getResponseWriter(request, response);
                serializer.setOutput((Writer)out);
                serializer.setProperty(INDENTATION_PROPERTY, (Object)INDENTATION_PROPERTY_VALUE);
                serializer.startDocument(null, Boolean.valueOf(false));
                serializer.text("\n");
                if (DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getFeaturesXSLT() != null) {
                    serializer.processingInstruction(DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getFeaturesXSLT());
                    serializer.text("\n");
                }
                serializer.startTag(DAS_XML_NAMESPACE, "DASGFF");
                serializer.startTag(DAS_XML_NAMESPACE, "GFF");
                serializer.attribute(DAS_XML_NAMESPACE, "href", this.buildRequestHref(request));
                for (SegmentReporter segmentReporter : segmentReporterLists) {
                    if (segmentReporter instanceof UnknownSegmentReporter) {
                        ((UnknownSegmentReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer, false);
                        continue;
                    }
                    if (segmentReporter instanceof UnknownFeatureSegmentReporter) {
                        ((UnknownFeatureSegmentReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer);
                        continue;
                    }
                    ((FoundFeaturesReporter)segmentReporter).serialize(DAS_XML_NAMESPACE, serializer, new DasFeatureRequestFilter(), true, true, dataSourceConfig.isUseFeatureIdForFeatureLabel());
                }
                serializer.endTag(DAS_XML_NAMESPACE, "GFF");
                serializer.endTag(DAS_XML_NAMESPACE, "DASGFF");
                serializer.flush();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public void writebackDelete(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dataSourceConfig) throws WritebackException {
        Map parameters = request.getParameterMap();
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        String featureid = null;
        String segmentid = null;
        for (String key : parameters.keySet()) {
            if (key.equals("featureid")) {
                featureid = ((String[])parameters.get(key))[0];
                continue;
            }
            if (key.equals("segmentid")) {
                segmentid = ((String[])parameters.get(key))[0];
                continue;
            }
            parameters2.put(key, ((String[])parameters.get(key))[0]);
        }
        try {
            DasAnnotatedSegment segmentRes = ((WritebackDataSource)((Object)dataSourceConfig.getDataSource())).delete(segmentid, featureid, parameters2);
            this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dataSourceConfig.getCapabilities());
            this.serialize(request, response, dataSourceConfig, segmentRes);
        }
        catch (DataSourceException e) {
            throw new WritebackException("ERROR deleting the feature", e);
        }
        catch (IllegalArgumentException e) {
            throw new WritebackException("ERROR creating the XML response for the deletion", e);
        }
        catch (IllegalStateException e) {
            throw new WritebackException("ERROR creating the XML response for the deletion", e);
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("ERROR creating the XML response for the deletion", e);
        }
        catch (IOException e) {
            throw new WritebackException("ERROR creating the XML response for the deletion", e);
        }
    }

    public void writebackUpdate(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dataSourceConfig) throws WritebackException {
        MyDasParser parser = new MyDasParser(PULL_PARSER_FACTORY);
        String content = "";
        String temp = "";
        try {
            BufferedReader reader = request.getReader();
            while ((temp = reader.readLine()) != null) {
                content = content + temp;
            }
        }
        catch (IOException e) {
            throw new WritebackException("ERROR reading the PUT content", e);
        }
        DasAnnotatedSegment segment = parser.parse2MyDasModel(content);
        try {
            DasAnnotatedSegment segmentRes = ((WritebackDataSource)((Object)dataSourceConfig.getDataSource())).update(segment);
            this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dataSourceConfig.getCapabilities());
            this.serialize(request, response, dataSourceConfig, segmentRes);
        }
        catch (DataSourceException e) {
            throw new WritebackException("ERROR updating the feature", e);
        }
        catch (IllegalArgumentException e) {
            throw new WritebackException("ERROR creating the XML response for the update", e);
        }
        catch (IllegalStateException e) {
            throw new WritebackException("ERROR updating the XML response for the update", e);
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("ERROR updating the XML response for the update", e);
        }
        catch (IOException e) {
            throw new WritebackException("ERROR updating the XML response for the update", e);
        }
    }

    public void writebackHistorical(HttpServletRequest request, HttpServletResponse response, DataSourceConfiguration dataSourceConfig) throws WritebackException {
        String featureId = request.getParameter("feature");
        try {
            DasAnnotatedSegment segmentRes = ((WritebackDataSource)((Object)dataSourceConfig.getDataSource())).history(featureId);
            this.writeHeader(request, response, XDasStatus.STATUS_200_OK, true, dataSourceConfig.getCapabilities());
            this.serialize(request, response, dataSourceConfig, segmentRes);
        }
        catch (DataSourceException e) {
            throw new WritebackException("ERROR updating the feature", e);
        }
        catch (IllegalArgumentException e) {
            throw new WritebackException("ERROR creating the XML response for the update", e);
        }
        catch (IllegalStateException e) {
            throw new WritebackException("ERROR updating the XML response for the update", e);
        }
        catch (XmlPullParserException e) {
            throw new WritebackException("ERROR updating the XML response for the update", e);
        }
        catch (IOException e) {
            throw new WritebackException("ERROR updating the XML response for the update", e);
        }
    }

    void indexerCommand(HttpServletRequest request, HttpServletResponse response) throws IOException, SearcherException {
        if (DATA_SOURCE_MANAGER.getServerConfiguration() == null) {
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            logger.error((Object)"A request has been made to the das server, however initialisation failed - possibly the mydasserverconfig.xml file was not found.");
            return;
        }
        Map<String, PropertyType> properties = DATA_SOURCE_MANAGER.getServerConfiguration().getGlobalConfiguration().getGlobalParameters();
        if (properties.get("keyphrase") == null) {
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            logger.error((Object)"The indexer keyphrase is empty in the config file");
            return;
        }
        if (properties.get("indexerpath") == null || properties.get("indexerpath").getValue().trim().equals("")) {
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            logger.error((Object)"The indexer path is empty in the config file");
            return;
        }
        String keyphrase = request.getParameter("keyphrase");
        if (!properties.get("keyphrase").getValue().equals(keyphrase)) {
            this.writeHeader(request, response, XDasStatus.STATUS_500_SERVER_ERROR, false, null);
            logger.error((Object)"The indexer keyphrase does not match with the one in the Config file");
            return;
        }
        Indexer indexer = new Indexer(properties.get("indexerpath").getValue(), DATA_SOURCE_MANAGER.getServerConfiguration());
        indexer.generateIndexes();
    }

    private Collection<DasAnnotatedSegment> merge(Collection<DasAnnotatedSegment> a, Collection<DasAnnotatedSegment> b, int type) throws DataSourceException {
        ArrayList<DasAnnotatedSegment> merged = new ArrayList<DasAnnotatedSegment>();
        switch (type) {
            case 1: {
                for (DasAnnotatedSegment segA : a) {
                    for (DasAnnotatedSegment segB : b) {
                        if (!segA.getSegmentId().equals(segB.getSegmentId())) continue;
                        merged.add(this.merge(segA, segB, type));
                    }
                }
                break;
            }
            case 2: {
                ArrayList<String> idsAdded = new ArrayList<String>();
                for (DasAnnotatedSegment segA : a) {
                    boolean added = false;
                    for (DasAnnotatedSegment segB : b) {
                        if (!segA.getSegmentId().equals(segB.getSegmentId())) continue;
                        merged.add(this.merge(segA, segB, type));
                        idsAdded.add(segA.getSegmentId());
                        added = true;
                    }
                    if (added) continue;
                    merged.add(segA);
                }
                for (DasAnnotatedSegment segB : b) {
                    if (idsAdded.contains(segB.getSegmentId())) continue;
                    merged.add(segB);
                }
                break;
            }
        }
        return merged;
    }

    private DasAnnotatedSegment merge(DasAnnotatedSegment a, DasAnnotatedSegment b, int type) throws DataSourceException {
        DasAnnotatedSegment merged;
        if (!a.getSegmentId().equals(b.getSegmentId())) {
            throw new DataSourceException("trying to merge two segments with different id");
        }
        if (a.getStartCoordinate() != null && b.getStartCoordinate() != null && a.getStopCoordinate() != null && b.getStopCoordinate() != null) {
            int start = a.getStartCoordinate();
            int stop = a.getStopCoordinate();
            if (start > b.getStartCoordinate()) {
                start = b.getStartCoordinate();
            }
            if (stop < b.getStopCoordinate()) {
                stop = b.getStopCoordinate();
            }
            merged = new DasAnnotatedSegment(a.getSegmentId(), start, stop, a.getVersion(), a.getSegmentLabel(), new ArrayList<DasFeature>());
        } else {
            merged = new DasAnnotatedSegment(a.getSegmentId(), null, null, a.getVersion(), a.getSegmentLabel(), new ArrayList<DasFeature>());
        }
        switch (type) {
            case 1: {
                for (DasFeature fa : a.getFeatures()) {
                    for (DasFeature fb : b.getFeatures()) {
                        if (!fa.getFeatureId().equals(fb.getFeatureId())) continue;
                        merged.getFeatures().add(fa);
                    }
                }
                break;
            }
            case 2: {
                for (DasFeature fa : a.getFeatures()) {
                    merged.getFeatures().add(fa);
                }
                for (DasFeature fb : b.getFeatures()) {
                    if (this.containsFeature(a.getFeatures(), fb)) continue;
                    merged.getFeatures().add(fb);
                }
                break;
            }
        }
        return merged;
    }

    private boolean containsFeature(Collection<DasFeature> features, DasFeature feature) {
        for (DasFeature f : features) {
            if (!f.getFeatureId().equals(feature.getFeatureId())) continue;
            return true;
        }
        return false;
    }

    static {
        VALID_LINK_COMMAND_FIELDS.add("category");
        VALID_LINK_COMMAND_FIELDS.add("feature");
        VALID_LINK_COMMAND_FIELDS.add("method");
        VALID_LINK_COMMAND_FIELDS.add("target");
        VALID_LINK_COMMAND_FIELDS.add("type");
    }
}

