/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.mydas.configuration.DataSourceConfiguration;
import uk.ac.ebi.mydas.configuration.GlobalConfiguration;

public class ServerConfiguration {
    private List<String> liveDsnNames = null;
    private final GlobalConfiguration globalConfiguration;
    private final Map<String, DataSourceConfiguration> dataSourceConfigMap;

    public ServerConfiguration(GlobalConfiguration globalConfiguration, Map<String, DataSourceConfiguration> dataSourceConfigList) {
        this.globalConfiguration = globalConfiguration;
        this.dataSourceConfigMap = dataSourceConfigList;
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public Map<String, DataSourceConfiguration> getDataSourceConfigMap() {
        return this.dataSourceConfigMap == null ? Collections.emptyMap() : this.dataSourceConfigMap;
    }

    public DataSourceConfiguration getDataSourceConfig(String dsnName) {
        return this.dataSourceConfigMap.get(dsnName);
    }

    public List<String> getDsnNames() {
        if (this.liveDsnNames == null) {
            this.liveDsnNames = new ArrayList<String>(this.dataSourceConfigMap.size());
            for (String dsnName : this.dataSourceConfigMap.keySet()) {
                if (!this.dataSourceConfigMap.get(dsnName).isOK()) continue;
                this.liveDsnNames.add(dsnName);
            }
        }
        return this.liveDsnNames;
    }
}

