/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import uk.ac.ebi.mydas.configuration.Mydasserver;
import uk.ac.ebi.mydas.configuration.PropertyType;
import uk.ac.ebi.mydas.datasource.AnnotationDataSource;
import uk.ac.ebi.mydas.exceptions.DataSourceException;

public class DataSourceConfiguration {
    private static final Logger logger = Logger.getLogger(DataSourceConfiguration.class);
    private AnnotationDataSource dataSource;
    private boolean datasourceOK;
    private final Mydasserver.Datasources.Datasource config;
    private int versionPosition;

    public DataSourceConfiguration(Mydasserver.Datasources.Datasource config, int versionPosition) {
        this.config = config;
        this.versionPosition = versionPosition;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("New DataSourceConfiguration instantiated: \n" + this.toString()));
        }
    }

    public String getId() {
        return this.config.getVersion().get(this.versionPosition).getUri();
    }

    public String getName() {
        return this.config.getTitle();
    }

    public String getVersion() {
        return this.config.getVersion().get(this.versionPosition).getCreated().toString();
    }

    public String getMapmaster() {
        return this.config.getMapmaster();
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public URL getDescriptionHref() {
        try {
            return new URL(this.config.getDocHref());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Integer getMaxEntryPoints() {
        return this.config.getMaxEntryPoints();
    }

    public String getStyleSheet() {
        return this.config.getStylesheet();
    }

    public Map<String, PropertyType> getDataSourceProperties() {
        HashMap<String, PropertyType> props = new HashMap<String, PropertyType>();
        for (PropertyType pt : this.config.getVersion().get(this.versionPosition).getProperty()) {
            props.put(pt.key, pt);
        }
        return props;
    }

    public boolean isDnaCommandEnabled() {
        return this.config.getDnaCommandEnabled().value;
    }

    public boolean isUseFeatureIdForFeatureLabel() {
        return this.config.getUseFeatureIdForFeatureLabel().value;
    }

    public boolean isIncludeTypesWithZeroCount() {
        return this.config.getIncludeTypesWithZeroCount().value;
    }

    public boolean loadDataSource() throws DataSourceException {
        this.datasourceOK = false;
        String className = this.config.getVersion().get(this.versionPosition).getClazz();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.dataSource = (AnnotationDataSource)classLoader.loadClass(className).newInstance();
            if (this.dataSource != null) {
                this.datasourceOK = true;
            }
        }
        catch (ClassNotFoundException e) {
            this.datasourceOK = false;
            logger.error((Object)("ClassNotFoundException thrown when attempting to load data source " + className), (Throwable)e);
            throw new DataSourceException("ClassNotFoundException thrown when attempting to instantiate a '" + className + "'.  Please check that the configuration XML file and the classpath are correct.", e);
        }
        catch (IllegalAccessException e) {
            this.datasourceOK = false;
            logger.error((Object)("IllegalAccessException thrown when attempting to load data source " + className), (Throwable)e);
            throw new DataSourceException("IllegalAccessException thrown when attempting to instantiate a '" + className + "'.", e);
        }
        catch (InstantiationException e) {
            this.datasourceOK = false;
            logger.error((Object)("InstantiationException thrown when attempting to load data source " + className), (Throwable)e);
            throw new DataSourceException("InstantiationException thrown when attempting to instantiate a '" + className + "'.", e);
        }
        return this.datasourceOK;
    }

    public AnnotationDataSource getDataSource() throws DataSourceException {
        if (!this.datasourceOK) {
            throw new DataSourceException("An attempt has been made to access an AnnotationDataSource that has not been successfully loaded.");
        }
        return this.dataSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceConfiguration that = (DataSourceConfiguration)o;
        return that.getConfig().equals(this.getConfig());
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getVersion() != null ? this.getVersion().hashCode() : 0);
        result = 31 * result + (this.getMapmaster() != null ? this.getMapmaster().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + (this.getDescriptionHref() != null ? this.getDescriptionHref().hashCode() : 0);
        result = 31 * result + (this.getStyleSheet() != null ? this.getStyleSheet().hashCode() : 0);
        result = 31 * result + (this.getDataSourceProperties() != null ? ((Object)this.getDataSourceProperties()).hashCode() : 0);
        return result;
    }

    public boolean isOK() {
        return this.datasourceOK;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DataSourceConfiguration: id: '");
        buf.append(this.getId() == null ? "null" : this.getId()).append("' name: '").append(this.getName() == null ? "null" : this.getName()).append("' version: '").append(this.getVersion() == null ? "null" : this.getVersion()).append("' description: '").append(this.getDescription() == null ? "null" : this.getDescription()).append("' dna command enabled :'").append(this.isDnaCommandEnabled()).append("' use feature id for feature label: '").append(this.isUseFeatureIdForFeatureLabel()).append("' include types with zero count: '").append(this.isIncludeTypesWithZeroCount());
        return buf.toString();
    }

    public Mydasserver.Datasources.Datasource getConfig() {
        return this.config;
    }

    public String getCapabilities() {
        String capabilities = "";
        for (Mydasserver.Datasources.Datasource.Version.Capability cap : this.config.getVersion().get(this.versionPosition).getCapability()) {
            try {
                String[] caps = cap.getType().split(":");
                capabilities = capabilities + " " + caps[1] + "/1.0;";
            }
            catch (Exception e) {}
        }
        return capabilities.substring(0, capabilities.length() - 1);
    }
}

