/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.mydas.configuration;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import uk.ac.ebi.mydas.configuration.DataSourceConfiguration;
import uk.ac.ebi.mydas.configuration.GlobalConfiguration;
import uk.ac.ebi.mydas.configuration.Mydasserver;
import uk.ac.ebi.mydas.configuration.PropertyType;
import uk.ac.ebi.mydas.configuration.ServerConfiguration;
import uk.ac.ebi.mydas.exceptions.ConfigurationException;

public class ConfigurationManager {
    private static final Logger logger = Logger.getLogger(ConfigurationManager.class);
    private Mydasserver configurationDocument;

    public void unmarshal(InputStream inputStream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"uk.ac.ebi.mydas.configuration");
        Unmarshaller u = jc.createUnmarshaller();
        this.configurationDocument = (Mydasserver)u.unmarshal(inputStream);
    }

    public ServerConfiguration getServerConfiguration() throws ConfigurationException {
        GlobalConfiguration globalConfig = this.getGlobalConfiguration();
        Map<String, DataSourceConfiguration> dataSourceConfigMap = this.getDataSourceConfigMap();
        ServerConfiguration serverConfig = new ServerConfiguration(globalConfig, dataSourceConfigMap);
        return serverConfig;
    }

    private GlobalConfiguration getGlobalConfiguration() {
        String baseURL = this.configurationDocument.getGlobal().getBaseurl().getValue();
        String defaultStylesheet = this.configurationDocument.getGlobal().getDefaultStylesheet();
        boolean gzipped = this.configurationDocument.getGlobal().getGzipped() != null ? this.configurationDocument.getGlobal().getGzipped().value : false;
        boolean slashDasToDsn = this.configurationDocument.getGlobal().getSlashDasPointsToDsn() != null ? this.configurationDocument.getGlobal().getSlashDasPointsToDsn().value : false;
        String dsnXSLT = this.configurationDocument.getGlobal().getDsnXsltUrl();
        String sourcesXSLT = this.configurationDocument.getGlobal().getSourcesXsltUrl();
        String dnaXSLT = this.configurationDocument.getGlobal().getDnaXsltUrl();
        String entryPointXSLT = this.configurationDocument.getGlobal().getEntryPointsXsltUrl();
        String sequenceXSLT = this.configurationDocument.getGlobal().getSequenceXsltUrl();
        String featuresXSLT = this.configurationDocument.getGlobal().getFeaturesXsltUrl();
        String typesXSLT = this.configurationDocument.getGlobal().getTypesXsltUrl();
        HashMap<String, PropertyType> globalParameters = new HashMap<String, PropertyType>();
        for (PropertyType property : this.configurationDocument.getGlobal().getProperty()) {
            globalParameters.put(property.key, property);
        }
        return new GlobalConfiguration(baseURL, defaultStylesheet, gzipped, slashDasToDsn, dsnXSLT, sourcesXSLT, dnaXSLT, entryPointXSLT, sequenceXSLT, featuresXSLT, typesXSLT, globalParameters);
    }

    private Map<String, DataSourceConfiguration> getDataSourceConfigMap() throws ConfigurationException {
        HashMap<String, DataSourceConfiguration> dataSourceConfigList = new HashMap<String, DataSourceConfiguration>();
        for (Mydasserver.Datasources.Datasource datasource : this.configurationDocument.getDatasources().getDatasource()) {
            String id = datasource.getUri().toString();
            String name = datasource.getTitle();
            String mapmaster = datasource.getMapmaster();
            String hrefString = datasource.getDocHref();
            try {
                new URL(hrefString);
            }
            catch (MalformedURLException murle) {
                logger.error((Object)("MalformedURLException thrown when attempting to build a URL from : '" + hrefString + "'"));
                throw new ConfigurationException("Please check the XML configuration file.  The URL '" + hrefString + "' that has have given in the /mydasserver/datasources/datasource/@description-href attribute is not valid.", murle);
            }
            String className = datasource.getVersion().get(0).getClazz();
            HashMap<String, PropertyType> dataSourceProperties = new HashMap<String, PropertyType>();
            for (PropertyType property : datasource.getVersion().get(0).getProperty()) {
                dataSourceProperties.put(property.key, property);
            }
            if (className == null) {
                throw new ConfigurationException("Please check your XML configuration file.  No value has been given for one of the /mydasserver/datasources/datasource/class elements.");
            }
            if (id == null) {
                throw new ConfigurationException("Please check your XML configuration file.  No value has been given for one of the mandatory /mydasserver/datasources/datasource/@id attributes.");
            }
            if (name == null) {
                throw new ConfigurationException("Please check your XML configuration file.  No value has been given for one of the mandatory /mydasserver/datasources/datasource/@name attributes.");
            }
            if (mapmaster == null) {
                throw new ConfigurationException("Please check your XML configuration file.  No value has been given for one of the mandatory /mydasserver/datasources/datasource/@mapmaster attributes.");
            }
            for (int i = 0; i < datasource.getVersion().size(); ++i) {
                DataSourceConfiguration dsnConfig = new DataSourceConfiguration(datasource, i);
                dataSourceConfigList.put(dsnConfig.getId(), dsnConfig);
            }
        }
        return dataSourceConfigList;
    }
}

