/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.dassources.utils;

import java.util.List;
import org.biodas.jdas.dassources.Capabilities;
import org.biodas.jdas.exceptions.ValidationException;
import org.biodas.jdas.schema.sources.CAPABILITY;
import org.biodas.jdas.schema.sources.VERSION;

public class VersionAdapter {
    VERSION version;

    public VersionAdapter(VERSION version) {
        this.version = version;
    }

    public String getOriginalDataSourceUri() throws ValidationException {
        return this.getSourceUriFromQueryUri(this.version.getCAPABILITY());
    }

    private String getSourceUriFromQueryUri(List<CAPABILITY> list) throws ValidationException {
        String dasString;
        String queryUri = this.getQueryUriFromCaps(list);
        int dasIndex = queryUri.indexOf(dasString = "/das/");
        if (dasIndex == -1) {
            dasString = "/das1/";
            dasIndex = queryUri.indexOf(dasString);
        }
        if (this.hasBigFileFormat()) {
            return queryUri;
        }
        if (dasIndex == -1) {
            throw new ValidationException("the das source query_uri must contain a /das/ queryUri=" + queryUri);
        }
        String includingDAS = queryUri.substring(0, dasIndex + dasString.length());
        String afterDas = queryUri.substring(dasIndex + dasString.length(), queryUri.length());
        String sourceUri = "";
        sourceUri = afterDas.contains("/") ? includingDAS + afterDas.substring(0, afterDas.indexOf("/")) : includingDAS + afterDas;
        return sourceUri;
    }

    private String getQueryUriFromCaps(List<CAPABILITY> capList) {
        for (CAPABILITY cap : capList) {
            if (cap.getQueryUri() == null || cap.getQueryUri().equals("")) continue;
            return cap.getQueryUri();
        }
        return "";
    }

    public boolean hasBigFileFormat() {
        List<CAPABILITY> caps = this.version.getCAPABILITY();
        for (CAPABILITY cap : caps) {
            if (!Capabilities.isBigFileFormat(cap.getType().substring(5, cap.getType().length()))) continue;
            System.out.println(cap.getType() + "Big file format found");
            return true;
        }
        return false;
    }
}

