/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.creators;

import java.math.BigInteger;
import java.util.List;
import org.biodas.jdas.schema.features.DASGFF;
import org.biodas.jdas.schema.features.FEATURE;
import org.biodas.jdas.schema.features.GFF;
import org.biodas.jdas.schema.features.GROUP;
import org.biodas.jdas.schema.features.METHOD;
import org.biodas.jdas.schema.features.ObjectFactory;
import org.biodas.jdas.schema.features.PARENT;
import org.biodas.jdas.schema.features.PART;
import org.biodas.jdas.schema.features.SEGMENT;
import org.biodas.jdas.schema.features.TYPE;

public class CreateFeatures {
    ObjectFactory factory = new ObjectFactory();

    public PART createPart(String id) {
        PART part = this.factory.createPART();
        part.setId(id);
        return part;
    }

    public PARENT createParent(String id) {
        PARENT parent = this.factory.createPARENT();
        parent.setId(id);
        return parent;
    }

    @Deprecated
    public GROUP createGroup(String id, String label, String type) {
        GROUP group = this.factory.createGROUP();
        group.setId(id);
        group.setLabel(label);
        group.setType(type);
        return group;
    }

    public FEATURE createFeature(String id, String start, String stop, String orientation, String phase, String score, METHOD method, TYPE type) {
        FEATURE feature = this.factory.createFEATURE();
        feature.setId(id);
        feature.setSTART(new BigInteger(start));
        feature.setEND(new BigInteger(stop));
        feature.setMETHOD(method);
        feature.setORIENTATION(orientation);
        feature.setPHASE(phase);
        feature.setSCORE(score);
        feature.setTYPE(type);
        return feature;
    }

    public FEATURE createFeatureWithParentsAndParts(String id, String start, String stop, String orientation, String phase, String score, METHOD method, TYPE type, List<String> parentFeatureIds, List<String> partFeatureIds) {
        FEATURE feature = this.createFeature(id, start, stop, orientation, phase, score, method, type);
        if (parentFeatureIds != null) {
            for (String parentId : parentFeatureIds) {
                feature.getPARENT().add(this.createParent(parentId));
            }
        }
        if (partFeatureIds != null) {
            for (String partId : partFeatureIds) {
                feature.getPART().add(this.createPart(partId));
            }
        }
        return feature;
    }

    public FEATURE createFeatureWithParents(String id, String start, String stop, String orientation, String phase, String score, METHOD method, TYPE type, List<String> parentFeatureIds) {
        FEATURE feature = this.createFeatureWithParentsAndParts(id, start, stop, orientation, phase, score, method, type, parentFeatureIds, null);
        return feature;
    }

    public FEATURE createFeatureWithParts(String id, String start, String stop, String orientation, String phase, String score, METHOD method, TYPE type, List<String> partFeatureIds) {
        FEATURE feature = this.createFeatureWithParentsAndParts(id, start, stop, orientation, phase, score, method, type, null, partFeatureIds);
        return feature;
    }

    @Deprecated
    public FEATURE createFeature(String id, String start, String stop, String orientation, String phase, String score, METHOD method, TYPE type, List<GROUP> groups) {
        FEATURE feature = this.createFeature(id, start, stop, orientation, phase, score, method, type);
        feature.getGROUP().addAll(groups);
        return feature;
    }

    public TYPE createType(String id, String content, String category, String cvId) {
        TYPE type = this.factory.createTYPE();
        type.setContent(content);
        type.setId(id);
        type.setCategory(category);
        type.setCvId(cvId);
        return type;
    }

    public METHOD createMethod(String id, String content, String cvId) {
        METHOD method = this.factory.createMETHOD();
        method.setContent(content);
        method.setId(id);
        method.setCvId(cvId);
        return method;
    }

    public SEGMENT createSegment(String id, String version, String start, String stop, List<FEATURE> features) {
        SEGMENT segment = this.factory.createSEGMENT();
        segment.setId(id);
        segment.setVersion(version);
        segment.setStart(start);
        segment.setStop(stop);
        segment.getFEATURE().addAll(features);
        return segment;
    }

    public DASGFF createDASGFF(List<Object> segments, String href, BigInteger total) {
        DASGFF dasgff = this.factory.createDASGFF();
        GFF gff = this.factory.createGFF();
        gff.setHref(href);
        gff.setTotal(total);
        for (Object segment : segments) {
            gff.getSEGMENTOrERRORSEGMENTOrUNKNOWNSEGMENT().add(segment);
        }
        dasgff.setGFF(gff);
        return dasgff;
    }

    public DASGFF createDASGFF(List<Object> segments, String href) {
        return this.createDASGFF(segments, href, null);
    }
}

