/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.converter;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.FeaturesClient;
import org.biodas.jdas.client.adapters.features.DasGFFAdapter;
import org.biodas.jdas.converter.GroupRange;
import org.biodas.jdas.schema.features.FEATURE;
import org.biodas.jdas.schema.features.GROUP;
import org.biodas.jdas.schema.features.LINK;
import org.biodas.jdas.schema.features.PARENT;
import org.biodas.jdas.schema.features.PART;
import org.biodas.jdas.schema.features.SEGMENT;
import org.biodas.jdas.schema.features.TARGET;

public class SpecFeaturesConverter {
    private static Logger logger = Logger.getLogger(SpecFeaturesConverter.class);
    FeaturesClient fClient;

    public DasGFFAdapter convert15To16(DasGFFAdapter results) {
        return this.convert15To16(results, true);
    }

    public DasGFFAdapter convert15To16(DasGFFAdapter results, boolean removeGroups) {
        List<SEGMENT> segmentsAdapters = this.getSegments(results);
        for (SEGMENT segmentAdapter : segmentsAdapters) {
            List<FEATURE> features = segmentAdapter.getFEATURE();
            HashMap<String, GroupRange> groupMap = new HashMap<String, GroupRange>();
            for (FEATURE feature : features) {
                if (feature.getGROUP() != null) {
                    for (GROUP group : feature.getGROUP()) {
                        PARENT parent = new PARENT();
                        parent.setId(group.getId());
                        feature.getPARENT().add(parent);
                        this.setGroupRange(groupMap, group, feature.getSTART(), feature.getEND(), feature.getId());
                    }
                }
                logger.debug((Object)feature.getGROUP().get(0).getId());
                if (!removeGroups) continue;
                feature.getGROUP().clear();
            }
            for (String groupId : groupMap.keySet()) {
                GroupRange finalGroupRange = (GroupRange)groupMap.get(groupId);
                FEATURE gFeature = new FEATURE();
                gFeature.setId(groupId);
                gFeature.setSTART(finalGroupRange.getStart());
                gFeature.setEND(finalGroupRange.getEnd());
                GROUP group = finalGroupRange.getGroup();
                for (Object obj : group.getNOTEOrLINKOrTARGET()) {
                    if (obj instanceof LINK) {
                        gFeature.getLINK().add((LINK)obj);
                    }
                    if (obj instanceof String) {
                        gFeature.getNOTE().add((String)obj);
                    }
                    if (!(obj instanceof TARGET)) continue;
                    gFeature.getTARGET().add((TARGET)obj);
                }
                for (String partId : finalGroupRange.getParts()) {
                    PART part = new PART();
                    part.setId(partId);
                    gFeature.getPART().add(part);
                }
                segmentAdapter.getFEATURE().add(gFeature);
            }
        }
        return results;
    }

    private void setGroupRange(HashMap<String, GroupRange> groupMap, GROUP group, BigInteger featureStart, BigInteger featureEnd, String featureId) {
        if (group.getId() != null) {
            String groupId = group.getId();
            if (groupMap.containsKey(groupId)) {
                GroupRange groupRange = groupMap.get(groupId);
                logger.debug((Object)("groupid already encountered with start=" + groupRange.getStart() + " end=" + groupRange.getEnd()));
                if (featureStart.compareTo(groupRange.getStart()) == -1) {
                    groupRange.setStart(featureStart);
                }
                if (featureEnd.compareTo(groupRange.getEnd()) == 1) {
                    groupRange.setEnd(featureEnd);
                }
                groupRange.addPart(featureId);
            } else {
                groupMap.put(groupId, new GroupRange(featureStart, featureEnd, group, featureId));
                logger.debug((Object)("adding new range groupid=" + groupId + " start=" + featureStart + " end=" + featureEnd));
            }
        }
    }

    private List<SEGMENT> getSegments(DasGFFAdapter dasGffAdapter) {
        List<SEGMENT> segmentsAdapters = dasGffAdapter.getGFF().getSegments();
        return segmentsAdapters;
    }
}

