/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.SequenceClient;
import org.biodas.jdas.client.adapters.sequence.DasSequenceAdapter;
import org.biodas.jdas.client.threads.ClientMultipleSources;
import org.biodas.jdas.exceptions.DASClientException;

public class SequenceClientMultipleSources
extends ClientMultipleSources {
    private static Logger logger = Logger.getLogger(SequenceClientMultipleSources.class);

    public void fetchData(List<String> sources, final List<String> segments, final Map<String, Map<List<String>, DasSequenceAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        SequenceClient sequenceClient = new SequenceClient();
                        DasSequenceAdapter adapter = sequenceClient.fetchData(source, segments);
                        if (results.get(source) == null) {
                            HashMap<List, DasSequenceAdapter> response = new HashMap<List, DasSequenceAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                    }
                }
            });
        }
        while (!this.queue.isEmpty()) {
            logger.info((Object)("Waiting for " + this.queue.size() + " jobs"));
        }
    }
}

