/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.biodas.jdas.client.threads.DAS_GFFFeatureRetrieve;
import org.biodas.jdas.client.threads.FeatureEvent;
import org.biodas.jdas.client.threads.FeatureListener;
import org.biodas.jdas.dassources.utils.VersionAdapter;
import org.biodas.jdas.exceptions.ValidationException;
import org.biodas.jdas.schema.schema1_6.features.DASGFF;
import org.biodas.jdas.schema.sources.VERSION;

public class FeatureThread
implements Runnable {
    public static int MAX_COME_BACK_ITERATIONS = 5;
    public static int MAX_NR_FEATURES = 300;
    static Logger logger = Logger.getLogger("org.biojava.FeatureThread");
    VERSION dasSource;
    String ac;
    List<FeatureListener> featureListeners;
    Thread thread;

    public FeatureThread(String segment, VERSION dasVersion) {
        this.dasSource = dasVersion;
        this.ac = segment;
        this.featureListeners = new ArrayList<FeatureListener>();
    }

    public void addFeatureListener(FeatureListener li) {
        this.featureListeners.add(li);
    }

    public void clearFeatureListeners() {
        this.featureListeners.clear();
    }

    public synchronized void stop() {
        this.thread = null;
        this.notify();
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        if (this.thread == me) {
            VersionAdapter adapter = new VersionAdapter(this.dasSource);
            String url = null;
            try {
                url = adapter.getOriginalDataSourceUri();
            }
            catch (ValidationException e1) {
                e1.printStackTrace();
            }
            String queryString = url + "features?segment=" + this.ac;
            logger.info("FeatureThread requesting features from " + queryString);
            DAS_GFFFeatureRetrieve ftmp = new DAS_GFFFeatureRetrieve(queryString);
            int comeBackLater = ftmp.getComeBackLater();
            int securityCounter = 0;
            while (this.thread == me && comeBackLater > 0) {
                if (++securityCounter >= MAX_COME_BACK_ITERATIONS) {
                    comeBackLater = -1;
                    break;
                }
                this.notifyComeBackLater(comeBackLater);
                try {
                    this.wait(comeBackLater);
                }
                catch (InterruptedException e) {
                    comeBackLater = -1;
                    break;
                }
                ftmp.reload();
                comeBackLater = ftmp.getComeBackLater();
            }
            if (this.thread == me) {
                DASGFF features = ftmp.get_features();
                this.notifyFeatureListeners(features, this.dasSource);
            }
        }
        this.thread = null;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void notifyFeatureListeners(DASGFF feats, VERSION sourceVersion) {
        logger.finest("FeatureThread found " + feats.getGFF().getSEGMENTOrERRORSEGMENTOrUNKNOWNSEGMENT().size() + " segments returned");
        FeatureEvent fevent = new FeatureEvent(feats, sourceVersion);
        for (FeatureListener fi : this.featureListeners) {
            fi.newFeatures(fevent);
        }
    }

    private void notifyComeBackLater(int comeBackLater) {
        FeatureEvent event = new FeatureEvent(null, this.dasSource);
        event.setComeBackLater(comeBackLater);
        for (FeatureListener fi : this.featureListeners) {
            fi.comeBackLater(event);
        }
    }
}

