/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.adapters.features;

import java.util.ArrayList;
import java.util.List;
import org.biodas.jdas.schema.features.DASGFF;
import org.biodas.jdas.schema.features.ERRORSEGMENT;
import org.biodas.jdas.schema.features.GFF;
import org.biodas.jdas.schema.features.SEGMENT;
import org.biodas.jdas.schema.features.UNKNOWNFEATURE;
import org.biodas.jdas.schema.features.UNKNOWNSEGMENT;
import org.codehaus.jackson.annotate.JsonProperty;

public class DasGFFAdapter
extends DASGFF {
    @JsonProperty(value="GFF")
    GFFAdapter gff;
    private DASGFF dasgff;

    public DasGFFAdapter() {
        this.gff.init();
    }

    public DasGFFAdapter(DASGFF dasgff) {
        this.dasgff = dasgff;
        this.gff = new GFFAdapter(dasgff.getGFF());
    }

    @Override
    public GFFAdapter getGFF() {
        return this.gff;
    }

    public void setGFF(GFFAdapter gff) {
        this.gff = gff;
    }

    public DASGFF getDasGff() {
        return this.dasgff;
    }

    public class GFFAdapter
    extends GFF {
        private List<SEGMENT> segments;
        private List<ERRORSEGMENT> errorSegments;
        private List<UNKNOWNSEGMENT> unknownSegments;
        private List<UNKNOWNFEATURE> unknownFeatures;

        public GFFAdapter() {
            this.init();
        }

        public GFFAdapter(GFF gff) {
            this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT = gff.getSEGMENTOrERRORSEGMENTOrUNKNOWNSEGMENT();
            this.href = gff.getHref();
            this.version = gff.getVersion();
            this.total = gff.getTotal();
            this.init();
        }

        private void init() {
            this.segments = new ArrayList<SEGMENT>();
            this.errorSegments = new ArrayList<ERRORSEGMENT>();
            this.unknownSegments = new ArrayList<UNKNOWNSEGMENT>();
            this.unknownFeatures = new ArrayList<UNKNOWNFEATURE>();
            for (Object segment : this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT) {
                if (segment instanceof SEGMENT) {
                    this.segments.add((SEGMENT)segment);
                    continue;
                }
                if (segment instanceof UNKNOWNSEGMENT) {
                    this.unknownSegments.add((UNKNOWNSEGMENT)segment);
                    continue;
                }
                if (segment instanceof UNKNOWNFEATURE) {
                    this.unknownFeatures.add((UNKNOWNFEATURE)segment);
                    continue;
                }
                if (!(segment instanceof ERRORSEGMENT)) continue;
                this.errorSegments.add((ERRORSEGMENT)segment);
            }
            this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT = null;
        }

        public List<SEGMENT> getSegments() {
            return this.segments;
        }

        public List<ERRORSEGMENT> getErrorSegments() {
            return this.errorSegments;
        }

        public List<UNKNOWNSEGMENT> getUnknownSegments() {
            return this.unknownSegments;
        }

        public List<UNKNOWNFEATURE> getUnknownFeatures() {
            return this.unknownFeatures;
        }

        @Override
        @Deprecated
        public List<Object> getSEGMENTOrERRORSEGMENTOrUNKNOWNSEGMENT() {
            if (this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT != null) {
                this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT = null;
            }
            return this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT;
        }
    }
}

