/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.biodas.jdas.client.NoDtdJaxbParser;
import org.biodas.jdas.client.adapters.types.DasTypesAdapter;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.schema.types.DASTYPES;

public class TypesClient {
    private DasTypesAdapter fetchData(String serverURL, String arguments) throws DASClientException {
        try {
            String url = !serverURL.endsWith("/") ? serverURL + "/types" + arguments : serverURL + "types" + arguments;
            NoDtdJaxbParser parser = new NoDtdJaxbParser();
            DASTYPES dastypes = (DASTYPES)parser.parseXmlUrl(url, "org.biodas.jdas.schema.types");
            return new DasTypesAdapter(dastypes);
        }
        catch (JAXBException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
    }

    public DasTypesAdapter fetchData(String serverURL) throws DASClientException {
        return this.fetchData(serverURL, "");
    }

    public DasTypesAdapter fetchData(String serverURL, List<String> segments, List<String> types) throws DASClientException {
        String arguments = "";
        String segmentArguments = null;
        String typeArguments = null;
        if (segments != null && segments.size() != 0) {
            segmentArguments = "";
            for (String segment : segments) {
                segmentArguments = segmentArguments + ";segment=" + segment;
            }
            segmentArguments = segmentArguments.substring(1);
        }
        if (types != null && types.size() != 0) {
            typeArguments = "";
            for (String type : types) {
                typeArguments = typeArguments + ";type=" + type;
            }
            typeArguments = typeArguments.substring(1);
        }
        if (segmentArguments != null && typeArguments != null) {
            arguments = arguments + "?" + segmentArguments + ";" + typeArguments;
        } else if (segmentArguments != null && typeArguments == null) {
            arguments = arguments + "?" + segmentArguments;
        } else if (segmentArguments == null && typeArguments != null) {
            arguments = arguments + "?" + typeArguments;
        }
        return this.fetchData(serverURL, arguments);
    }
}

