/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.tools.gids.convertor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.Repository;
import org.molgenis.data.Writable;
import org.molgenis.data.WritableFactory;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.LowerCaseProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.MapEntity;
import org.molgenis.tools.gids.convertor.MakeEntityNameAndIdentifier;

public class SampleConverter {
    private final Set<String> listOfDoubleSamples = new HashSet();
    private String OUTPUTDIR = null;
    private String PROJECT = null;
    private final String IDENTIFIER = "id_sample";
    private List<String> featureColNames = null;
    MakeEntityNameAndIdentifier mkObsProtocol = null;
    private final HashMap<String, HashSet<String>> hashMapCategories = new HashMap();
    MakeEntityNameAndIdentifier mkObsFeature = null;
    List<MakeEntityNameAndIdentifier> mkObsProtocollist = new ArrayList();
    List<MakeEntityNameAndIdentifier> mkObsFeaturelist = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(InputStream in, OutputStream out, String outputdir, String projectName) throws IOException, MolgenisInvalidFormatException {
        this.OUTPUTDIR = outputdir;
        this.PROJECT = projectName;
        ExcelRepositoryCollection repositorySource = new ExcelRepositoryCollection(projectName, in, new CellProcessor[]{new TrimProcessor(false, true)});
        CsvWriter csvWriter = null;
        ArrayList<String> listOfEntity = new ArrayList<String>();
        listOfEntity.add("dataset");
        listOfEntity.add("protocol");
        listOfEntity.add("observableFeature");
        listOfEntity.add("dataset_" + this.PROJECT.toLowerCase().trim());
        try {
            for (String name : repositorySource.getEntityNames()) {
                Repository repo = repositorySource.getRepository(name);
                this.featureColNames = new ArrayList();
                for (AttributeMetaData attr : repo.getEntityMetaData().getAttributes()) {
                    String colName = attr.getName();
                    if (colName.equals("id_sample")) {
                        this.featureColNames.add(0, colName);
                        continue;
                    }
                    this.featureColNames.add(colName);
                }
                csvWriter = new CsvWriter((Writer)new OutputStreamWriter(out, Charset.forName("UTF-8")), this.featureColNames);
                for (Entity entity : repo) {
                    if (entity.getString("id_sample") != null && !entity.getString("id_sample").isEmpty()) {
                        String sampleId = entity.getString("id_sample");
                        if (this.checkIfDouble(sampleId)) continue;
                        this.createCategoryList(entity, sampleId);
                        csvWriter.add(entity);
                        continue;
                    }
                    MapEntity entOut = new MapEntity();
                    for (String featureColName : this.featureColNames) {
                        if (featureColName.equals("id_sample")) {
                            entOut.set(featureColName, (Object)this.emptySample());
                            continue;
                        }
                        entOut.set(featureColName, (Object)entity.getString(featureColName));
                    }
                    csvWriter.add((Entity)entOut);
                }
            }
            this.makeProtocolList(this.featureColNames);
            if (this.featureColNames != null) {
                this.makeFeaturesList();
            }
            this.mkmetadataExcelFile(listOfEntity);
            PrintWriter printCategories = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.OUTPUTDIR + "/categories.txt")), Charset.forName("UTF-8")));
            for (Map.Entry entry : this.hashMapCategories.entrySet()) {
                if (((HashSet)entry.getValue()).size() <= 1 || ((HashSet)entry.getValue()).size() >= 100) continue;
                printCategories.append((String)entry.getKey() + "^");
                for (String e : (HashSet)entry.getValue()) {
                    printCategories.append(e + "^");
                }
                printCategories.append("\n");
            }
            printCategories.close();
        }
        finally {
            try {
                csvWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void createCategoryList(Entity entity, String sampleId) {
        for (String feature : this.featureColNames) {
            HashSet hashset = (HashSet)this.hashMapCategories.get(feature);
            if (this.hashMapCategories.get(feature) == null) {
                this.hashMapCategories.put(feature, new HashSet());
                continue;
            }
            hashset.add(entity.getString(feature));
            this.hashMapCategories.put(feature, hashset);
        }
    }

    public boolean checkIfDouble(String sample) {
        if (!this.listOfDoubleSamples.contains(sample)) {
            this.listOfDoubleSamples.add(sample);
            return false;
        }
        return true;
    }

    public String emptySample() {
        String sample = "unknown";
        return sample;
    }

    private void makeProtocolList(List<String> listOfFeatures) {
        String prot = "protocol_" + this.PROJECT;
        StringBuilder build = new StringBuilder();
        for (String e : listOfFeatures) {
            build.append(e + ",");
        }
        String features = build.substring(0, build.length() - 1);
        this.mkObsProtocol = new MakeEntityNameAndIdentifier(prot, prot, features);
        this.mkObsProtocollist.add(this.mkObsProtocol);
    }

    private void makeFeaturesList() {
        for (String featureColName : this.featureColNames) {
            this.mkObsFeature = new MakeEntityNameAndIdentifier(featureColName, featureColName, null);
            this.mkObsFeaturelist.add(this.mkObsFeature);
        }
    }

    public void mkMetadataFileProtocol(WritableFactory writableFactoryMD, String sheetName) throws IOException {
        Writable esw = writableFactoryMD.createWritable("protocol", Arrays.asList("identifier", "name", "features_identifier"));
        for (MakeEntityNameAndIdentifier i : this.mkObsProtocollist) {
            MapEntity kvt = new MapEntity();
            kvt.set("identifier", (Object)i.getIdentifier());
            kvt.set("name", (Object)i.getName());
            kvt.set("features_identifier", (Object)i.getFeatures_Identifier());
            esw.add((Entity)kvt);
        }
    }

    public void mkMetadataFileObservableFeature(WritableFactory writableFactoryMD, String sheetName) throws IOException {
        Writable esw = writableFactoryMD.createWritable("observableFeature", Arrays.asList("identifier", "name"));
        for (MakeEntityNameAndIdentifier m : this.mkObsFeaturelist) {
            MapEntity kvt = new MapEntity();
            kvt.set("identifier", (Object)m.getIdentifier());
            kvt.set("name", (Object)m.getName());
            esw.add((Entity)kvt);
        }
    }

    public void mkMetadataFileDataSet(WritableFactory writableFactoryMD, String sheetName) throws IOException {
        Writable esw = writableFactoryMD.createWritable(sheetName, Arrays.asList("identifier", "name", "protocolused_identifier"));
        MapEntity kvt = new MapEntity();
        kvt.set("protocolused_identifier", (Object)("protocol_" + this.PROJECT));
        kvt.set("identifier", (Object)this.PROJECT.toLowerCase());
        kvt.set("name", (Object)this.PROJECT.toLowerCase());
        esw.add((Entity)kvt);
    }

    public void mkmetadataExcelFile(ArrayList<String> listOfEntity) throws IOException {
        FileOutputStream osMD = new FileOutputStream(this.OUTPUTDIR + this.PROJECT + "_metadata.xls");
        ExcelWriter excelWriterMD = new ExcelWriter((OutputStream)osMD, ExcelWriter.FileFormat.XLS);
        excelWriterMD.addCellProcessor((CellProcessor)new LowerCaseProcessor(true, false));
        for (String sheetName : listOfEntity) {
            if (sheetName.equals("dataset")) {
                this.mkMetadataFileDataSet((WritableFactory)excelWriterMD, sheetName);
                continue;
            }
            if (sheetName.equals("protocol")) {
                this.mkMetadataFileProtocol((WritableFactory)excelWriterMD, sheetName);
                continue;
            }
            if (sheetName.equals("observableFeature")) {
                this.mkMetadataFileObservableFeature((WritableFactory)excelWriterMD, sheetName);
                continue;
            }
            excelWriterMD.createWritable(sheetName, Collections.emptyList());
        }
        excelWriterMD.close();
    }
}

