/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.tools.gids.convertor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.tools.gids.convertor.SampleConverter;

public class ConvertGidsMain {
    public static void main(String[] args) throws IOException, MolgenisInvalidFormatException {
        if (args.length != 3) {
            System.err.println("To run this script it needs 3 arguments; \n1) directory\n2) an outputdirectory\n3) a projectname\nThe project name should be the same name as the inputfile name e.g.\nargs[0] /Users/Roan/Work/GIDS_8_May/Cohorts/Bloodbank/\nargs[1] Converted/\nargs[2] Bloodbank");
            return;
        }
        String DIRECTORY = args[0];
        String OUTPUTDIR = DIRECTORY + args[1];
        String PROJECTNAME = args[2];
        SampleConverter sample = new SampleConverter();
        FileInputStream is = new FileInputStream(DIRECTORY + PROJECTNAME + ".xls");
        File theDir = new File(OUTPUTDIR + PROJECTNAME);
        if (!theDir.exists()) {
            boolean success = theDir.mkdir();
            if (success) {
                System.out.println("Directory: " + theDir + " created");
            } else {
                System.out.println("FAIL to make the directory");
            }
        }
        String newOutput = theDir + "/";
        FileOutputStream os = new FileOutputStream(newOutput + PROJECTNAME + "_Output.csv");
        sample.convert((InputStream)is, (OutputStream)os, newOutput, PROJECTNAME);
        System.out.println("Program is finished");
    }
}

