/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.gaf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.gaf.GAFCol;
import org.molgenis.gaf.GafListSettings;
import org.molgenis.gaf.GafListValidationError;
import org.molgenis.gaf.GafListValidationReport;
import org.molgenis.gaf.GafListValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.stereotype.Component;

@Component
public class GafListValidator {
    private static final Logger LOG = LoggerFactory.getLogger(GafListValidator.class);
    public static final List<String> COLUMNS = GAFCol.getAllColumnsNames();
    static final String BARCODE_NONE = "None";
    @Autowired
    private DataService dataService;
    @Autowired
    private GafListSettings gafListSettings;

    public GafListValidationReport validate(GafListValidationReport report, Repository repository, List<String> columns) throws IOException {
        String gaflistEntityName = this.gafListSettings.getEntityName();
        EntityMetaData entityMetaData = this.dataService.getEntityMetaData(gaflistEntityName);
        if (null == entityMetaData) {
            report.addGlobalErrorMessage("Please contact the administrator, the metadata is not loaded correctly");
        } else {
            HashMap<String, Pattern> patternMap = new HashMap<String, Pattern>();
            for (String string : columns) {
                String string2 = this.gafListSettings.getRegExpPattern(string);
                if (string2 == null) continue;
                patternMap.put(string, Pattern.compile(string2));
            }
            HashMap<String, String> patternExampleMap = new HashMap<String, String>();
            for (String string : columns) {
                String example = this.gafListSettings.getExample(string);
                if (example == null) continue;
                patternExampleMap.put(string, example);
            }
            HashMap<String, List> hashMap = new HashMap<String, List>();
            for (String colName : columns) {
                AttributeMetaData attributeMetaData = entityMetaData.getAttribute(colName);
                if (!MolgenisFieldTypes.FieldTypeEnum.ENUM.equals((Object)attributeMetaData.getDataType().getEnumType())) continue;
                List enumList = attributeMetaData.getEnumOptions();
                hashMap.put(colName, enumList);
            }
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            Iterable attributes = repository.getEntityMetaData().getAttributes();
            for (Entity entity : repository) {
                String runId = entity.getString(GAFCol.RUN.toString());
                report.getAllRunIds().add(runId);
                arrayList.add(entity);
            }
            this.validateCellValues(arrayList, attributes, patternMap, patternExampleMap, hashMap, report);
            this.validateInternalSampleIdIncremental(arrayList, report);
            this.validateRun(arrayList, report);
            report.populateStatusImportedRuns();
        }
        return report;
    }

    private void validateCellValues(List<Entity> entities, Iterable<AttributeMetaData> attributes, Map<String, Pattern> patternMap, Map<String, String> patternExampleMap, Map<String, List<String>> lookupLists, GafListValidationReport report) {
        int row = 2;
        for (Entity entity : entities) {
            if (this.isEmptyRow(entity)) continue;
            String runId = entity.getString(GAFCol.RUN.toString());
            String sampleType = entity.getString(GAFCol.SAMPLE_TYPE.toString());
            for (AttributeMetaData attributeMetaData : attributes) {
                String attributeName = attributeMetaData.getName().trim();
                if (attributeName.isEmpty()) continue;
                String value = entity.getString(attributeName);
                this.validateCell(runId, row, attributeName, value, patternMap, patternExampleMap, lookupLists, report, sampleType);
            }
            ++row;
        }
    }

    private void validateInternalSampleIdIncremental(List<Entity> entities, GafListValidationReport report) {
        String gaflistEntityName = this.gafListSettings.getEntityName();
        HashMap<Integer, Integer> toImportInternalSampleIds = new HashMap<Integer, Integer>();
        int row = 2;
        for (Entity entity : entities) {
            if (this.isEmptyRow(entity)) continue;
            String runId = entity.getString(GAFCol.RUN.toString());
            Integer internalSampleId = null;
            try {
                internalSampleId = entity.getInt(GAFCol.INTERNAL_SAMPLE_ID.toString());
                if (internalSampleId == null) {
                    report.addEntry(runId, new GafListValidationError(row, GAFCol.INTERNAL_SAMPLE_ID.toString(), null, "value undefined"));
                }
                if (this.internalSampleIdExists(gaflistEntityName, internalSampleId)) {
                    report.addEntry(runId, new GafListValidationError(row, GAFCol.INTERNAL_SAMPLE_ID.toString(), internalSampleId.toString(), "Internal sample id " + internalSampleId + " already imported"));
                } else if (toImportInternalSampleIds.containsKey(internalSampleId)) {
                    report.addEntry(runId, new GafListValidationError(row, GAFCol.INTERNAL_SAMPLE_ID.toString(), internalSampleId.toString(), "Duplicate internal sample id " + internalSampleId + ". First encountered on row " + toImportInternalSampleIds.get(internalSampleId) + " in this file"));
                } else {
                    toImportInternalSampleIds.put(internalSampleId, new Integer(row));
                }
            }
            catch (ConversionFailedException cfe) {
                new GafListValidationError(row, GAFCol.INTERNAL_SAMPLE_ID.toString(), null, "value is not formatted correctly it need to be a number");
            }
            ++row;
        }
    }

    private boolean internalSampleIdExists(String gaflistEntityName, Integer internalSampleId) {
        QueryImpl q = new QueryImpl();
        q.eq(GAFCol.INTERNAL_SAMPLE_ID.toString(), (Object)internalSampleId);
        return null != this.dataService.findOne(gaflistEntityName, (Query)q);
    }

    private void validateRun(List<Entity> entities, GafListValidationReport report) {
        List<Object> entityRowPairs;
        String runId;
        HashMap<String, ArrayList<EntityRowPair>> runMap = new HashMap<String, ArrayList<EntityRowPair>>();
        int row = 2;
        for (Entity entity : entities) {
            if (this.isEmptyRow(entity)) continue;
            runId = entity.getString(GAFCol.RUN.toString());
            if (runId != null) {
                entityRowPairs = (List)runMap.get(runId);
                if (entityRowPairs == null) {
                    entityRowPairs = new ArrayList<EntityRowPair>();
                    runMap.put(runId, (ArrayList<EntityRowPair>)entityRowPairs);
                }
                entityRowPairs.add(new EntityRowPair(entity, row));
            }
            ++row;
        }
        for (Map.Entry entry : runMap.entrySet()) {
            runId = (String)entry.getKey();
            entityRowPairs = (ArrayList<EntityRowPair>)entry.getValue();
            String runSeqType = null;
            for (EntityRowPair entityRowPair : entityRowPairs) {
                String seqType = entityRowPair.getEntity().getString(GAFCol.SEQ_TYPE.toString());
                if (runSeqType == null) {
                    runSeqType = seqType;
                    continue;
                }
                if (runSeqType.equals(seqType)) continue;
                report.addEntry(runId, new GafListValidationError(entityRowPair.getRow(), GAFCol.SEQ_TYPE.toString(), seqType, "run has different " + GAFCol.SEQ_TYPE.toString()));
            }
            String runSeqStartDate = null;
            for (EntityRowPair entityRowPair3 : entityRowPairs) {
                String string = entityRowPair3.getEntity().getString(GAFCol.SEQUENCING_START_DATE.toString());
                if (runSeqStartDate == null) {
                    runSeqStartDate = string;
                    continue;
                }
                if (runSeqStartDate.equals(string)) continue;
                report.addEntry(runId, new GafListValidationError(entityRowPair3.getRow(), GAFCol.SEQUENCING_START_DATE.toString(), string, "run has different " + GAFCol.SEQUENCING_START_DATE.toString()));
            }
            HashMap<String, ArrayList<EntityRowPair>> hashMap = new HashMap<String, ArrayList<EntityRowPair>>();
            for (EntityRowPair entityRowPair : entityRowPairs) {
                Entity laneEntity = entityRowPair.getEntity();
                String lane = laneEntity.getString(GAFCol.LANE.toString());
                if (lane == null) continue;
                List<Object> laneEntityRowPairs = (List)hashMap.get(lane);
                if (laneEntityRowPairs == null) {
                    laneEntityRowPairs = new ArrayList<EntityRowPair>();
                    hashMap.put(lane, (ArrayList<EntityRowPair>)laneEntityRowPairs);
                }
                laneEntityRowPairs.add(new EntityRowPair(laneEntity, entityRowPair.getRow()));
            }
            for (Map.Entry entry2 : hashMap.entrySet()) {
                List laneEntityRowPairs = (List)entry2.getValue();
                String laneBarcodeType = null;
                for (EntityRowPair laneEntityRowPair : laneEntityRowPairs) {
                    Entity laneEntity = laneEntityRowPair.getEntity();
                    String barcodeType = laneEntity.getString(GAFCol.BARCODE_TYPE.toString());
                    if (laneBarcodeType == null) {
                        laneBarcodeType = barcodeType;
                        continue;
                    }
                    if (laneBarcodeType.equals(barcodeType)) continue;
                    report.addEntry(runId, new GafListValidationError(laneEntityRowPair.getRow(), GAFCol.BARCODE_TYPE.toString(), barcodeType, "run lane has different " + GAFCol.BARCODE_TYPE + " (expected: " + laneBarcodeType + ")"));
                }
                HashSet<String> barcodes = new HashSet<String>();
                for (EntityRowPair laneEntityRowPair : laneEntityRowPairs) {
                    Entity laneEntity = laneEntityRowPair.getEntity();
                    String barcode = laneEntity.getString(GAFCol.BARCODE.toString());
                    if (BARCODE_NONE.equals(barcode)) continue;
                    if (barcodes.contains(barcode)) {
                        report.addEntry(runId, new GafListValidationError(laneEntityRowPair.getRow(), GAFCol.BARCODE.toString(), barcode, "run lane has duplicate " + GAFCol.BARCODE.toString()));
                        continue;
                    }
                    barcodes.add(barcode);
                }
            }
        }
    }

    private boolean isEmptyRow(Entity entity) {
        boolean isEmptyRow = true;
        for (String attributeName : entity.getAttributeNames()) {
            if (attributeName.equals(GAFCol.INTERNAL_SAMPLE_ID.toString()) || !StringUtils.isNotEmpty((CharSequence)entity.getString(attributeName))) continue;
            isEmptyRow = false;
            break;
        }
        return isEmptyRow;
    }

    private void validateCell(String runId, int row, String colName, String value, Map<String, Pattern> patterns, Map<String, String> patternExampleMap, Map<String, List<String>> lookupLists, GafListValidationReport report, String sampleType) {
        if (colName.equalsIgnoreCase(GAFCol.INTERNAL_SAMPLE_ID.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.LANE.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.SEQUENCER.toString())) {
            this.validateCellWithLookupList(runId, row, colName, value, lookupLists, true, report, patternExampleMap);
        } else if (colName.equalsIgnoreCase(GAFCol.SEQUENCING_START_DATE.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.RUN.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.FLOWCELL.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.SEQ_TYPE.toString())) {
            this.validateCellWithLookupList(runId, row, colName, value, lookupLists, true, report, patternExampleMap);
        } else if (colName.equalsIgnoreCase(GAFCol.BARCODE_1.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.EXTERNAL_SAMPLE_ID.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.PROJECT.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.CONTACT.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.SAMPLE_TYPE.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, true, report);
        } else if (colName.equalsIgnoreCase(GAFCol.ARRAY_FILE.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.ARRAY_ID.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.CAPTURING_KIT.toString())) {
            if ("DNA".equals(sampleType)) {
                this.validateCellWithLookupList(runId, row, colName, value, lookupLists, true, report, patternExampleMap);
            }
        } else if (colName.equalsIgnoreCase(GAFCol.PREP_KIT.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.GAF_QC_NAME.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.GAF_QC_DATE.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.GAF_QC_STATUS.toString())) {
            this.validateCellWithLookupList(runId, row, colName, value, lookupLists, true, report, patternExampleMap);
        } else if (colName.equalsIgnoreCase(GAFCol.GCC_ANALYSIS.toString())) {
            this.validateCellWithLookupList(runId, row, colName, value, lookupLists, false, report, patternExampleMap);
        } else if (colName.equalsIgnoreCase(GAFCol.BARCODE_2.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.BARCODE.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else if (colName.equalsIgnoreCase(GAFCol.BARCODE_TYPE.toString())) {
            this.validateCellWithPattern(runId, row, colName, value, patterns, patternExampleMap, false, report);
        } else {
            LOG.warn("unknown col [" + colName + "]");
        }
    }

    private void validateCellWithPattern(String runId, int row, String colName, String value, Map<String, Pattern> patterns, Map<String, String> patternExampleMap, boolean isRequired, GafListValidationReport report) {
        Pattern pattern = patterns.get(colName);
        if (isRequired) {
            if (StringUtils.isEmpty((CharSequence)value) || pattern != null && !pattern.matcher(value).matches()) {
                report.addEntry(runId, new GafListValidationError(row, colName, value, this.getPatternErrorMessage(colName, patternExampleMap)));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)value) && pattern != null && !pattern.matcher(value).matches()) {
            report.addEntry(runId, new GafListValidationError(row, colName, value, this.getPatternErrorMessage(colName, patternExampleMap)));
        }
    }

    private void validateCellWithLookupList(String runId, int row, String colName, String value, Map<String, List<String>> lookupLists, boolean isRequired, GafListValidationReport report, Map<String, String> patternExampleMap) {
        List<String> lookupList = lookupLists.get(colName);
        if (isRequired) {
            if (StringUtils.isEmpty((CharSequence)value) || !lookupList.contains(value)) {
                report.addEntry(runId, new GafListValidationError(row, colName, value, this.getPatternErrorMessage(colName, patternExampleMap)));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)value) && !lookupList.contains(value)) {
            report.addEntry(runId, new GafListValidationError(row, colName, value, this.getPatternErrorMessage(colName, patternExampleMap)));
        }
    }

    private String getPatternErrorMessage(String colName, Map<String, String> patternExampleMap) {
        String message = patternExampleMap.get(colName);
        if (null == message) {
            message = "Something went wrong!";
        }
        return message;
    }
}

