/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import freemarker.cache.TemplateLoader;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.molgenis.CommandLineOnlyConfiguration;
import org.molgenis.DatabaseConfig;
import org.molgenis.app.WebAppConfig;
import org.molgenis.app.WebAppSecurityConfig;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.ManageableRepositoryCollection;
import org.molgenis.data.config.HttpClientConfig;
import org.molgenis.data.elasticsearch.ElasticsearchRepositoryCollection;
import org.molgenis.data.elasticsearch.config.EmbeddedElasticSearchConfig;
import org.molgenis.data.elasticsearch.factory.EmbeddedElasticSearchServiceFactory;
import org.molgenis.data.mysql.MySqlEntityFactory;
import org.molgenis.data.support.DataServiceImpl;
import org.molgenis.data.system.RepositoryTemplateLoader;
import org.molgenis.dataexplorer.freemarker.DataExplorerHyperlinkDirective;
import org.molgenis.framework.MolgenisUpgrade;
import org.molgenis.migrate.version.v1_11.Step20RebuildElasticsearchIndex;
import org.molgenis.migrate.version.v1_11.Step21SetLoggingEventBackend;
import org.molgenis.migrate.version.v1_13.Step22RemoveDiseaseMatcher;
import org.molgenis.migrate.version.v1_14.Step23RebuildElasticsearchIndex;
import org.molgenis.migrate.version.v1_15.Step24UpdateApplicationSettings;
import org.molgenis.migrate.version.v1_15.Step25LanguagesPermissions;
import org.molgenis.migrate.version.v1_16.Step26migrateJpaBackend;
import org.molgenis.migrate.version.v1_17.Step27MetaDataAttributeRoles;
import org.molgenis.migrate.version.v1_19.Step28MigrateSorta;
import org.molgenis.migrate.version.v1_21.Step29MigrateJobExecutionProgressMessage;
import org.molgenis.migrate.version.v1_21.Step30MigrateJobExecutionUser;
import org.molgenis.migrate.version.v1_22.Step31UpdateApplicationSettings;
import org.molgenis.ui.MolgenisWebAppConfig;
import org.molgenis.util.DependencyResolver;
import org.molgenis.util.GsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@EnableTransactionManagement
@EnableWebMvc
@EnableAsync
@ComponentScan(basePackages={"org.molgenis"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={CommandLineOnlyConfiguration.class})})
@Import(value={WebAppSecurityConfig.class, DatabaseConfig.class, HttpClientConfig.class, EmbeddedElasticSearchConfig.class, GsonConfig.class})
public class WebAppConfig
extends MolgenisWebAppConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppConfig.class);
    @Autowired
    private DataService dataService;
    @Autowired
    @Qualifier(value="MysqlRepositoryCollection")
    private ManageableRepositoryCollection mysqlRepositoryCollection;
    @Autowired
    private ElasticsearchRepositoryCollection elasticsearchRepositoryCollection;
    @Autowired
    private EmbeddedElasticSearchServiceFactory embeddedElasticSearchServiceFactory;
    @Autowired
    private Gson gson;
    @Autowired
    private Step20RebuildElasticsearchIndex step20RebuildElasticsearchIndex;
    @Autowired
    private Step23RebuildElasticsearchIndex step23RebuildElasticsearchIndex;

    public ManageableRepositoryCollection getBackend() {
        return this.mysqlRepositoryCollection;
    }

    public void addUpgrades() {
        this.upgradeService.addUpgrade((MolgenisUpgrade)this.step20RebuildElasticsearchIndex);
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step21SetLoggingEventBackend(this.dataSource));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step22RemoveDiseaseMatcher(this.dataSource));
        this.upgradeService.addUpgrade((MolgenisUpgrade)this.step23RebuildElasticsearchIndex);
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step24UpdateApplicationSettings(this.dataSource, this.idGenerator));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step25LanguagesPermissions(this.dataService));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step26migrateJpaBackend(this.dataSource, "MySQL", this.idGenerator));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step27MetaDataAttributeRoles(this.dataSource));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step28MigrateSorta(this.dataSource));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step29MigrateJobExecutionProgressMessage(this.dataSource));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step30MigrateJobExecutionUser(this.dataSource));
        this.upgradeService.addUpgrade((MolgenisUpgrade)new Step31UpdateApplicationSettings(this.dataSource, this.idGenerator));
    }

    protected void addReposToReindex(DataServiceImpl localDataService, MySqlEntityFactory localMySqlEntityFactory) {
        1 backend = new /* Unavailable Anonymous Inner Class!! */;
        localDataService.getMeta().setDefaultBackend((ManageableRepositoryCollection)backend);
        List metas = DependencyResolver.resolve((Set)Sets.newHashSet((Iterable)localDataService.getMeta().getEntityMetaDatas()));
        for (EntityMetaData emd : metas) {
            if (emd.isAbstract() || localDataService.hasRepository(emd.getName())) continue;
            if ("MySQL".equals(emd.getBackend())) {
                localDataService.addRepository(backend.addEntityMeta(emd));
                continue;
            }
            if ("ElasticSearch".equals(emd.getBackend())) {
                localDataService.addRepository(this.elasticsearchRepositoryCollection.addEntityMeta(emd));
                continue;
            }
            LOG.warn("backend [{}] unknown for meta data [{}]", (Object)emd.getBackend(), (Object)emd.getName());
        }
    }

    protected void addFreemarkerVariables(Map<String, Object> freemarkerVariables) {
        freemarkerVariables.put("dataExplorerLink", new DataExplorerHyperlinkDirective(this.molgenisPluginRegistry(), this.dataService));
    }

    public FreeMarkerConfigurer freeMarkerConfigurer() throws IOException, TemplateException {
        FreeMarkerConfigurer result = super.freeMarkerConfigurer();
        result.setPostTemplateLoaders(new TemplateLoader[]{new RepositoryTemplateLoader(this.dataService)});
        return result;
    }
}

