/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.meta;

import java.util.Collections;
import java.util.Map;

public abstract class VcfMetaEntry {
    protected final Map<String, String> properties;

    public VcfMetaEntry(Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        this.properties = properties;
    }

    public abstract String getName();

    public String get(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        String prefix = this.getName() + '\t';
        StringBuilder strBuilder = new StringBuilder(prefix);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (strBuilder.length() > prefix.length()) {
                strBuilder.append(' ');
            }
            strBuilder.append(entry.getKey()).append('=').append('[').append(entry.getValue()).append(']');
        }
        strBuilder.append('\n');
        return strBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VcfMetaEntry other = (VcfMetaEntry)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

