/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant.id;

import java.util.List;
import org.molgenis.genotype.variant.id.BlankGeneticVariantId;
import org.molgenis.genotype.variant.id.ListGeneticVariantId;
import org.molgenis.genotype.variant.id.SingleGeneticVariantId;

public abstract class GeneticVariantId
implements Iterable<String> {
    public static final String DEFAULT_ID_SEPARATOR = ";";
    public static final BlankGeneticVariantId BLANK_GENETIC_VARIANT_ID = new BlankGeneticVariantId();

    public abstract String getPrimairyId();

    public abstract List<String> getVariantIds();

    public abstract List<String> getAlternativeIds();

    public abstract String getConcatenatedId();

    public abstract String getConcatenatedId(String var1);

    public abstract boolean isIdInVariantIds(String var1);

    public abstract boolean onlyPrimairyId();

    public abstract boolean containsId();

    public boolean isSameId(GeneticVariantId otherVariantId) {
        if (!this.containsId() || !otherVariantId.containsId()) {
            return false;
        }
        if (this.onlyPrimairyId() && otherVariantId.onlyPrimairyId()) {
            return this.getPrimairyId().equals(otherVariantId.getPrimairyId());
        }
        if (this.onlyPrimairyId()) {
            if (otherVariantId.isIdInVariantIds(this.getPrimairyId())) {
                return true;
            }
        } else if (otherVariantId.onlyPrimairyId()) {
            if (this.isIdInVariantIds(otherVariantId.getPrimairyId())) {
                return true;
            }
        } else {
            for (String thisId : this) {
                if (!otherVariantId.isIdInVariantIds(thisId)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static GeneticVariantId createVariantId() {
        return BLANK_GENETIC_VARIANT_ID;
    }

    public static GeneticVariantId createVariantId(String id) {
        if (id == null || id.equals(".") || id.equals(" ")) {
            return BLANK_GENETIC_VARIANT_ID;
        }
        return new SingleGeneticVariantId(id);
    }

    public static GeneticVariantId createVariantId(List<String> ids) {
        if (ids == null || ids.size() == 0) {
            return BLANK_GENETIC_VARIANT_ID;
        }
        if (ids.size() == 1) {
            return new SingleGeneticVariantId(ids.get(0));
        }
        return new ListGeneticVariantId(ids);
    }

    public static GeneticVariantId createVariantId(String primaryId, List<String> alternativeIds) {
        if (primaryId == null) {
            return GeneticVariantId.createVariantId(alternativeIds);
        }
        if (alternativeIds == null || alternativeIds.isEmpty()) {
            return new SingleGeneticVariantId(primaryId);
        }
        return new ListGeneticVariantId(primaryId, alternativeIds);
    }

    public String toString() {
        return this.getPrimairyId();
    }
}

