/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.MafCalculator;
import org.molgenis.genotype.variant.AbstractGeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.id.GeneticVariantId;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class ReadOnlyGeneticVariantTriTyper
extends AbstractGeneticVariant {
    private final GeneticVariantId variantId;
    private final int startPos;
    private final String sequenceName;
    private final SampleVariantsProvider sampleVariantsProvider;
    private final int indexOfVariantInTriTyperData;
    private Alleles alleles;
    private final GeneticVariantMeta variantMeta;

    public ReadOnlyGeneticVariantTriTyper(String variantId, int startPos, String sequenceName, SampleVariantsProvider sampleVariantsProvider, int indexOfVariantInTriTyperData, GeneticVariantMeta variantMeta) {
        this.variantId = GeneticVariantId.createVariantId(variantId);
        this.startPos = startPos;
        this.sequenceName = sequenceName;
        this.sampleVariantsProvider = sampleVariantsProvider;
        this.indexOfVariantInTriTyperData = indexOfVariantInTriTyperData;
        this.variantMeta = variantMeta;
    }

    @Override
    public String getPrimaryVariantId() {
        return this.variantId.getPrimairyId();
    }

    @Override
    public List<String> getAlternativeVariantIds() {
        return this.variantId.getAlternativeIds();
    }

    @Override
    public List<String> getAllIds() {
        return this.variantId.getVariantIds();
    }

    @Override
    public GeneticVariantId getVariantId() {
        return this.variantId;
    }

    @Override
    public int getStartPos() {
        return this.startPos;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public final Alleles getVariantAlleles() {
        if (this.alleles == null) {
            this.getSampleVariants();
        }
        return this.alleles;
    }

    @Override
    public int getAlleleCount() {
        return this.getVariantAlleles().getAlleleCount();
    }

    @Override
    public Allele getRefAllele() {
        return this.getVariantAlleles().get(0);
    }

    @Override
    public List<Alleles> getSampleVariants() {
        List<Alleles> sampleVariantAlleles = Collections.unmodifiableList(this.sampleVariantsProvider.getSampleVariants(this));
        if (this.alleles == null) {
            LinkedHashSet<Allele> variantAlleles = new LinkedHashSet<Allele>(2);
            for (Alleles alleles2 : sampleVariantAlleles) {
                for (Allele allele : alleles2) {
                    if (allele == Allele.ZERO) continue;
                    variantAlleles.add(allele);
                }
            }
            this.alleles = Alleles.createAlleles(new ArrayList<Allele>(variantAlleles));
        }
        return sampleVariantAlleles;
    }

    @Override
    public Map<String, ?> getAnnotationValues() {
        return Collections.emptyMap();
    }

    @Override
    public double getMinorAlleleFrequency() {
        return MafCalculator.calculateMaf(this.getVariantAlleles(), this.getRefAllele(), this.getSampleVariants()).getFreq();
    }

    @Override
    public Allele getMinorAllele() {
        return MafCalculator.calculateMaf(this.getVariantAlleles(), this.getRefAllele(), this.getSampleVariants()).getMinorAllele();
    }

    @Override
    public float[] getSampleDosages() {
        return this.sampleVariantsProvider.getSampleDosage(this);
    }

    @Override
    public SampleVariantsProvider getSampleVariantsProvider() {
        return this.sampleVariantsProvider;
    }

    @Override
    public byte[] getSampleCalledDosages() {
        return this.sampleVariantsProvider.getSampleCalledDosage(this);
    }

    @Override
    public List<Boolean> getSamplePhasing() {
        return this.sampleVariantsProvider.getSamplePhasing(this);
    }

    @Override
    public float[][] getSampleGenotypeProbilities() {
        return this.sampleVariantsProvider.getSampleProbilities(this);
    }

    @Override
    public int hashCode() {
        return this.getPrimaryVariantId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReadOnlyGeneticVariantTriTyper)) {
            return false;
        }
        ReadOnlyGeneticVariantTriTyper other = (ReadOnlyGeneticVariantTriTyper)obj;
        if (this.getPrimaryVariantId() != null && other.getPrimaryVariantId() != null) {
            return this.getPrimaryVariantId().equals(other.getPrimaryVariantId());
        }
        if (this.getSequenceName() == null ? other.getSequenceName() != null : !this.getSequenceName().equals(other.getSequenceName())) {
            return false;
        }
        if (this.getStartPos() != other.getStartPos()) {
            return false;
        }
        if (this.getSampleVariantsProvider() == null) {
            if (other.getSampleVariantsProvider() != null) {
                return false;
            }
        } else if (!this.getSampleVariantsProvider().equals(other.getSampleVariantsProvider())) {
            return this.variantId.getPrimairyId().equals(other.getPrimaryVariantId());
        }
        return true;
    }

    public int getIndexOfVariantInTriTyperData() {
        return this.indexOfVariantInTriTyperData;
    }

    @Override
    public GeneticVariantMeta getVariantMeta() {
        return this.variantMeta;
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords() {
        return this.sampleVariantsProvider.getSampleGenotypeRecords(this);
    }
}

