/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant;

import java.util.Collections;
import java.util.Map;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.variant.GenotypeRecord;

public class GenotypeRecordMap
implements GenotypeRecord {
    private final Map<String, Object> fields;

    public GenotypeRecordMap(Map<String, Object> fields) {
        this.fields = Collections.unmodifiableMap(fields);
    }

    @Override
    public Object getGenotypeRecordData(String recordId) {
        return this.fields.get(recordId);
    }

    @Override
    public Alleles getSampleAlleles() {
        return (Alleles)this.fields.get("GT");
    }

    @Override
    public float[] getSampleProbs() {
        return (float[])this.fields.get("GP");
    }

    @Override
    public float getSampleDosage() {
        return ((Float)this.fields.get("DS")).floatValue();
    }

    @Override
    public boolean containsGenotypeRecord(String recordId) {
        return this.fields.containsKey(recordId);
    }
}

