/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.snpeff;

import org.apache.commons.lang3.StringUtils;
import org.molgenis.genotype.snpeff.SnpEffEffect;

public final class SnpEffAnnotationTranslator {
    private static final int EFFECT_TYPE_FIELD = 0;
    private static final int EFFECT_INPACT_FIELD = 1;
    private static final int FUNCTIONAL_CLASS_FIELD = 2;

    public static SnpEffEffect[] translateSnpEffVcfField(String field) throws Exception {
        field = field.subSequence(4, field.length()).toString();
        String[] effectStrings = StringUtils.split(field, ',');
        SnpEffEffect[] effects = new SnpEffEffect[effectStrings.length];
        int i = 0;
        for (String effectString : effectStrings) {
            effects[i] = SnpEffAnnotationTranslator.translateSnpEffEffectString(effectString);
            ++i;
        }
        return effects;
    }

    private static SnpEffEffect translateSnpEffEffectString(String effectString) throws Exception {
        SnpEffEffect.FunctionalClass effectFunctionalClass;
        SnpEffEffect.EffectImpact effectImpact;
        SnpEffEffect.EffectType effectType;
        String[] effectFields = StringUtils.splitPreserveAllTokens(effectString, "(|)");
        if (effectFields.length < 11) {
            throw new Exception("Error parsing SnpEff annotation field count: " + effectFields.length + "\n\t" + effectString);
        }
        try {
            effectType = SnpEffEffect.EffectType.valueOf(effectFields[0]);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Error parsing " + effectFields[0] + " as EffectType, Field: " + effectString);
            throw ex;
        }
        try {
            effectImpact = SnpEffEffect.EffectImpact.valueOf(effectFields[1]);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Error parsing " + effectFields[1] + " as EffectImpact, Field: " + effectString);
            throw ex;
        }
        if (effectFields[2].length() == 0) {
            effectFunctionalClass = SnpEffEffect.FunctionalClass.NONE;
        } else {
            try {
                effectFunctionalClass = SnpEffEffect.FunctionalClass.valueOf(effectFields[2]);
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Error parsing " + effectFields[2] + " as FunctionalClass, Field: " + effectString);
                throw ex;
            }
        }
        return new SnpEffEffect(effectType, effectImpact, effectFunctionalClass);
    }
}

